/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.Constants;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.PluginModelObject;
import com.ibm.ws.extension.thinregistry.ResourceHelper;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.spi.RegistryContributor;

public class PluginDescriptor
extends PluginModelObject
implements IPluginDescriptor {
    private String _uniqueId = null;
    private RegistryContributor _contributor = null;
    private String _providerName = null;
    private String _className = null;
    private HashMap _extensions = new HashMap();
    private HashMap _extensionPoints = new HashMap();
    private URL _url = null;
    private transient ClassLoader _classLoader = null;
    private Class _class = null;

    public IExtension getExtension(String extSimpleId) {
        return extSimpleId != null ? (IExtension)this._extensions.get(extSimpleId) : null;
    }

    public IExtensionPoint getExtensionPoint(String xptSimpleId) {
        return xptSimpleId != null ? (IExtensionPoint)this._extensionPoints.get(xptSimpleId) : null;
    }

    public IExtensionPoint[] getExtensionPoints() {
        int sz = this._extensionPoints.size();
        if (0 < sz) {
            return this._extensionPoints.values().toArray(new ExtensionPoint[sz]);
        }
        return Constants.EMPTY_EXTENSIONPOINT_ARRAY;
    }

    public IExtension[] getExtensions() {
        int sz = this._extensions.size();
        if (0 < sz) {
            return this._extensions.values().toArray(new Extension[sz]);
        }
        return Constants.EMPTY_EXTENSION_ARRAY;
    }

    public URL getInstallURL() {
        return this._url;
    }

    public String getLabel() {
        return this.getLabel(this);
    }

    public ClassLoader getPluginClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String getProviderName() {
        return this._providerName;
    }

    public String getUniqueIdentifier() {
        return this._uniqueId;
    }

    public RegistryContributor getContributor() {
        return this._contributor;
    }

    public boolean isPluginActivated() {
        return true;
    }

    void setProviderName(String providerName) {
        this._providerName = providerName;
    }

    void setUniqueIdentifier(String uniqueIdentifier) {
        this._uniqueId = uniqueIdentifier;
        this._contributor = new RegistryContributor(uniqueIdentifier, uniqueIdentifier, null, null);
    }

    void setExtensionPoints(Collection extensionPoints) {
        this._extensionPoints.clear();
        if (extensionPoints != null) {
            for (ExtensionPoint xpt : extensionPoints) {
                String id = xpt.getSimpleIdentifier();
                if (id.indexOf(46) == -1) {
                    this._extensionPoints.put(xpt.getSimpleIdentifier(), xpt);
                    continue;
                }
                if (!LoggingServices.debugEnabled) continue;
                LoggingServices.trace("registry.warning.invalid_ext_pt", id);
            }
        }
    }

    void setExtensions(Collection extensions) {
        this._extensions.clear();
        if (extensions != null) {
            for (Extension ext : extensions) {
                String id = ext.getSimpleIdentifier();
                if (id.indexOf(46) == -1) {
                    this._extensions.put(ext.getSimpleIdentifier(), ext);
                    continue;
                }
                if (!LoggingServices.debugEnabled) continue;
                LoggingServices.trace("registry.warning.invalid_ext", id);
            }
        }
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        return Constants.EMPTY_PLUGINPREREQ_ARRAY;
    }

    void setInstallURL(URL u) {
        this._url = u;
    }

    void setPluginClassLoader(ClassLoader cl) {
        this._classLoader = cl;
    }

    public String toString() {
        return "PluginDescriptor: '" + this.getUniqueIdentifier() + "' [" + this.getVersion() + "]";
    }

    public boolean equals(Object obj) {
        boolean same;
        block6: {
            PluginDescriptor pd;
            block12: {
                ExtensionPoint[] xps;
                int i;
                block11: {
                    block10: {
                        block9: {
                            Extension[] eps;
                            block8: {
                                block7: {
                                    same = false;
                                    if (!(obj instanceof PluginDescriptor) || !this._uniqueId.equals((pd = (PluginDescriptor)obj).getUniqueIdentifier()) || !this.getVersion().equals(pd.getVersion()) || this._providerName != null && !this._providerName.equals(pd.getProviderName()) || this._providerName == null && pd.getProviderName() != null) break block6;
                                    eps = (Extension[])pd.getExtensions();
                                    if (this._extensions != null) break block7;
                                    if (eps == null || 0 >= eps.length) break block8;
                                    break block6;
                                }
                                if (eps != null ? this._extensions.size() != eps.length : 0 < this._extensions.size()) break block6;
                            }
                            if (this._extensions == null || eps == null) break block9;
                            for (i = 0; i < eps.length && this._extensions.containsValue(eps[i]); ++i) {
                            }
                            if (i < eps.length) break block6;
                        }
                        xps = (ExtensionPoint[])pd.getExtensionPoints();
                        if (this._extensionPoints != null) break block10;
                        if (xps == null || 0 >= xps.length) break block11;
                        break block6;
                    }
                    if (xps != null ? this._extensionPoints.size() != xps.length : 0 < this._extensionPoints.size()) break block6;
                }
                if (this._extensionPoints == null || xps == null) break block12;
                for (i = 0; i < xps.length && this._extensionPoints.containsValue(xps[i]); ++i) {
                }
                if (i < xps.length) break block6;
            }
            if (!(this._url != null && !this._url.equals(pd.getInstallURL()) || this._url == null && pd.getInstallURL() != null)) {
                same = true;
            }
        }
        return same;
    }

    public Plugin getPlugin() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return ResourceHelper.getBundle(this);
    }

    public String getResourceString(String value2) {
        return this.getResourceString(value2, this.getResourceBundle());
    }

    public String getResourceString(String value2, ResourceBundle bundle) {
        if (bundle != null) {
            String resStr = value2;
            try {
                resStr = bundle.getString(value2);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return resStr;
        }
        return value2;
    }

    public ILibrary[] getRuntimeLibraries() {
        throw new UnsupportedOperationException();
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        try {
            return new PluginVersionIdentifier(this.getVersion());
        }
        catch (Exception e) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public URL find(IPath path) {
        throw new UnsupportedOperationException();
    }

    public URL find(IPath path, Map override) {
        throw new UnsupportedOperationException();
    }
}

