/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.topography.ConcernImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class SelectionDescriptionImpl
extends DescriptionA
implements SelectionDescription {
    private static final TraceComponent tc = Tr.register(SelectionDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private String[] rules = null;

    public SelectionDescriptionImpl(DescriptionKey key) {
        super(key);
    }

    public String getDefinitionKey() {
        return SelectionDescription.class.getName();
    }

    public void modifyRules(String[] prioritizedRules) {
        this.rules = prioritizedRules;
        this.updateMemento();
    }

    public void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        out.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        if (this.rules == null) {
            out.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote rules length 0");
            }
        } else {
            out.writeInt(this.rules.length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote rules length " + this.rules.length);
            }
            for (int i = 0; i < this.rules.length; ++i) {
                out.writeUTF(this.rules[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "wrote rules " + this.rules[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        MementoImpl newMemento;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        byte version = in.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + version);
        }
        int size = in.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read rules length " + size);
        }
        if (size == 0) {
            MementoImpl.access$002(newMemento, null);
        } else {
            String[] tmpRules = new String[size];
            for (int i = 0; i < size; ++i) {
                tmpRules[i] = in.readUTF();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "read rules " + tmpRules[i]);
            }
            MementoImpl.access$002(newMemento, tmpRules);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public String toString() {
        return new StringBuffer("[").append(Arrays.toString(this.rules)).append(']').toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.7 ");
        }
    }

    public class MementoImpl
    extends DescriptionA.MementoA
    implements SelectionDescription.Memento {
        private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private String[] m_rules = null;

        public Concern getConcern() {
            return this.concern;
        }

        public String[] getRules() {
            return this.m_rules;
        }

        public String toString() {
            return new StringBuffer("[").append(Arrays.toString(this.m_rules)).append(']').toString();
        }

        static /* synthetic */ String[] access$002(MementoImpl x0, String[] x1) {
            x0.m_rules = x1;
            return x1;
        }
    }
}

