/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.ws.cluster.topography.IntrinsicDescriptionA;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClusterMemberDescriptionImpl
extends IntrinsicDescriptionA
implements ClusterMemberDescription {
    private static final TraceComponent tc = Tr.register(ClusterMemberDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected byte availability = 0;
    protected byte reachability = 0;
    protected boolean leaf = true;
    protected String version = "";
    protected Set clusterAssociations = Collections.synchronizedSet(new HashSet());
    private boolean debug = tc.isDebugEnabled();
    protected final Object lock = new Object();

    public ClusterMemberDescriptionImpl(DescriptionKey key) {
        super(key);
    }

    public synchronized void setState(byte state) {
        switch (state) {
            case 0: {
                if (this.reachability != state) {
                    this.setReachability(state);
                    break;
                }
                this.setAvailability(state);
                break;
            }
            case 3: 
            case 4: {
                this.setReachability(state);
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                this.setAvailability(state);
                break;
            }
            default: {
                this.setReachability(state);
                this.setAvailability(state);
            }
        }
    }

    public void setReachability(byte state) {
        if (state != this.reachability) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setReachability [" + this.reachability + "] " + state, this.getKey());
            }
            this.reachability = state;
            this.notifyListeners("type.state.change.reachability", this);
            this.notifyListeners("type.state.change", this);
        }
    }

    public byte getReachability() {
        return this.reachability;
    }

    public void setAvailability(byte state) {
        if (this.availability != state) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "setAvailability [" + this.availability + "] " + state, this.getKey());
            }
            this.availability = state;
            this.updateMemento();
        }
    }

    public synchronized void setVersion(String version) {
        if (version != null) {
            this.version = version;
            this.updateMemento();
        }
    }

    public synchronized void setClusterAssociation(DescriptionKey association) {
        this.clusterAssociations.add(association);
        this.updateMemento();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "adding cluster association", new Object[]{association, this.clusterAssociations});
        }
    }

    public synchronized void removeClusterAssociation(DescriptionKey association) {
        if (this.clusterAssociations.contains(association)) {
            this.clusterAssociations.remove(association);
            this.updateMemento();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "removed cluster association", new Object[]{association, this.clusterAssociations});
            }
        }
    }

    public String getDefinitionKey() {
        return ClusterMemberDescription.class.getName();
    }

    public synchronized void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        out.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote version 0");
        }
        super.exportToStream(out, format);
        int type = format.getType();
        ClusterMemberDescription.Memento memento = null;
        if (type == 3) {
            memento = (ClusterMemberDescription.Memento)this.getMemento();
        }
        byte st = this.availability;
        String ver = this.version;
        if (memento != null) {
            st = memento.getState();
            ver = memento.getVersion();
        }
        out.writeByte(st);
        if (this.debug) {
            Tr.debug(tc, "wrote state " + st);
        }
        out.writeUTF(ver);
        if (this.debug) {
            Tr.debug(tc, "wrote version " + ver);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        MementoImpl newMemento;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        byte streamVersion = in.readByte();
        if (this.debug) {
            Tr.debug(tc, "read version " + streamVersion);
        }
        super.importFromStream(in, format, newMemento);
        newMemento.m_availability = in.readByte();
        if (this.debug) {
            Tr.debug(tc, "read state " + newMemento.m_availability);
        }
        newMemento.m_version = in.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read version " + newMemento.m_version);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[").append(super.toString()).append(" available:").append(this.availability).append(" reachable:").append(this.reachability);
        sb.append(" leaf:").append(this.leaf);
        sb.append(" version:").append(this.version).append(']');
        return sb.toString();
    }

    public void setMemento(Description.Memento memento) {
        MementoImpl newMemento = (MementoImpl)memento;
        MementoImpl currentMemento = (MementoImpl)this.getMemento();
        if (newMemento.m_availability == -128) {
            newMemento.m_availability = 0;
        }
        super.setMemento(memento);
        if (currentMemento.m_availability != newMemento.m_availability) {
            this.notifyListeners("type.state.change.availability", this);
            this.notifyListeners("type.state.change", this);
        }
        if (newMemento.m_availability == 0) {
            this.setReachability((byte)0);
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.29 ");
        }
    }

    public class MementoImpl
    extends IntrinsicDescriptionA.MementoA
    implements ClusterMemberDescription.Memento {
        protected byte m_availability;
        protected String m_version;
        protected Set m_clusterAssociations;

        protected MementoImpl() {
            super(ClusterMemberDescriptionImpl.this);
            this.m_availability = 0;
            this.m_version = "";
            this.m_clusterAssociations = new HashSet();
        }

        public byte getState() {
            if (ClusterMemberDescriptionImpl.this.reachability == 0) {
                return this.m_availability;
            }
            return ClusterMemberDescriptionImpl.this.reachability;
        }

        public byte getReachability() {
            return ClusterMemberDescriptionImpl.this.reachability;
        }

        public byte getAvailability() {
            return this.m_availability;
        }

        public String getVersion() {
            return this.m_version;
        }

        public boolean isLeaf() {
            return true;
        }

        public Set getClusterAssociations() {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "returning cluster association", new Object[]{ClusterMemberDescriptionImpl.this.clusterAssociations});
            }
            return this.m_clusterAssociations;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[").append(super.toString());
            sb.append(" available:").append(this.m_availability);
            sb.append(" version:").append(this.m_version).append(']');
            return sb.toString();
        }
    }
}

