/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.channel.CFEndPointUtility;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class WLMChainEventListener
extends WsComponentImpl
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(WLMChainEventListener.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ChannelFrameworkService cfService;
    private ClusterMemberService cms;
    private Map endpointCache = new HashMap();
    private Map endpointCacheforInprocess = new HashMap();
    private AdminService adminService;
    private String ivCellName = "";
    private String ivNodeName = "";
    private String ivProcessName = "";
    private CFEndPointUtility cfepUtility = null;

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{config});
        }
        try {
            this.cms = WsServiceRegistry.getService(this, ClusterMemberService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, WLMChainEventListener.class.getName() + ".initialize", "127");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService ClusterMemberService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.adminService = AdminServiceFactory.getAdminService();
        String processType = this.adminService.getProcessType();
        if (processType.equals("AdminAgent") || processType.equals("JobManager")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize - running in a ADMIN_AGENT_PROCESS or JOB_MANAGER_PROCESS throwing ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        try {
            this.cfService = WsServiceRegistry.getService(this, ChannelFrameworkService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, WLMChainEventListener.class.getName() + ".initialize", "142");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService ChannelFrameworkService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (this.cfService == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ChannelFrameworkService is unavailable.  Shutting down the ChainEventListener");
            }
            throw new ComponentDisabledException();
        }
        this.cfepUtility = new CFEndPointUtility();
        try {
            WsServiceRegistry.addService(this, WLMChainEventListener.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, WLMChainEventListener.class.getName() + ".initialize", "163");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            this.ivCellName = this.adminService.getCellName();
            this.ivNodeName = this.adminService.getNodeName();
            this.ivProcessName = this.adminService.getProcessName();
            try {
                this.cfService.addChainEventListener(this, "all_chains");
            }
            catch (ChainException e) {
                FFDCFilter.processException((Throwable)e, WLMChainEventListener.class.getName() + ".start", "155", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stop");
            }
            try {
                this.cfService.removeChainEventListener(this, "all_chains");
            }
            catch (ChainException e) {
                FFDCFilter.processException((Throwable)e, WLMChainEventListener.class.getName() + ".stop", "176", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "chainStarted", new Object[]{chainData});
            }
            Identity endpointIdentity = null;
            byte[] endPointData = null;
            try {
                CFEndPoint ep;
                block15: {
                    ep = this.cfService.getEndPoint(chainData.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "returned CFEndPoint:", ep);
                    }
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeByte(0);
                        oos.writeObject(ep);
                        endPointData = baos.toByteArray();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, WLMChainEventListener.class.getName() + ".chainStarted", "225", this);
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "unexpected exception ", e);
                    }
                }
                endpointIdentity = this.cfepUtility.mapCFEndPointToIdentity(ep, this.ivCellName, this.ivNodeName, this.ivProcessName);
                EndPoint endpoint = null;
                if (ep.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endpoint isLocal");
                    }
                    endpoint = this.cms.defineLocalScopedData(endpointIdentity, endPointData);
                    this.endpointCacheforInprocess.put(endpointIdentity, endpoint);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Define member scope data ");
                    }
                    endpoint = this.cms.defineMemberScopedData(endpointIdentity, endPointData);
                    this.endpointCache.put(endpointIdentity, endpoint);
                }
            }
            catch (ChainNotInboundException cnie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start an outbound chain.  Only inbound chains be started.", chainData.getName());
                }
            }
            catch (NoCFEndPointException noce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start a chain which includes a channel that does not implement the WSChannelFactory interface.", chainData.getName());
                }
            }
            catch (NullCFEndPointException nullce) {
                FFDCFilter.processException((Throwable)nullce, WLMChainEventListener.class.getName() + ".chainStarted", "254", this);
                Tr.error(tc, "WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", chainData.getName());
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "unexpected exception ", nullce);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStarted");
        }
    }

    public void chainStopped(ChainData chainData) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "chainStopped", new Object[]{chainData});
            }
            try {
                CFEndPoint ep = this.cfService.getEndPoint(chainData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returned CFEndPoint:", ep);
                }
                Identity endpointIdentity = this.cfepUtility.mapCFEndPointToIdentity(ep, this.ivCellName, this.ivNodeName, this.ivProcessName);
                EndPoint endpoint = null;
                endpoint = ep.isLocal() ? (EndPoint)this.endpointCacheforInprocess.remove(endpointIdentity) : (EndPoint)this.endpointCache.remove(endpointIdentity);
                if (endpoint != null) {
                    if (ep.isLocal()) {
                        this.cms.undefineLocalScopedData(endpoint);
                    } else {
                        this.cms.undefineMemberScopedData(endpoint);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The EndPoint associated with chainName was not found in the WLM EndPoint cache.", chainData.getName());
                }
            }
            catch (ChainNotInboundException cnie) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start/stop an outbound chain.  Only inbound chains be started.", chainData.getName());
                }
            }
            catch (NoCFEndPointException noce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start/stop a chain which includes a channel that does not implement the WSChannelFactory interface.", chainData.getName());
                }
            }
            catch (NullCFEndPointException nullce) {
                FFDCFilter.processException((Throwable)nullce, WLMChainEventListener.class.getName() + ".chainStopped", "316", this);
                Tr.error(tc, "WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", chainData);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "unexpected exception ", nullce);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStopped");
        }
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.20 ");
        }
    }
}

