/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChannelTargetRule
implements SelectionRule {
    private static final TraceComponent tc;
    private static final ClusterService clusterService;
    protected static final DescriptionManager descMgr;
    private static final ChannelFrameworkService cfService;
    private RuleArbitrator arbiter = null;
    private CFEndPointCriteria cfEndPointCriteria;
    private int hashCode = 0;

    public ChannelTargetRule(CFEndPointCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("The criteria must not be null.");
        }
        this.cfEndPointCriteria = criteria;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", this.cfEndPointCriteria);
        }
        this.hashCode = (criteria.getChainName() == null ? 0 : criteria.getChainName().hashCode()) + (criteria.getChannelAccessor() == null ? 0 : criteria.getChannelAccessor().hashCode()) + (criteria.isSSLRequired() ? 0 : 1) + (criteria instanceof DetailedCFEndPointCriteria ? ((Object)((DetailedCFEndPointCriteria)criteria).getChainProperties()).hashCode() + Arrays.deepHashCode(((DetailedCFEndPointCriteria)criteria).getOptionalChannelFactories()) : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", String.valueOf(this.hashCode));
        }
    }

    public void subset(List identities, StringBuffer reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "subset", identities);
        }
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            ClusterMemberDescription member;
            ClusterMemberDescription.Memento cmdMemento;
            Identity memberIdentity = (Identity)iter.next();
            if (this.arbiter != null) {
                this.arbiter.registerNotificationType(this, memberIdentity, "type.add.extrinsic");
                this.arbiter.registerNotificationType(this, memberIdentity, "type.remove.extrinsic");
            }
            if (!(cmdMemento = (ClusterMemberDescription.Memento)(member = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)memberIdentity)).getMemento()).isLeaf()) continue;
            EndPoint[] eps = clusterService.matchEndPoints(memberIdentity, ChannelTargetImpl.distinction);
            if (eps == null || eps.length == 0) {
                iter.remove();
                reason.append(memberIdentity);
                reason.append(" removed: no CFEndPoint ");
                continue;
            }
            CFEndPoint[] cfeps = new CFEndPoint[eps.length];
            for (int i = 0; i < eps.length; ++i) {
                EndPoint endPoint = eps[i];
                if (endPoint == null) {
                    if (!tc.isEventEnabled()) break;
                    Tr.event(tc, "No Endpoint in list at position " + i);
                    break;
                }
                if (this.arbiter != null) {
                    this.arbiter.registerNotificationType(this, endPoint.getIdentity(), "type.state.change.reachability");
                    this.arbiter.registerNotificationType(this, endPoint.getIdentity(), "type.memento.updated");
                }
                if (!endPoint.isAvailable()) continue;
                cfeps[i] = IdentityMapping.getCFEndPoint(endPoint.getIdentity());
            }
            if (tc.isDebugEnabled()) {
                StringBuffer debugBuffer = new StringBuffer(this.cfEndPointCriteria.toString());
                debugBuffer.append("[");
                if (this.cfEndPointCriteria instanceof DetailedCFEndPointCriteria) {
                    debugBuffer.append(((DetailedCFEndPointCriteria)this.cfEndPointCriteria).getChainProperties() + ":");
                } else {
                    debugBuffer.append("Not DetailedCFEndPointCriteria:");
                }
                debugBuffer.append(this.cfEndPointCriteria.getChainName() + ":");
                debugBuffer.append(this.cfEndPointCriteria.getChannelAccessor() + ":");
                debugBuffer.append(String.valueOf(this.cfEndPointCriteria.isSSLRequired()));
                debugBuffer.append("]");
                Tr.debug(tc, "subset CFEndPointCriteria= ", debugBuffer);
                Tr.debug(tc, "subset cfeps= ", cfeps);
            }
            if (cfService == null || cfService.determineBestEndPoint(cfeps, this.cfEndPointCriteria) != null) continue;
            iter.remove();
            reason.append(memberIdentity);
            reason.append(" removed: no CFEndPoint matching criteria ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subset", identities);
        }
    }

    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        this.arbiter = coordinator;
    }

    public boolean equals(Object object) {
        Map properties;
        boolean result = true;
        ChannelTargetRule param = null;
        if (!(object instanceof ChannelTargetRule)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "equals called when not same object", object);
            }
            return false;
        }
        param = (ChannelTargetRule)object;
        String chainName = this.cfEndPointCriteria.getChainName();
        if (chainName != null) {
            result = chainName.equals(param.cfEndPointCriteria.getChainName());
        }
        if (!result) {
            return result;
        }
        Map map = properties = this.cfEndPointCriteria instanceof DetailedCFEndPointCriteria ? ((DetailedCFEndPointCriteria)this.cfEndPointCriteria).getChainProperties() : null;
        if (properties != null) {
            result = ((Object)properties).equals(((DetailedCFEndPointCriteria)param.cfEndPointCriteria).getChainProperties());
        }
        if (!result) {
            return result;
        }
        Class accessor = this.cfEndPointCriteria.getChannelAccessor();
        if (accessor != null) {
            result = accessor.equals(param.cfEndPointCriteria.getChannelAccessor());
        }
        if (!result) {
            return result;
        }
        boolean sslRequired = this.cfEndPointCriteria.isSSLRequired();
        if (sslRequired && param.cfEndPointCriteria.isSSLRequired()) {
            result = true;
        } else {
            boolean bl = result = !sslRequired && !param.cfEndPointCriteria.isSSLRequired();
        }
        if (!result) {
            return result;
        }
        Class[] factories = this.cfEndPointCriteria.getOptionalChannelFactories();
        Class[] otherFactories = param.cfEndPointCriteria.getOptionalChannelFactories();
        if (factories != null && otherFactories != null) {
            int fLength = factories.length;
            int ofLength = otherFactories.length;
            if (fLength > 0 && fLength == ofLength) {
                ArrayList<Class> fList = new ArrayList<Class>();
                for (Class c : factories) {
                    fList.add(c);
                }
                for (Class c : otherFactories) {
                    if (fList.contains(c)) continue;
                    result = false;
                    break;
                }
            } else {
                result = fLength == 0 && ofLength == 0;
            }
        } else if (factories != null && otherFactories == null || factories == null && otherFactories != null) {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder(128);
        sbuilder.append(super.toString());
        sbuilder.append(" [cfEndPointCriteria=");
        sbuilder.append(this.cfEndPointCriteria);
        sbuilder.append("]");
        return sbuilder.toString();
    }

    static {
        ChannelFrameworkService cfServiceObject;
        block3: {
            tc = Tr.register(ChannelTargetRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
            clusterService = ClusterServiceFactory.getClusterService();
            descMgr = DescriptionManagerFactory.getDescriptionManager();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version : ", "1.9 ");
            }
            cfServiceObject = null;
            try {
                cfServiceObject = (ChannelFrameworkService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ChannelFrameworkService obj = WsServiceRegistry.getService(ChannelTargetRule.class, ChannelFrameworkService.class);
                        return obj;
                    }
                });
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "Running without ChannelFrameworkService", e);
            }
        }
        cfService = cfServiceObject;
    }
}

