/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.wlm.WLMConstants;

public class WLMCustomPropertyUtility {
    private static final TraceComponent tc = Tr.register(WLMCustomPropertyUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static ProcessProperties processProperties;
    private static Boolean preloadEnabled;
    private static final boolean PRELOAD_ENABLED_DEFAULT_VALUE = true;
    private static Integer callbackTimeoutValue;
    private static final int CALLBACK_TIMEOUT_DEFAULT_VALUE = 30000;
    private static final int CALLBACK_TIMEOUT_RECOMMENDED_MAX_VALUE = 600000;
    private static Integer runRulesTimerValue;
    private static final int RUNRULES_TIMER_DEFAULT_VALUE = 0;
    private static final int RUNRULES_TIMER_RECOMMENDED_MAX_VALUE = 30000;
    private static Integer ripplestartNotificationTimeoutValue;
    private static final int RIPPLESTART_NOTIFICATION_TIMEOUT_DEFAULT_VALUE = 300000;
    private static final int RIPPLESTART_NOTIFICATION_TIMEOUT_RECOMMENDED_MAX_VALUE = 1800000;
    private static Boolean WBISupportEnabled;
    private static final boolean WBI_SUPPORT_ENABLED_DEFAULT_VALUE = false;
    private static Boolean purgeNotifications;
    private static final boolean PURGE_NOTIFICATIONS_DEFAULT_VALUE = true;
    private static Integer customAdvisorThreadPoolSizeValue;
    private static final int CA_THREAD_POOL_SIZE_DEFAULT_VALUE = 5;
    private static final int CA_THREAD_POOL_SIZE_RECOMMENDED_MAX_VALUE = 50;
    private static String feedbackMechanismValue;
    private static Boolean BBCallbacksEnableWLMThreads;
    private static final boolean BB_CALLBACKS_ENABLE_WLM_THREADS_DEFAULT_VALUE = true;
    private static final Object BBCallbacksEndableWLMThreadsMutex;
    private static Integer BBCallbacksWLMThreadCount;
    private static final int BB_CALLBACKS_WLM_THREAD_COUNT_DEFAULT_VALUE = 2;
    private static final Object BBCallbacksWLMThreadCountMutex;
    private static Boolean acsDelayPostingEnabled;
    private static final boolean ENABLE_ACS_DELAY_POSTING_DEFAULT_VALUE = false;
    private static Integer acsDelayPostingWaitTime;
    private static final int ACS_DELAY_POSTING_WAIT_TIME_DEFAULT_VALUE = 500;
    private static final Object acsDelayPostingWaitTimeMutex;
    public static final int ACS_DELAY_POSTING_WAIT_TIME_RECOMMENDED_MIN_VALUE = 250;
    public static final int ACS_DELAY_POSTING_WAIT_TIME_RECOMMENDED_MAX_VALUE = 60000;
    private static Integer delayCacheManagementCycleTime;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_DEFAULT_VALUE = 200;
    private static final Object delayCacheManagementCycleTimeMutex;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_RECOMMENDED_MIN_VALUE = 100;
    private static final int DELAY_CACHE_MANAGEMENT_CYCLE_TIME_RECOMMENDED_MAX_VALUE = 30000;

    public static boolean getPreloadValue() {
        if (preloadEnabled == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            String preloadString = (String)processProperties.get("IBM_CLUSTER_ENABLE_PRELOAD");
            boolean preload = true;
            if (preloadString != null && preloadString.compareToIgnoreCase("false") == 0) {
                preload = false;
            }
            preloadEnabled = preload;
        }
        if (preloadEnabled != null) {
            return preloadEnabled;
        }
        return true;
    }

    public static int getCallbackTimeoutValue() {
        if (callbackTimeoutValue == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            Integer cbt = new Integer(30000);
            try {
                cbt = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_CALLBACK_TIMEOUT"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            int callbacktimeout = cbt;
            int timeout = 0;
            if (callbacktimeout > 0) {
                timeout = callbacktimeout;
            }
            if ((callbackTimeoutValue = Integer.valueOf(timeout)) > 600000) {
                Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_CALLBACK_TIMEOUT", callbackTimeoutValue, 600000});
            }
        }
        if (callbackTimeoutValue != null) {
            return callbackTimeoutValue;
        }
        return 30000;
    }

    public static int getRunRulesTimerValue() {
        if (runRulesTimerValue == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            Integer rrtv = new Integer(0);
            try {
                rrtv = Integer.valueOf((String)processProperties.get(WLMConstants.IBM_CLUSTER_RUNRULES_TIMER_TIME));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            int runRulesTimer = rrtv;
            if (runRulesTimer < 0) {
                runRulesTimer = 0;
            }
            if ((runRulesTimerValue = Integer.valueOf(runRulesTimer)) > 30000) {
                Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{WLMConstants.IBM_CLUSTER_RUNRULES_TIMER_TIME, runRulesTimerValue, 30000});
            }
        }
        if (runRulesTimerValue != null) {
            return runRulesTimerValue;
        }
        return 0;
    }

    public static int getRippleStartNotificationTimeoutValue() {
        if (ripplestartNotificationTimeoutValue == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            Integer rt = new Integer(300000);
            try {
                rt = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_RIPPLESTART_NOTIFICATION_TIMEOUT"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            int ripplestartTimeoutWait = rt;
            if (ripplestartTimeoutWait < 0) {
                ripplestartTimeoutWait = 0;
            }
            if ((ripplestartNotificationTimeoutValue = Integer.valueOf(ripplestartTimeoutWait)) > 1800000) {
                Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_RIPPLESTART_NOTIFICATION_TIMEOUT", ripplestartNotificationTimeoutValue, 1800000});
            }
        }
        if (ripplestartNotificationTimeoutValue != null) {
            return ripplestartNotificationTimeoutValue;
        }
        return 300000;
    }

    public static Boolean getWBISupportValue() {
        if (WBISupportEnabled == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            boolean WBISupport = false;
            String WBISupportString = (String)processProperties.get("IBM_CLUSTER_WBI_SUPPORT");
            if (WBISupportString != null && WBISupportString.compareToIgnoreCase("true") == 0) {
                WBISupport = true;
            }
            WBISupportEnabled = WBISupport;
        }
        if (WBISupportEnabled != null) {
            return WBISupportEnabled;
        }
        return false;
    }

    public static boolean getPurgeNotificationsValue() {
        if (purgeNotifications == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            String PurgeNotificationsString = (String)processProperties.get("IBM_CLUSTER_PURGE_NOTIFICATIONS");
            boolean purgeNotificationValue = true;
            if (PurgeNotificationsString != null && PurgeNotificationsString.compareToIgnoreCase("false") == 0) {
                purgeNotificationValue = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PurgeNotifications is currently set to " + purgeNotificationValue);
            }
            purgeNotifications = purgeNotificationValue;
        }
        if (purgeNotifications != null) {
            return purgeNotifications;
        }
        return true;
    }

    public static int getCustomAdvisorThreadPoolSize() {
        if (customAdvisorThreadPoolSizeValue == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            Integer tps = new Integer(5);
            try {
                tps = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_CUSTOM_ADVISOR_THREAD_POOL_SIZE"));
            }
            catch (NumberFormatException nfe) {
                tps = new Integer(5);
            }
            if (tps < 1) {
                int oldSize = tps;
                tps = 5;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCustomAdvisorThreadPoolSize", "property was set to: " + oldSize + " but changed to: " + tps);
                }
            } else if (tps > 50) {
                int oldSize = tps;
                tps = 50;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCustomAdvisorThreadPoolSize", "property was set to: " + oldSize + " but changed to: " + tps);
                }
            }
            customAdvisorThreadPoolSizeValue = (int)tps;
        }
        if (customAdvisorThreadPoolSizeValue != null) {
            return customAdvisorThreadPoolSizeValue;
        }
        return 5;
    }

    public static String getFeedbackMechanismValue() {
        if (feedbackMechanismValue == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            feedbackMechanismValue = (String)processProperties.get("IBM_CLUSTER_FEEDBACK_MECHANISM");
        }
        return feedbackMechanismValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBBCallbacksEnableWLMThreads() {
        if (BBCallbacksEnableWLMThreads == null) {
            Object object = BBCallbacksEndableWLMThreadsMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                BBCallbacksEnableWLMThreads = new Boolean(true);
                String customerValue = (String)processProperties.get("IBM_CLUSTER_BB_CALLBACKS_ENABLE_WLM_THREADS");
                if (customerValue != null && customerValue.compareToIgnoreCase("false") == 0) {
                    BBCallbacksEnableWLMThreads = new Boolean(false);
                } else if (customerValue != null && customerValue.compareToIgnoreCase("true") == 0) {
                    BBCallbacksEnableWLMThreads = new Boolean(true);
                }
            }
        }
        return BBCallbacksEnableWLMThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBBCallbacksWLMThreadCount() {
        if (BBCallbacksWLMThreadCount == null) {
            Object object = BBCallbacksWLMThreadCountMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                Integer threadCount = new Integer(2);
                try {
                    threadCount = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_BB_CALLBACKS_WLM_THREAD_COUNT"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (threadCount != null) {
                    if (threadCount < 1) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "BB_CALLBACKS_WLM_THREAD_COUNT is " + threadCount + " and is being changed to 1.");
                        }
                        threadCount = new Integer(1);
                    } else if (threadCount > 20) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "BB_CALLBACKS_WLM_THREAD_COUNT is " + threadCount + " and is being changed to 20.");
                        }
                        threadCount = new Integer(20);
                    }
                    BBCallbacksWLMThreadCount = threadCount;
                }
            }
            BBCallbacksWLMThreadCount = new Integer(2);
        }
        return BBCallbacksWLMThreadCount;
    }

    public static boolean getACSDelayPostingValue() {
        if (acsDelayPostingEnabled == null) {
            if (processProperties == null) {
                processProperties = ProcessProperties.getInstance();
            }
            String acsbpv = (String)processProperties.get("IBM_CLUSTER_ENABLE_ACS_DELAY_POSTING");
            boolean delaycache = false;
            if (acsbpv != null && acsbpv.compareToIgnoreCase("true") == 0) {
                delaycache = true;
            }
            acsDelayPostingEnabled = delaycache;
        }
        if (acsDelayPostingEnabled != null) {
            return acsDelayPostingEnabled;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getACSDelayPostingWaitTimeValue() {
        if (acsDelayPostingWaitTime == null) {
            Object object = acsDelayPostingWaitTimeMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                Integer delayPostingWaitTime = new Integer(500);
                try {
                    delayPostingWaitTime = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (delayPostingWaitTime < 250) {
                    Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME", delayPostingWaitTime, 250});
                    delayPostingWaitTime = 250;
                }
                if (delayPostingWaitTime > 60000) {
                    Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME", delayPostingWaitTime, 60000});
                    delayPostingWaitTime = 60000;
                }
                acsDelayPostingWaitTime = (int)delayPostingWaitTime;
            }
        }
        if (acsDelayPostingWaitTime != null) {
            return acsDelayPostingWaitTime;
        }
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDelayCacheManagementCycleTimeValue() {
        if (delayCacheManagementCycleTime == null) {
            Object object = delayCacheManagementCycleTimeMutex;
            synchronized (object) {
                if (processProperties == null) {
                    processProperties = ProcessProperties.getInstance();
                }
                Integer delayCacheMgmtCycleTime = new Integer(200);
                try {
                    delayCacheMgmtCycleTime = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (delayCacheMgmtCycleTime < 100) {
                    Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME", delayCacheMgmtCycleTime, 100});
                    delayCacheMgmtCycleTime = 100;
                }
                if (delayCacheMgmtCycleTime > 30000) {
                    Tr.warning(tc, "WLMKEY_IMPROPER_CUSTOM_PROPERTY_VALUE", new Object[]{"IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME", delayCacheMgmtCycleTime, 30000});
                    delayCacheMgmtCycleTime = 30000;
                }
                delayCacheManagementCycleTime = (int)delayCacheMgmtCycleTime;
            }
        }
        if (delayCacheManagementCycleTime != null) {
            return delayCacheManagementCycleTime;
        }
        return 200;
    }

    public static void setValue(String property, Object value2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setValue : ", new Object[]{property, value2});
        }
        if (property.equals("IBM_CLUSTER_ENABLE_PRELOAD")) {
            preloadEnabled = (Boolean)value2;
        } else if (property.equals("IBM_CLUSTER_CALLBACK_TIMEOUT")) {
            callbackTimeoutValue = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_RUNRULES_TIMER_TIME")) {
            runRulesTimerValue = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_WBI_SUPPORT")) {
            WBISupportEnabled = (Boolean)value2;
        } else if (property.equals("IBM_CLUSTER_RIPPLESTART_NOTIFICATION_TIMEOUT")) {
            ripplestartNotificationTimeoutValue = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_FEEDBACK_MECHANISM")) {
            feedbackMechanismValue = (String)value2;
        } else if (property.equals("IBM_CLUSTER_PURGE_NOTIFICATIONS")) {
            purgeNotifications = (Boolean)value2;
        } else if (property.equals("IBM_CLUSTER_CUSTOM_ADVISOR_THREAD_POOL_SIZE")) {
            customAdvisorThreadPoolSizeValue = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_BB_CALLBACKS_ENABLE_WLM_THREADS")) {
            BBCallbacksEnableWLMThreads = (Boolean)value2;
        } else if (property.equals("IBM_CLUSTER_BB_CALLBACKS_WLM_THREAD_COUNT")) {
            BBCallbacksWLMThreadCount = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_ENABLE_ACS_DELAY_POSTING")) {
            acsDelayPostingEnabled = (Boolean)value2;
        } else if (property.equals("IBM_CLUSTER_ACS_DELAY_POSTING_WAIT_TIME")) {
            acsDelayPostingWaitTime = (Integer)value2;
        } else if (property.equals("IBM_CLUSTER_DELAY_CACHE_MANAGEMENT_CYCLE_TIME")) {
            delayCacheManagementCycleTime = (Integer)value2;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
        processProperties = ProcessProperties.getInstance();
        preloadEnabled = null;
        callbackTimeoutValue = null;
        runRulesTimerValue = null;
        ripplestartNotificationTimeoutValue = null;
        WBISupportEnabled = null;
        purgeNotifications = null;
        customAdvisorThreadPoolSizeValue = null;
        feedbackMechanismValue = null;
        BBCallbacksEnableWLMThreads = null;
        BBCallbacksEndableWLMThreadsMutex = new Object();
        BBCallbacksWLMThreadCount = null;
        BBCallbacksWLMThreadCountMutex = new Object();
        acsDelayPostingEnabled = null;
        acsDelayPostingWaitTime = null;
        acsDelayPostingWaitTimeMutex = new Object();
        delayCacheManagementCycleTime = null;
        delayCacheManagementCycleTimeMutex = new Object();
    }
}

