/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.OutboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.validation.ChannelTypeValidatorManager;
import com.ibm.ws.channel.validation.ChannelValidationCollector;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFrameworkValidator
extends WebSphereDelegateValidator {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkValidator.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelTypeManager _typeManager = new ValidationChannelTypeManager();
    private ChannelTypeValidatorManager _validatorManager = new ChannelTypeValidatorManager((MOFValidator)this, this._typeManager);

    public ChannelFrameworkValidator(MOFValidator parent) {
        super(parent);
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.channel.resources.channelframeworkvalidation";
    }

    protected String getLocalTraceName() {
        return "ChannelFrameworkValidator";
    }

    protected final void visitNonList(Object target) throws ValidationException {
        this.visitNonTraversing(target);
    }

    protected boolean basicValidate(Object target) throws ValidationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "basicValidate");
        }
        if (!(target instanceof TransportChannelService)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "basicValidate");
            }
            return super.basicValidate(target);
        }
        try {
            TransportChannelService root = (TransportChannelService)target;
            EList factories = root.getFactories();
            if (factories != null && !factories.isEmpty()) {
                this.validateFactories(factories);
            }
            if (!this.testNullOrEmptyWarning(root.getTransportChannels(), "no.channels", root)) {
                this.validateChannels(root.getTransportChannels());
            }
            if (!this.testNullOrEmptyWarning(root.getChains(), "no.chains", root)) {
                this.validateChains(root.getChains());
            }
        }
        catch (Throwable exp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception in basicValidate: ", exp);
            }
            this.addError("generic.validation.exception", new String[]{exp.getMessage()}, target);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "basicValidate");
        }
        return true;
    }

    private void validateFactories(List<?> factories) throws ValidationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFactories");
        }
        Iterator<?> iterator = factories.iterator();
        HashSet<Class<? extends TransportChannelFactory>> set = new HashSet<Class<? extends TransportChannelFactory>>();
        while (iterator.hasNext()) {
            this.validateFactory((TransportChannelFactory)iterator.next(), set);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFactories");
        }
    }

    private void validateFactory(TransportChannelFactory factory, Set<Class<? extends TransportChannelFactory>> unique) throws ValidationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFactory: " + ChannelFrameworkValidator.getID((EObject)factory));
        }
        if (unique.contains(factory.getClass())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "multiple factories of type: " + factory.getClass().getName());
            }
            this.addError("duplicate.channel.factory", new String[]{factory.getClass().getName()}, factory);
        } else if (!(factory instanceof GenericChannelFactory)) {
            unique.add(factory.getClass());
        }
        ChannelFactoryTypeValidator validator = this._validatorManager.getChannelFactoryTypeValidator(factory);
        if (validator == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find extension validator for type " + factory.getClass().getName());
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "validating factory with " + ((Object)((Object)validator)).getClass().getName());
            }
            validator.validate(factory);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFactory");
        }
    }

    private void validateChannels(List<?> channels) throws ValidationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateChannels");
        }
        ChannelValidationCollector collector = new ChannelValidationCollector(this._typeManager);
        Iterator<?> iterator = channels.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            TransportChannel channel = (TransportChannel)iterator.next();
            this.validateChannel(channel, set);
            collector.collectChannel(channel);
        }
        for (ChannelTypeManager.ChannelMetaData type : collector.getChannelTypes()) {
            this.validateAllChannels(type, collector.getChannels(type));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateChannels");
        }
    }

    private void validateAllChannels(ChannelTypeManager.ChannelMetaData type, List<TransportChannel> channels) {
        block5: {
            if (channels == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAllChannels");
            }
            try {
                TransportChannel[] all = channels.toArray(new TransportChannel[channels.size()]);
                ChannelTypeValidator validator = (ChannelTypeValidator)this._validatorManager.getValidator(type.getClass(type.getValidatorClass()));
                validator.validateAll(all);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "validateAllChannels caught " + t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAllChannels");
        }
    }

    protected void validateChannel(TransportChannel channel, Set<String> unique) throws ValidationException {
        ChannelTypeValidator validator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateChannel: " + ChannelFrameworkValidator.getID((EObject)channel));
        }
        if (channel.getName() == null) {
            this.addError("nameless.channel", new String[]{ChannelFrameworkValidator.getID((EObject)channel)}, channel);
        } else if (unique.contains(channel.getName())) {
            this.addError("duplicate.channel.name", new String[]{channel.getName()}, channel);
        } else {
            unique.add(channel.getName());
        }
        if (channel instanceof InboundTransportChannel) {
            boolean channelIsConnector = false;
            ChannelTypeManager.ChannelMetaData type = this._typeManager.getChannelType(channel);
            if (type != null && type.getKind() == ChannelTypeManager.ChannelKind.CONNECTOR) {
                channelIsConnector = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found connector channel, " + channel.getName() + " so no disc weight validation");
                }
            }
            if (!channelIsConnector) {
                InboundTransportChannel inChannel = (InboundTransportChannel)channel;
                if (!inChannel.isSetDiscriminationWeight()) {
                    this.addError("channel.inbound.weight.unset", new String[]{channel.getName()}, channel);
                } else if (inChannel.getDiscriminationWeight() < 0) {
                    this.addError("channel.inbound.weight.invalid", new String[]{channel.getName(), String.valueOf(inChannel.getDiscriminationWeight())}, channel);
                }
            }
        }
        if ((validator = this._validatorManager.getChannelTypeValidator(channel)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find extension validator for type " + channel.getClass().getName());
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "validating channel with " + ((Object)((Object)validator)).getClass().getName());
            }
            validator.validate(channel);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateChannel");
        }
    }

    private void validateChains(List<?> chains) {
        Iterator<?> iterator = chains.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            this.validateChain((Chain)iterator.next(), set);
        }
    }

    private void validateChain(Chain chain, Set<String> unique) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "validating chain " + ChannelFrameworkValidator.getID((EObject)chain));
        }
        if (chain.getName() == null) {
            this.addError("nameless.chain", new String[]{ChannelFrameworkValidator.getID((EObject)chain)}, chain);
        } else if (unique.contains(chain.getName())) {
            this.addError("duplicate.chain.name", new String[]{chain.getName()}, chain);
        } else {
            unique.add(chain.getName());
        }
        EList channels = chain.getTransportChannels();
        if (channels == null || channels.isEmpty()) {
            this.addError("empty.chain", new String[]{chain.getName()}, chain);
        } else {
            this.validateChainFlow(chain);
            this.validateChainEnds(chain);
            this.validateChainCoherency(chain);
            this.validateChainChannels(chain);
        }
    }

    private void validateChainFlow(Chain chain) {
        EList channels = chain.getTransportChannels();
        TransportChannel channel = (TransportChannel)channels.get(0);
        FlowType flow = this.getFlowType(channel);
        HashSet<TransportChannel> unique = new HashSet<TransportChannel>();
        unique.add(channel);
        for (int i = 1; i < channels.size(); ++i) {
            channel = (TransportChannel)channels.get(i);
            if (flow != this.getFlowType(channel)) {
                this.addError("chain.flow.mismatch", new String[]{chain.getName(), channel.getName()}, chain);
            }
            if (unique.contains(channel)) {
                this.addError("chain.duplicate.channel", new String[]{channel.getName(), chain.getName()}, chain);
                continue;
            }
            unique.add(channel);
        }
    }

    private void validateChainEnds(Chain chain) {
        EList channels = chain.getTransportChannels();
        TransportChannel first = (TransportChannel)channels.get(0);
        TransportChannel last = (TransportChannel)channels.get(channels.size() - 1);
        if (first instanceof InboundTransportChannel) {
            ChannelTypeManager.ChannelKind kind = this.getChannelKind(chain, first);
            if (kind == null) {
                this.addError("missing.channel.kind", new String[]{first.getName()}, chain);
            } else if (kind != ChannelTypeManager.ChannelKind.CONNECTOR) {
                this.addError("channel.kind.connector.mismatch", new String[]{first.getName(), chain.getName()}, chain);
            }
            kind = this.getChannelKind(chain, last);
            if (kind == null) {
                this.addError("missing.channel.kind", new String[]{last.getName()}, chain);
            } else if (kind != ChannelTypeManager.ChannelKind.ACCEPTOR) {
                this.addError("channel.kind.acceptor.mismatch", new String[]{last.getName(), chain.getName()}, chain);
            }
        } else {
            ChannelTypeManager.ChannelKind kind = this.getChannelKind(chain, last);
            if (kind == null) {
                this.addError("missing.channel.kind", new String[]{last.getName()}, chain);
            } else if (kind != ChannelTypeManager.ChannelKind.CONNECTOR) {
                this.addError("channel.kind.connector.mismatch", new String[]{first.getName(), chain.getName()}, chain);
            }
        }
    }

    private void validateChainCoherency(Chain chain) {
        List channels = chain.getTransportChannels();
        if (channels.get(0) instanceof OutboundTransportChannel) {
            channels = new ArrayList(channels);
            Collections.reverse(channels);
        }
        ChannelTypeManager.ChannelMetaData high = this._typeManager.getChannelType(channels.get(0));
        for (int i = 1; i < channels.size(); ++i) {
            ChannelTypeManager.ChannelMetaData low = high;
            high = this._typeManager.getChannelType(channels.get(i));
            if (low == null || high == null) {
                this.addError("coherency.check.aborted", new String[]{chain.getName()}, chain);
                return;
            }
            if (Collections.binarySearch(high.getDeviceInterface(), low.getApplicationInterface()) >= 0) continue;
            this.addError("channel.interface.mismatch", new String[]{chain.getName(), low.getConfigurationClass(), high.getConfigurationClass()}, chain);
        }
    }

    private void validateChainChannels(Chain chain) {
        for (TransportChannel channel : chain.getTransportChannels()) {
            ChannelTypeValidator validator = this._validatorManager.getChannelTypeValidator(channel);
            if (validator == null) continue;
            try {
                validator.validateInChain(channel, chain);
            }
            catch (ValidationException exp) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "caught exception in validateChainChannels: ", (Object)exp);
            }
        }
    }

    private ChannelTypeManager.ChannelKind getChannelKind(Chain target, TransportChannel channel) {
        ChannelTypeManager.ChannelMetaData type = this._typeManager.getChannelType(channel);
        if (type == null) {
            this.addError("unknown.channel.type", new String[]{channel.getName()}, target);
            return null;
        }
        return type.getKind();
    }

    private FlowType getFlowType(TransportChannel channel) {
        if (null == channel) {
            return null;
        }
        return channel instanceof InboundTransportChannel ? FlowType.INBOUND : FlowType.OUTBOUND;
    }

    protected static String getID(EObject object) {
        StringBuilder result = new StringBuilder();
        result.append(object.eResource().getURI());
        result.append('#');
        result.append(object.eResource().getURIFragment(object));
        return result.toString();
    }
}

