/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OutboundChannelDefinitionImpl
implements OutboundChannelDefinition {
    private static TraceComponent tc = Tr.register(OutboundChannelDefinitionImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private Class factory = null;
    private Map factoryProps = null;
    private Map channelProps = null;
    private static final long serialVersionUID = -4159575078432063481L;

    public OutboundChannelDefinitionImpl(Class _factory, Map _factoryProps, Map _channelProps) {
        this.factory = _factory;
        this.factoryProps = _factoryProps;
        this.channelProps = _channelProps;
    }

    public OutboundChannelDefinitionImpl(OutboundChannelDefinition existingChanDef, Map newProps, boolean overwriteExisting) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.factory = existingChanDef.getOutboundFactory();
        this.factoryProps = existingChanDef.getOutboundFactoryProperties();
        this.channelProps = existingChanDef.getOutboundChannelProperties();
        if (this.factoryProps == null) {
            this.factoryProps = new HashMap();
        }
        if (this.channelProps == null) {
            this.channelProps = new HashMap();
        }
        if (newProps == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null properties found");
            }
            return;
        }
        Iterator iter = newProps.keySet().iterator();
        Object propKey = null;
        Object newValue = null;
        while (iter.hasNext()) {
            propKey = iter.next();
            if (this.channelProps.containsKey(propKey)) {
                if (overwriteExisting) {
                    newValue = newProps.get(propKey);
                    if (tc.isDebugEnabled()) {
                        Object oldValue = this.channelProps.get(propKey);
                        Tr.debug(tc, "Found existing property, " + propKey + ", value " + oldValue + " replacing with " + newValue);
                    }
                    this.channelProps.put(propKey, newValue);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found existing property, " + propKey + ", but not overwriting");
                continue;
            }
            newValue = newProps.get(propKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding property, " + propKey + ", value " + newValue);
            }
            this.channelProps.put(propKey, newValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public static String toString(OutboundChannelDefinition def) {
        StringBuffer sb = new StringBuffer();
        Map map = null;
        Object key2 = null;
        Iterator iter = null;
        sb.append("OutboundChannelDefinition: ");
        sb.append(def.getOutboundFactory());
        sb.append("\n\tFactory Properties ...\n");
        map = def.getOutboundFactoryProperties();
        if (map == null || map.size() == 0) {
            sb.append("\t\tnull or empty map");
        } else {
            map = def.getOutboundFactoryProperties();
            for (Object key2 : map.keySet()) {
                sb.append((Object)key2);
                sb.append(": ");
                sb.append(map.get(key2));
                sb.append("\n");
            }
        }
        sb.append("\n\tChannel Properties ...\n");
        map = def.getOutboundChannelProperties();
        if (map == null || map.size() == 0) {
            sb.append("\t\tnull or empty map");
        } else {
            map = def.getOutboundChannelProperties();
            for (Object key2 : map.keySet()) {
                sb.append((Object)key2);
                sb.append(": ");
                sb.append(map.get(key2));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public Class getOutboundFactory() {
        return this.factory;
    }

    public Map getOutboundFactoryProperties() {
        return this.factoryProps;
    }

    public Map getOutboundChannelProperties() {
        return this.channelProps;
    }
}

