/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.management.AdminHelper;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ConfigRepositoryFactory {
    private static ConfigRepository repository = null;
    private static TraceComponent tc = Tr.register(ConfigRepositoryFactory.class, "ConfigRepositoryFactory", "com.ibm.ws.management.resources.repository");
    private static boolean initialized = false;

    public static synchronized ConfigRepository createConfigRepository(boolean enable) throws AdminException {
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigRepository", profileKey);
            }
            return ConfigRepositoryFactory.createConfigRepository(enable, profileKey);
        }
        if (initialized) {
            throw new AdminException("The ConfigurationRepository is already created");
        }
        if (enable) {
            ConfigRepositoryFactory.initialize();
            initialized = true;
        }
        return repository;
    }

    private static synchronized ConfigRepository createConfigRepository(boolean enable, String profileKey) throws AdminException {
        ConfigRepository remoteRepository;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigRepository ", new Object[]{new Boolean(enable), profileKey});
        }
        if ((remoteRepository = (ConfigRepository)AdminSubsystemServiceRegistry.getService(ConfigRepository.class.getName())) != null) {
            throw new AdminException("The ConfigurationRepository for profile" + profileKey + " is already created");
        }
        if (enable) {
            remoteRepository = ConfigRepositoryFactory.initialize(profileKey);
            AdminSubsystemServiceRegistry.addService(ConfigRepository.class.getName(), remoteRepository);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", remoteRepository);
        }
        return remoteRepository;
    }

    private static void initialize() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            Class<?> repositoryImpl = null;
            try {
                try {
                    repositoryImpl = Class.forName("com.ibm.ws.management.repository.XDServantFileRepository");
                    Method getRepository = repositoryImpl.getMethod("getRepository", null);
                    repository = (ConfigRepository)getRepository.invoke(null, null);
                }
                catch (ClassNotFoundException cnfe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "'XDServantFileRepository' NOT Found.");
                    }
                    Class<?> servantRepClass = Class.forName("com.ibm.ws.management.repository.ServantFileRepository");
                    Constructor<?> serverRepConstructor = servantRepClass.getConstructor(new Class[0]);
                    repository = (ConfigRepository)serverRepConstructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigRepositoryFactory.class, "com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", "71");
                throw new AdminException(e);
            }
        } else {
            try {
                Class<?> repClass = Class.forName("com.ibm.ws.management.repository.FileRepository");
                Constructor<?> repConstructor = repClass.getConstructor(new Class[0]);
                repository = (ConfigRepository)repConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigRepositoryFactory.class, "com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", "92");
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private static ConfigRepository initialize(String profileKey) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize with profile key ", profileKey);
        }
        ConfigRepository remoteRepository = null;
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            Class<?> repositoryImpl = null;
            try {
                try {
                    repositoryImpl = Class.forName("com.ibm.ws.management.repository.XDServantFileRepository");
                    Method getRepository = repositoryImpl.getMethod("getRepository", null);
                    remoteRepository = (ConfigRepository)getRepository.invoke(null, null);
                }
                catch (ClassNotFoundException cnfe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "'XDServantFileRepository' NOT Found.");
                    }
                    Class<?> servantRepClass = Class.forName("com.ibm.ws.management.repository.ServantFileRepository");
                    Constructor<?> servantRepConstructor = servantRepClass.getConstructor(String.class);
                    remoteRepository = (ConfigRepository)servantRepConstructor.newInstance(profileKey);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigRepositoryFactory.class, "com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", "72");
                throw new AdminException(e);
            }
        } else {
            try {
                Class<?> repClass = Class.forName("com.ibm.ws.management.repository.FileRepository");
                Constructor<?> repConstructor = repClass.getConstructor(String.class);
                remoteRepository = (ConfigRepository)repConstructor.newInstance(profileKey);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigRepositoryFactory.class, "com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", "93");
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", remoteRepository);
        }
        return remoteRepository;
    }

    public static ConfigRepository getConfigRepository() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRepository");
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigRepository", profileKey);
            }
            return ConfigRepositoryFactory.getConfigRepository(profileKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRepository", repository);
        }
        return repository;
    }

    private static ConfigRepository getConfigRepository(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRepository with profile key " + profileKey);
        }
        ConfigRepository remoteRepository = (ConfigRepository)AdminSubsystemServiceRegistry.getService(ConfigRepository.class.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRepository", remoteRepository);
        }
        return remoteRepository;
    }
}

