/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class ManagedObjectMetadataHelper {
    private static final String BASE_PROD_ID = "base";
    private static final String PROD_VER_PREFIX = "com.ibm.websphere.";
    private static final String PROD_VER_SUFFIX = "ProductVersion";
    public static final String BASE_WAS_PRODUCT_VERSION = "com.ibm.websphere.baseProductVersion";
    private static final String PROD_SHORT_NAME_PREFIX = "com.ibm.websphere.";
    private static final String PROD_SHORT_NAME_SUFFIX = "ProductShortName";
    public static final String BASE_WAS_PRODUCT_SHORT_NAME = "com.ibm.websphere.baseProductShortName";
    private static final String APP_ACTIVATION_PLANS_PREFIX = "com.ibm.websphere.";
    private static final String APP_ACTIVATION_PLANS_SUFFIX = "RuntimeComponents";
    public static final String BASE_WAS_APP_ACTIVATION_PLANS = "com.ibm.websphere.baseRuntimeComponents";
    public static final String NODE_OS = "com.ibm.websphere.nodeOperatingSystem";
    public static final String NODE_OS_AS400 = "os400";
    public static final String NODE_OS_AIX = "aix";
    public static final String NODE_OS_HPUX = "hpux";
    public static final String NODE_OS_LINUX = "linux";
    public static final String NODE_OS_SOLARIS = "solaris";
    public static final String NODE_OS_WINDOWS = "windows";
    public static final String NODE_OS_ZOS = "os390";
    public static final String NODE_SYSPLEX_NAME = "com.ibm.websphere.nodeSysplexName";
    public static final String NODE_DEPLOYED_FEATURES = "com.ibm.websphere.deployed.features";
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataHelper.class, "Admin", null);
    private static final char FEATURE_DELIMITER = ',';
    private static final char RUNTIME_COMPONENT_DELIMITER = ';';
    private static final String ND_SHORT_NAME = "ND";
    private ManagedObjectMetadataAccessor _metadataAccessor = null;

    public ManagedObjectMetadataHelper(ManagedObjectMetadataAccessor metadataAccessor) throws AdminException {
        if (metadataAccessor == null) {
            throw new AdminException("Invalid parameter: null ManagedObjectMetadataAccessor.");
        }
        this._metadataAccessor = metadataAccessor;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ManagedObjectMetadataHelper", "accessor=" + this._metadataAccessor.toString());
        }
    }

    public ManagedObjectMetadataAccessor getAccessor() throws AdminException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getAccessor", "accessor=" + this._metadataAccessor.toString());
        }
        return this._metadataAccessor;
    }

    public String getNodeMajorVersion(String nodeName) throws AdminException {
        Properties nodeData;
        String version;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeMajorVersion", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((version = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + nodeName + "\" is not available.");
        }
        String majorVersion = null;
        if (version != null) {
            int i = version.indexOf(46);
            majorVersion = i == -1 ? version : version.substring(0, i);
        }
        if (majorVersion == null || majorVersion.length() == 0) {
            throw new MetadataNotAvailableException("Major version for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeMajorVersion", "majorVersion=" + majorVersion);
        }
        return majorVersion;
    }

    public String getNodeMinorVersion(String nodeName) throws AdminException {
        int i;
        Properties nodeData;
        String version;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeMinorVersion", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((version = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + nodeName + "\" is not available.");
        }
        String minorVersion = null;
        if (version != null && (i = version.indexOf(46)) != -1) {
            int j = version.indexOf(46, i + 1);
            minorVersion = j == -1 ? version.substring(i + 1) : version.substring(i + 1, j);
        }
        if (minorVersion == null || minorVersion.length() == 0) {
            throw new MetadataNotAvailableException("Minor version for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeMinorVersion", "minorVersion=" + minorVersion);
        }
        return minorVersion;
    }

    public String getNodeUpdateVersion(String nodeName) throws AdminException {
        Properties nodeData;
        String version;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeUpdateVersion", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((version = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + nodeName + "\" is not available.");
        }
        String updateVersion = null;
        if (version != null) {
            int i = version.indexOf(46);
            if (i != -1) {
                i = version.indexOf(46, i + 1);
            }
            if (i != -1) {
                int j = version.indexOf(46, i + 1);
                updateVersion = j == -1 ? version.substring(i + 1) : version.substring(i + 1, j);
            }
        }
        if (updateVersion == null || updateVersion.length() == 0) {
            throw new MetadataNotAvailableException("Update version for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeUpdateVersion", "updateVersion=" + updateVersion);
        }
        return updateVersion;
    }

    public String getNodeServiceVersion(String nodeName) throws AdminException {
        Properties nodeData;
        String version;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeServiceVersion", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((version = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + nodeName + "\" is not available.");
        }
        String serviceVersion = null;
        if (version != null) {
            int i = version.indexOf(46);
            if (i != -1) {
                i = version.indexOf(46, i + 1);
            }
            if (i != -1) {
                i = version.indexOf(46, i + 1);
            }
            if (i != -1) {
                int j = version.indexOf(46, i + 1);
                serviceVersion = j == -1 ? version.substring(i + 1) : version.substring(i + 1, j);
            }
        }
        if (serviceVersion == null || serviceVersion.length() == 0) {
            throw new MetadataNotAvailableException("Service version for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeServiceVersion", "serviceVersion=" + serviceVersion);
        }
        return serviceVersion;
    }

    public String getNodeBaseProductVersion(String nodeName) throws AdminException {
        Properties nodeData;
        String baseProdVersion;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeBaseProductVersion", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((baseProdVersion = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Base product version for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeBaseProductVersion", "baseProdVersion=" + baseProdVersion);
        }
        return baseProdVersion;
    }

    public String getNodeBaseProductShortName(String nodeName) throws AdminException {
        Properties nodeData;
        String baseProdShortName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeBaseProductShortName", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((baseProdShortName = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_SHORT_NAME)) == null) {
            baseProdShortName = ND_SHORT_NAME;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeBaseProductShortName", "baseProdShortName=" + baseProdShortName);
        }
        return baseProdShortName;
    }

    public int compareNodeVersion(String nodeName, String version) throws AdminException {
        Properties nodeData;
        String nodeVersion;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "compareNodeVersion", new Object[]{"nodeName=" + nodeName, "version=" + version, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((nodeVersion = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Base product version info for node \"" + nodeName + "\" is not available.");
        }
        int comparison = 0;
        try {
            VersionParser inParser = new VersionParser(version);
            VersionParser nodeParser = new VersionParser(nodeVersion);
            while (inParser.hasMoreComponents() && comparison == 0) {
                int inComponent = inParser.nextComponent();
                if (nodeParser.hasMoreComponents()) {
                    int nodeComponent = nodeParser.nextComponent();
                    if (nodeComponent < inComponent) {
                        comparison = -1;
                        continue;
                    }
                    if (nodeComponent <= inComponent) continue;
                    comparison = 1;
                    continue;
                }
                throw new AdminException("Specified version contains more components than available version info.");
            }
        }
        catch (AdminException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new AdminException(e, "Invalid input.  See nested exception for more information.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "compareNodeVersion", "comparison=" + comparison);
        }
        return comparison;
    }

    public boolean isNodeZOS(String nodeName) throws AdminException {
        boolean nodeIsZOS;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isNodeZOS", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties nodeData = this._metadataAccessor.getMetadataProperties(nodeName);
        String os = nodeData.getProperty(NODE_OS);
        String majVer = null;
        try {
            majVer = this.getNodeMajorVersion(nodeName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (os != null) {
            nodeIsZOS = os.equals(NODE_OS_ZOS);
        } else if (majVer != null && majVer.equals("5")) {
            nodeIsZOS = false;
        } else {
            throw new MetadataNotAvailableException("OS for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isNodeZOS", "nodeIsZOS=" + nodeIsZOS);
        }
        return nodeIsZOS;
    }

    public String getNodePlatformOS(String nodeName) throws AdminException {
        Properties nodeData;
        String nodeOS;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodePlatformOS", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((nodeOS = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(NODE_OS)) == null) {
            throw new MetadataNotAvailableException("OS for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodePlatformOS", "nodeOS=" + nodeOS);
        }
        return nodeOS;
    }

    public String getNodeSysplexName(String nodeName) throws AdminException {
        Properties nodeData;
        String nodeSysplex;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeSysplexName", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((nodeSysplex = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(NODE_SYSPLEX_NAME)) == null) {
            throw new MetadataNotAvailableException("Sysplex for node \"" + nodeName + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeSysplexName", "nodeSysplex=" + nodeSysplex);
        }
        return nodeSysplex;
    }

    public SortedMap getNodeProductVersions(String nodeName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeProductVersions", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties nodeData = this._metadataAccessor.getMetadataProperties(nodeName);
        TreeMap<String, Object> prodVersions = new TreeMap<String, Object>();
        for (Map.Entry<Object, Object> entry : nodeData.entrySet()) {
            String prodID;
            String key = (String)entry.getKey();
            if (!key.endsWith(PROD_VER_SUFFIX) || !key.startsWith("com.ibm.websphere.") || (prodID = key.substring("com.ibm.websphere.".length(), key.length() - PROD_VER_SUFFIX.length())) == null || prodID.length() <= 0) continue;
            String prodShortName = nodeData.getProperty("com.ibm.websphere." + prodID + PROD_SHORT_NAME_SUFFIX);
            if (prodShortName != null && prodShortName.length() > 0) {
                prodVersions.put(prodShortName, entry.getValue());
                continue;
            }
            if (!prodID.equals(BASE_PROD_ID)) continue;
            prodVersions.put(ND_SHORT_NAME, entry.getValue());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeProductVersions", "prodVersions=" + prodVersions);
        }
        return prodVersions;
    }

    public ArrayList getNodeDeployedFeatures(String nodeName) throws AdminException {
        int end;
        Properties nodeData;
        String nodeFeatures;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeDeployedFeatures", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((nodeFeatures = (nodeData = this._metadataAccessor.getMetadataProperties(nodeName)).getProperty(NODE_DEPLOYED_FEATURES)) == null) {
            throw new MetadataNotAvailableException("List of deployed features for node \"" + nodeName + "\" is not available.");
        }
        ArrayList<String> featuresList = new ArrayList<String>();
        int start = 0;
        do {
            String feature;
            if ((end = nodeFeatures.indexOf(44, start)) == -1) {
                feature = nodeFeatures.substring(start).trim();
            } else {
                feature = nodeFeatures.substring(start, end).trim();
                start = end + 1;
            }
            if (feature == null || feature.length() == 0) continue;
            featuresList.add(feature);
        } while (end != -1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeDeployedFeatures", "featuresList=" + featuresList);
        }
        return featuresList;
    }

    public Properties getNodeProductsAndVersions(String nodeName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeProductsAndVersions, node name = " + nodeName);
        }
        Properties productProperties = null;
        Properties nodeProperties = this._metadataAccessor.getMetadataProperties(nodeName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "nodeProperties = " + nodeProperties);
        }
        if (nodeProperties != null) {
            productProperties = new Properties();
            Enumeration<?> nodeEnum = nodeProperties.propertyNames();
            String key = null;
            String value2 = null;
            while (nodeEnum.hasMoreElements()) {
                key = (String)nodeEnum.nextElement();
                value2 = nodeProperties.getProperty(key);
                int suffixIndex = key.indexOf(PROD_VER_SUFFIX);
                if (suffixIndex == -1) continue;
                int lastPeriod = key.lastIndexOf(46);
                String product = key.substring(lastPeriod + 1, suffixIndex);
                productProperties.put(product, value2);
            }
        } else {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNodeProductsAndVersions, node name = " + nodeName);
            }
            throw new AdminException("No metadata properties for node " + nodeName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeProductsAndVersions, node name = " + nodeName);
        }
        return productProperties;
    }

    public ArrayList listRuntimeComponents(String nodeName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listRuntimeComponents", new Object[]{"nodeName=" + nodeName, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties nodeData = this._metadataAccessor.getMetadataProperties(nodeName);
        ArrayList<String> rtComponentsList = new ArrayList<String>();
        for (String string : nodeData.keySet()) {
            int end;
            String prodID;
            if (!string.endsWith(APP_ACTIVATION_PLANS_SUFFIX) || !string.startsWith("com.ibm.websphere.") || (prodID = string.substring("com.ibm.websphere.".length(), string.length() - APP_ACTIVATION_PLANS_SUFFIX.length())) == null || prodID.length() <= 0) continue;
            String rtComponents = nodeData.getProperty("com.ibm.websphere." + prodID + APP_ACTIVATION_PLANS_SUFFIX);
            Tr.debug(_tc, "rtComponents for com.ibm.websphere." + prodID + APP_ACTIVATION_PLANS_SUFFIX + "is: " + rtComponents);
            if (rtComponents == null || rtComponents.length() <= 0) continue;
            int start = 0;
            do {
                String rtComp;
                if ((end = rtComponents.indexOf(59, start)) == -1) {
                    rtComp = rtComponents.substring(start).trim();
                } else {
                    rtComp = rtComponents.substring(start, end).trim();
                    start = end + 1;
                }
                if (rtComp == null || rtComp.length() == 0) continue;
                rtComponentsList.add(rtComp);
            } while (end != -1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listRuntimeComponents", "=" + rtComponentsList);
        }
        return rtComponentsList;
    }

    private class VersionParser {
        String _inputString;
        int _inputStringLength;
        int _currIndex;
        private static final char VERSION_DELIMITER = '.';

        public VersionParser(String inputString) throws IllegalArgumentException {
            if (inputString == null || inputString.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Null or empty version number.");
            }
            this._inputString = inputString;
            this._inputStringLength = inputString.length();
            this._currIndex = 0;
        }

        public boolean hasMoreComponents() {
            return this._currIndex < this._inputStringLength;
        }

        public int nextComponent() throws IllegalArgumentException, NoSuchElementException {
            int versionComponent;
            String tokenString;
            if (this._currIndex < this._inputStringLength) {
                int nextDelimiter = this._inputString.indexOf(46, this._currIndex);
                if (nextDelimiter != -1) {
                    tokenString = this._inputString.substring(this._currIndex, nextDelimiter);
                    this._currIndex = nextDelimiter + 1;
                } else {
                    tokenString = this._inputString.substring(this._currIndex);
                    this._currIndex = this._inputStringLength;
                }
            } else {
                throw new NoSuchElementException();
            }
            if (tokenString.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Empty component in version number.");
            }
            try {
                versionComponent = Integer.parseInt(tokenString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("ERROR: Component in version is not a number.");
            }
            return versionComponent;
        }
    }
}

