/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.service.delaycache.DelayCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DescriptionA
implements Description {
    private static final TraceComponent tc = Tr.register(DescriptionA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private Map listeners = Collections.synchronizedMap(new HashMap(3));
    private boolean local = false;
    private final DescriptionKey key;
    private Description.Memento memento = null;

    protected DescriptionA(DescriptionKey key) {
        this.key = key;
        this.memento = this.createMemento();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "<init>", new Object[]{this, this.getDefinitionKey()});
        }
    }

    public DescriptionKey getKey() {
        return this.key;
    }

    public boolean isLocal() {
        return this.local;
    }

    void setLocal() {
        this.local = true;
    }

    public Description.Memento getMemento() {
        return this.memento;
    }

    public void setMemento(Description.Memento memento) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemento", memento);
        }
        this.memento = memento;
        this.notifyListeners("type.memento.updated", memento);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemento");
        }
    }

    public final void updateMemento() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMemento", this.key);
        }
        DelayCache.remove(this.key);
        descMgr.publish(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMemento", this.local ? "local" : "distributed");
        }
    }

    public final void updateMemento(int delay) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMemento", new Object[]{this.key, delay});
        }
        try {
            DelayCache.put(this.key, delay);
        }
        catch (IllegalArgumentException iae) {
            this.updateMemento();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "updateMemento - illegal delay time");
            }
            throw new IllegalArgumentException(iae);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMemento", this.local ? "local" : "distributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationListener(DescriptionModificationListener listener, String type, Object handback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNotificationListener", new Object[]{listener.getClass().getName(), type, handback});
        }
        WeakHashMap<DescriptionModificationListener, Object> dml = null;
        WeakHashMap<DescriptionModificationListener, Object> weakHashMap = this.listeners;
        synchronized (weakHashMap) {
            dml = (WeakHashMap<DescriptionModificationListener, Object>)this.listeners.get(type);
            if (dml == null) {
                dml = new WeakHashMap<DescriptionModificationListener, Object>();
                this.listeners.put(type, dml);
            }
        }
        weakHashMap = dml;
        synchronized (weakHashMap) {
            dml.put(listener, handback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener " + Integer.toString(this.listeners.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNotificationListener(DescriptionModificationListener listener, String type) {
        Map dml;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterNotificationListener", new Object[]{listener.getClass().getName(), type});
        }
        if ((dml = (Map)this.listeners.get(type)) != null) {
            Map map = dml;
            synchronized (map) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "removing listener pair", dml);
                }
                dml.remove(listener);
                if (dml.isEmpty()) {
                    this.listeners.remove(type);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "No registered listeners for this type");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterNotificationListener " + Integer.toString(this.listeners.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(String type, Object data) {
        Map dml = (Map)this.listeners.get(type);
        if (dml != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyListeners", new Object[]{type, data});
            }
            HashMap dmlClone = null;
            Map map = dml;
            synchronized (map) {
                if (dml.isEmpty()) {
                    this.listeners.remove(type);
                }
                dmlClone = new HashMap(dml);
            }
            for (Map.Entry mapEntry : dmlClone.entrySet()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "notifyListeners", mapEntry);
                    }
                    ((DescriptionModificationListener)mapEntry.getKey()).handleNotification(this.key, type, data, mapEntry.getValue());
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, DescriptionA.class.getName() + ".notifyListeners", "133", this, new Object[]{this.key, type, data});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "unexpected", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyListeners " + Integer.toString(this.listeners.size()));
        }
    }

    public String toString() {
        return new StringBuffer("[").append(this.getClass().getSimpleName()).append('#').append(this.hashCode()).append(this.key).append(']').toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }

    public abstract class MementoA
    implements Description.Memento {
        public Description.Memento delta() {
            if (this == DescriptionA.this.memento) {
                return null;
            }
            return DescriptionA.this.memento;
        }

        public String toString() {
            return new StringBuffer("[").append(this.getClass().getEnclosingClass().getSimpleName()).append('$').append(this.getClass().getSimpleName()).append('#').append(this.hashCode()).append(DescriptionA.this.key).append(']').toString();
        }
    }
}

