/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASObject;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASGroup
extends RASObject
implements Cloneable,
RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 16971700404675172L;
    private static final int ML_CFG = 1;
    private static final int TL_CFG = 2;
    private static final int H_CFG = 3;
    private static final int F_CFG = 4;
    private boolean modified = false;
    private Hashtable messageLoggerCfgs = new Hashtable();
    private Hashtable traceLoggerCfgs = new Hashtable();
    private Hashtable handlerCfgs = new Hashtable();
    private Hashtable formatterCfgs = new Hashtable();

    public RASGroup(String name2) {
        super(name2);
    }

    public RASGroup(String name2, String desc) {
        super(name2, desc);
    }

    public synchronized Object clone() {
        RASGroup obj = (RASGroup)super.clone();
        obj.messageLoggerCfgs = (Hashtable)this.messageLoggerCfgs.clone();
        obj.traceLoggerCfgs = (Hashtable)this.traceLoggerCfgs.clone();
        obj.handlerCfgs = (Hashtable)this.handlerCfgs.clone();
        obj.formatterCfgs = (Hashtable)this.formatterCfgs.clone();
        return obj;
    }

    public void addMessageLoggerConfig(RASConfig cfg) {
        this.addConfig(cfg, 1);
    }

    public void removeMessageLoggerConfig(String name2) {
        this.removeConfig(name2, 1);
    }

    public RASConfig getMessageLoggerConfig(String name2) {
        return this.getConfig(name2, 1);
    }

    public Hashtable getMessageLoggerConfigs() {
        return this.messageLoggerCfgs;
    }

    public void addTraceLoggerConfig(RASConfig cfg) {
        this.addConfig(cfg, 2);
    }

    public void removeTraceLoggerConfig(String name2) {
        this.removeConfig(name2, 2);
    }

    public RASConfig getTraceLoggerConfig(String name2) {
        return this.getConfig(name2, 2);
    }

    public Hashtable getTraceLoggerConfigs() {
        return this.traceLoggerCfgs;
    }

    public void addHandlerConfig(RASConfig cfg) {
        this.addConfig(cfg, 3);
    }

    public void removeHandlerConfig(String name2) {
        this.removeConfig(name2, 3);
    }

    public RASConfig getHandlerConfig(String name2) {
        return this.getConfig(name2, 3);
    }

    public Hashtable getHandlerConfigs() {
        return this.handlerCfgs;
    }

    public void addFormatterConfig(RASConfig cfg) {
        this.addConfig(cfg, 4);
    }

    public void removeFormatterConfig(String name2) {
        this.removeConfig(name2, 4);
    }

    public RASConfig getFormatterConfig(String name2) {
        return this.getConfig(name2, 4);
    }

    public Hashtable getFormatterConfigs() {
        return this.formatterCfgs;
    }

    private void addConfig(RASConfig cfg, int table) {
        String name2;
        if (cfg != null && (name2 = (String)cfg.get("name")) != null) {
            String className = this.getClass().getName();
            if (!cfg.containsKey("group") && !className.equals("com.ibm.ras.mgr.RASBaseGroup")) {
                cfg.put("group", this.getName());
            }
            Hashtable ht = this.getConfigTable(table);
            ht.put(name2, cfg);
        }
    }

    private void removeConfig(String name2, int table) {
        if (name2 != null) {
            Hashtable ht = this.getConfigTable(table);
            ht.remove(name2);
        }
    }

    private RASConfig getConfig(String name2, int table) {
        RASConfig cfg = null;
        if (name2 != null) {
            Hashtable ht = this.getConfigTable(table);
            cfg = (RASConfig)ht.get(name2);
        }
        return cfg;
    }

    private Hashtable getConfigTable(int table) {
        Hashtable ht = null;
        switch (table) {
            case 1: {
                ht = this.messageLoggerCfgs;
                break;
            }
            case 2: {
                ht = this.traceLoggerCfgs;
                break;
            }
            case 3: {
                ht = this.handlerCfgs;
                break;
            }
            case 4: {
                ht = this.formatterCfgs;
            }
        }
        return ht;
    }

    protected void updateActiveObjects(RASGroup oldGroup, RASManager mgr) {
        if (oldGroup != null) {
            RASILogger logger;
            RASConfig newConfig;
            String name2;
            RASConfig oldConfig;
            Enumeration e = oldGroup.getMessageLoggerConfigs().elements();
            while (e.hasMoreElements()) {
                oldConfig = (RASConfig)e.nextElement();
                name2 = (String)oldConfig.get("name");
                newConfig = this.getMessageLoggerConfig(name2);
                if (newConfig == null) {
                    this.addConfig(oldConfig, 1);
                    continue;
                }
                newConfig.updateActiveObjects(oldConfig);
                logger = (RASILogger)((Object)newConfig.getObject());
                if (logger == null) continue;
                mgr.addHandlers(logger, newConfig, this);
            }
            e = oldGroup.getTraceLoggerConfigs().elements();
            while (e.hasMoreElements()) {
                oldConfig = (RASConfig)e.nextElement();
                name2 = (String)oldConfig.get("name");
                newConfig = this.getTraceLoggerConfig(name2);
                if (newConfig == null) {
                    this.addConfig(oldConfig, 2);
                    continue;
                }
                newConfig.updateActiveObjects(oldConfig);
                logger = (RASILogger)((Object)newConfig.getObject());
                if (logger == null) continue;
                mgr.addHandlers(logger, newConfig, this);
            }
            e = oldGroup.getHandlerConfigs().elements();
            while (e.hasMoreElements()) {
                oldConfig = (RASConfig)e.nextElement();
                name2 = (String)oldConfig.get("name");
                newConfig = this.getHandlerConfig(name2);
                if (newConfig == null) {
                    this.addConfig(oldConfig, 3);
                    continue;
                }
                newConfig.updateActiveObjects(oldConfig);
            }
            e = oldGroup.getFormatterConfigs().elements();
            while (e.hasMoreElements()) {
                oldConfig = (RASConfig)e.nextElement();
                name2 = (String)oldConfig.get("name");
                newConfig = this.getFormatterConfig(name2);
                if (newConfig == null) {
                    this.addConfig(oldConfig, 4);
                    continue;
                }
                newConfig.updateActiveObjects(oldConfig);
            }
        }
    }

    public synchronized void setModified(boolean flag) {
        this.modified = flag;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public String toString() {
        StringBuffer bfr = new StringBuffer();
        bfr.append("RASGroup:  " + this.getName() + "\r\n");
        if (!this.messageLoggerCfgs.isEmpty()) {
            bfr.append("  Message Loggers:\r\n");
            bfr.append(this.tableToString(this.messageLoggerCfgs));
        }
        if (!this.traceLoggerCfgs.isEmpty()) {
            bfr.append("  Trace Loggers:\r\n");
            bfr.append(this.tableToString(this.traceLoggerCfgs));
        }
        if (!this.handlerCfgs.isEmpty()) {
            bfr.append("  Handlers:\r\n");
            bfr.append(this.tableToString(this.handlerCfgs));
        }
        if (!this.formatterCfgs.isEmpty()) {
            bfr.append("  Formatters:\r\n");
            bfr.append(this.tableToString(this.formatterCfgs));
        }
        return bfr.toString();
    }

    private String tableToString(Hashtable ht) {
        StringBuffer bfr = new StringBuffer();
        if (!ht.isEmpty()) {
            Enumeration e = ht.elements();
            while (e.hasMoreElements()) {
                RASConfig cfg = (RASConfig)e.nextElement();
                bfr.append(cfg.toString());
            }
        }
        return bfr.toString();
    }
}

