/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import java.io.StringWriter;

public class RASTraceFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -5685726042408116109L;
    protected static String[] attribs = new String[]{"loggingClass", "loggingMethod", "threadID", "logger"};

    public RASTraceFormatter() {
        this.addEventClass("com.ibm.ras.RASTraceEvent");
    }

    public String format(RASIEvent event) {
        String sep = this.getSeparator();
        StringBuffer bfr = new StringBuffer(256);
        bfr.append(this.getTime(event.getTimeStamp()) + sep);
        for (int j = 0; j < attribs.length; ++j) {
            String attrib = (String)event.getAttribute(attribs[j]);
            if (attrib == null) continue;
            bfr.append(attrib + sep);
        }
        bfr.append(this.lineSep);
        bfr.append("  ");
        bfr.append(this.getText((RASTraceEvent)event));
        return bfr.toString();
    }

    protected String getText(RASTraceEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        String stackTrace = (String)event.getAttribute("exceptionTrace");
        byte[] data = (byte[])event.getAttribute("hexData");
        if (stackTrace != null) {
            bfr.append(stackTrace);
        } else if (data != null) {
            bfr.append(this.bytesToHex(data));
        } else {
            bfr.append(event.getText());
            String[] parms = event.getParameters();
            if (parms != null) {
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", p" + (j + 1) + "=" + parms[j]);
                }
            }
        }
        if (stackTrace == null) {
            bfr.append(this.lineSep);
        }
        return bfr.toString();
    }

    protected String bytesToHex(byte[] data) {
        int byteCount = 1;
        StringWriter sw = new StringWriter();
        for (int lineStart = 0; lineStart < data.length; lineStart += 32) {
            int lineEnd = Math.min(lineStart + 32, data.length);
            StringBuffer asciiLine = new StringBuffer();
            for (int i = lineStart; i < lineEnd; ++i) {
                int b = data[i];
                if (b < 0) {
                    b += 256;
                }
                String hexStr = Integer.toString(b, 16).toUpperCase();
                if (b < 16) {
                    hexStr = "0" + hexStr;
                }
                sw.write(hexStr);
                if (byteCount % 16 == 0) {
                    sw.write("  ");
                } else if (byteCount % 2 == 0) {
                    sw.write(" ");
                }
                ++byteCount;
                if (b >= 32 && b <= 126) {
                    asciiLine.append((char)b);
                    continue;
                }
                asciiLine.append('.');
            }
            int padding = 32 - (lineEnd - lineStart);
            for (int j = 0; j < padding; ++j) {
                sw.write("  ");
                if (byteCount % 16 == 0) {
                    sw.write("  ");
                } else if (byteCount % 2 == 0) {
                    sw.write(" ");
                }
                ++byteCount;
            }
            sw.write(asciiLine.toString());
            sw.write(this.lineSep);
            sw.write("  ");
        }
        return sw.toString();
    }
}

