/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.formatting.Introspector;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatters<T extends FfdcProvider>
extends FfdcProviderDependent<T> {
    private final Map<Class<?>, Formatter> formatterCache = new HashMap();
    static final Formatter FormattableMarker = new Formatter(){

        @Override
        public void formatTo(Object objectToFormat, IncidentStream is) {
            assert (objectToFormat instanceof Formattable);
            ((Formattable)objectToFormat).formatTo(is);
        }

        @Override
        public String[] getSupportedTypeNames() {
            return null;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }
    };

    public Formatters(T provider) {
        super(provider);
    }

    public Formatter getFormatter(Object object) throws PrivilegedActionException {
        assert (!(object instanceof Class));
        Class<?> cl = object.getClass();
        Formatter f = this.formatterCache.get(cl);
        if (f == null) {
            f = this.getRegisteredFormatter(cl);
            if (f == null) {
                f = this.makeFormatter(cl);
            }
            this.formatterCache.put(cl, f);
        }
        return f;
    }

    public Formatter findFormatter(Class<?> cl) {
        Formatter f = this.formatterCache.get(cl);
        if (f == null && (f = this.getRegisteredFormatter(cl)) != null) {
            this.formatterCache.put(cl, f);
        }
        return f;
    }

    private Formatter getRegisteredFormatter(Class<?> cl) {
        return this.getRegisteredFormatter(cl, this.provider.getFormatters());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Formatter getRegisteredFormatter(Class<?> cl, List<Formatter> formatters) {
        String pname;
        Formatter choice = null;
        Package pkg = cl.getPackage();
        if (pkg == null) {
            if (!cl.isArray()) return null;
            pname = "[.*";
        } else {
            pname = pkg.getName() + ".*";
        }
        String cname = cl.getName();
        for (Formatter formatter : formatters) {
            if (formatter == null) continue;
            for (String stn : this.getSupportedTypeNames(formatter)) {
                if (cname.equals(stn) && this.isSupported(formatter, cl)) {
                    return formatter;
                }
                if (choice != null || !pname.equals(stn) || !this.isSupported(formatter, cl)) continue;
                choice = formatter;
            }
        }
        return choice;
    }

    private boolean isSupported(Formatter formatter, Class<?> cl) {
        try {
            return formatter.isSupported(cl);
        }
        catch (Exception e) {
            this.deregister(formatter, e);
            return false;
        }
    }

    private String[] getSupportedTypeNames(Formatter formatter) {
        try {
            String[] supportedTypes = formatter.getSupportedTypeNames();
            if (supportedTypes == null) {
                supportedTypes = new String[]{};
            }
            if (supportedTypes.length == 0) {
                this.deregister(formatter, new IllegalStateException("no type names supported"));
            }
            return supportedTypes;
        }
        catch (Exception e) {
            this.deregister(formatter, e);
            return new String[0];
        }
    }

    private void deregister(Formatter formatter, Throwable th) {
        this.provider.deregister(formatter);
    }

    protected <T> Formatter makeFormatter(Class<T> bottom) throws PrivilegedActionException {
        Formatter baseFormatter;
        Class<Object> upperLimit;
        if (Formattable.class.isAssignableFrom(bottom)) {
            upperLimit = this.getDeclarerOfFormatToMethod(bottom);
            if (bottom.equals(upperLimit)) {
                return FormattableMarker;
            }
            baseFormatter = FormattableMarker;
        } else {
            baseFormatter = null;
            upperLimit = Object.class;
        }
        Class<T> top = bottom;
        Class<T> c = top.getSuperclass();
        while (!upperLimit.equals(c)) {
            Formatter f = this.findFormatter(c);
            if (f != null && !f.getClass().equals(PartialIntrospector.class)) {
                return new PartialIntrospector(bottom, top, f);
            }
            top = c;
            c = c.getSuperclass();
        }
        assert (top.getSuperclass().equals(upperLimit));
        return new PartialIntrospector(bottom, top, baseFormatter);
    }

    protected boolean isIntrospector(Formatter f) {
        assert (f != null);
        return PartialIntrospector.class.equals(f.getClass());
    }

    final <T extends Formattable> Class<? super T> getDeclarerOfFormatToMethod(final Class<T> cl) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<? super T>>(){

            @Override
            public Class<? super T> run() {
                Class klass = cl;
                Method mFormatTo = null;
                while (mFormatTo == null && !Object.class.equals((Object)klass)) {
                    try {
                        mFormatTo = klass.getDeclaredMethod("formatTo", IncidentStream.class);
                    }
                    catch (NoSuchMethodException e) {
                        klass = klass.getSuperclass();
                    }
                }
                assert (mFormatTo != null);
                Class<?> dcl = mFormatTo.getDeclaringClass();
                return dcl;
            }
        });
    }

    void clear() {
        this.formatterCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialIntrospector
    extends Introspector {
        public PartialIntrospector(Class<?> cl, Class<?> upperBound, Formatter baseFormatter) {
            super(cl, upperBound, baseFormatter);
        }
    }
}

