/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.formatting;

import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.Klass;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayFormatter
implements Formatter {
    int COLUMN_BYTES = 4;
    int COLUMN_TOTAL = 4;
    private static final String DEAD_CHAR = ".";
    char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public final void formatTo(final Object o, IncidentStream is) {
        Class<?> cl = o.getClass();
        Class<?> componentType = cl.getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException();
        }
        if (Klass.isByte(componentType)) {
            IncidentStream.Writer<OutputStream> writer = new IncidentStream.Writer<OutputStream>(){

                @Override
                public void writeTo(OutputStream os) throws IOException {
                    PrintWriter pw = new PrintWriter(os);
                    ByteArrayFormatter.this.formatTo(pw, o);
                    pw.flush();
                    os.flush();
                }
            };
            is.write(writer);
            return;
        }
        this.formatTo(is, o);
    }

    private void formatTo(PrintWriter pw, Object objectToFormat) {
        int length = Array.getLength(objectToFormat);
        byte[] bytes = new byte[length];
        StringBuffer sb = new StringBuffer();
        int charCount = 0;
        pw.print('[');
        this.printColumnHeadings(pw);
        for (int i = 0; i < length; ++i) {
            byte o;
            bytes[i] = o = Array.getByte(objectToFormat, i);
            String charString = ByteArrayFormatter.pad(Integer.toHexString(o), 2);
            String tempString = charString.equalsIgnoreCase("00") || charString.equalsIgnoreCase("09") || charString.equalsIgnoreCase("0a") || charString.equalsIgnoreCase("0b") || charString.equalsIgnoreCase("0c") || charString.equalsIgnoreCase("0d") || charString.equalsIgnoreCase("07") ? DEAD_CHAR : new String(bytes, i, 1);
            if (i % this.COLUMN_BYTES == 0) {
                pw.print(" ");
                if (i % (this.COLUMN_BYTES * this.COLUMN_TOTAL) == 0) {
                    if (i != 0) {
                        pw.print("| " + sb.toString());
                        pw.print("\n");
                        pw.print(" ");
                        sb.delete(0, sb.length());
                        charCount = 0;
                    }
                    pw.print("0x" + ByteArrayFormatter.pad(Integer.toHexString(i), 8) + " (" + ByteArrayFormatter.pad(Integer.valueOf(i).toString(), 8, " ") + ") : ");
                }
                ++charCount;
            }
            sb.append(tempString);
            pw.print(this.hexChars[o >> 4 & 0xF]);
            pw.print(this.hexChars[o & 0xF]);
            charCount += 2;
            if (length - i != 1) continue;
            for (int padding = charCount; padding < 2 * this.COLUMN_TOTAL * this.COLUMN_BYTES + this.COLUMN_TOTAL; ++padding) {
                pw.print(" ");
            }
            pw.print(" | ");
            pw.print(sb.toString());
        }
        pw.print(']');
        pw.println();
    }

    private void formatTo(IncidentStream is, Object objectToFormat) {
        int alength = Array.getLength(objectToFormat);
        is.write(null, Character.valueOf('['));
        for (int i = 0; i < alength; ++i) {
            Object o = Array.get(objectToFormat, i);
            is.write(null, o);
        }
        is.write(null, Character.valueOf(']'));
    }

    @Override
    public String[] getSupportedTypeNames() {
        return new String[]{"[.*"};
    }

    @Override
    public boolean isSupported(Class<?> klass) {
        if (klass.isArray()) {
            return klass.getComponentType().equals(Byte.TYPE);
        }
        return false;
    }

    public void printColumnHeadings(PrintWriter pw) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        pw.print("        offset        : ");
        int c = 0;
        int h = 0;
        while (c < this.COLUMN_BYTES * this.COLUMN_TOTAL) {
            if (c % this.COLUMN_BYTES == 0 && c != 0) {
                pw.print(" ");
            }
            if (h == hexChars.length) {
                h = 0;
            }
            pw.print(hexChars[h] + " ");
            ++c;
            ++h;
        }
        pw.print("   ");
        c = 0;
        h = 0;
        while (c < this.COLUMN_BYTES * this.COLUMN_TOTAL / 2) {
            if (h >= hexChars.length) {
                h = 0;
            }
            pw.print(hexChars[h] + " ");
            ++c;
            h += 2;
        }
        pw.print("\n");
    }

    private static String pad(String s, int l) {
        return ByteArrayFormatter.pad(s, l, null);
    }

    private static String pad(String s, int l, String p) {
        String rc;
        if (p == null) {
            p = "0";
        }
        if (s.length() < l) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < l - s.length(); ++i) {
                sb.append(p);
            }
            rc = sb.toString() + s;
        } else {
            rc = s.substring(s.length() - l);
        }
        return rc;
    }
}

