/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.am._Alarm;
import com.ibm.ffdc.Manager;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlarmManagerThreadCSLM
implements Dumpable,
Runnable {
    private static final TraceComponent tc = Tr.register(AlarmManagerThreadCSLM.class, null, null);
    protected boolean dumped = false;
    ConcurrentSkipListMap<_Alarm, _Alarm> alarmQ;
    boolean deferredAlarms = false;
    volatile _Alarm waitingOn;

    AlarmManagerThreadCSLM(ConcurrentSkipListMap<_Alarm, _Alarm> _AlarmQ, boolean runDeferred) {
        Tr.registerDumpable(tc, this);
        this.alarmQ = _AlarmQ;
        this.deferredAlarms = runDeferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean threadContinue = true;
        while (threadContinue) {
            try {
                boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
                Map.Entry<_Alarm, _Alarm> next = null;
                ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = this.alarmQ;
                synchronized (concurrentSkipListMap) {
                    next = this.alarmQ.firstEntry();
                    while (true) {
                        _Alarm current;
                        long currentTime = System.currentTimeMillis();
                        if (next != null && next.getValue().expirationTime - currentTime <= 0L && (next = this.alarmQ.pollFirstEntry()) != null) {
                            _Alarm a;
                            _Alarm _Alarm2 = a = next.getValue();
                            synchronized (_Alarm2) {
                                if (!a.fired) {
                                    if (a.expirationTime - currentTime <= 0L) {
                                        a.fired = true;
                                        break;
                                    }
                                    this.alarmQ.put(a, a);
                                }
                            }
                        }
                        this.waitingOn = current = next == null ? null : next.getValue();
                        next = this.alarmQ.firstEntry();
                        if (next == null) {
                            if (current != null) continue;
                            this.alarmQ.wait();
                            continue;
                        }
                        if (next.getValue() != current) continue;
                        long delta = next.getValue().expirationTime - currentTime;
                        if (!this.deferredAlarms || AlarmManager.getActiveWork() > 0) {
                            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Alarm manager thread waiting", new Object[]{next.getValue(), delta});
                            }
                            this.alarmQ.wait(delta);
                            continue;
                        }
                        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Alarm Manager waiting for next server work request");
                        }
                        this.alarmQ.wait();
                    }
                }
                next.getValue().execute();
            }
            catch (InterruptedException ex) {
                try {
                    Manager.Ffdc.log(ex, this, "com.ibm.ejs.util.am.AlarmManagerThread.run", "121", this);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm manager thread received an exception: ", ncdfe);
                    }
                    threadContinue = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Alarm Manager Dump --");
            Tr.dump(tc, this.alarmQ.size() + " scheduled alarms");
            ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = this.alarmQ;
            synchronized (concurrentSkipListMap) {
                Tr.dump(tc, "alarm queue contents", this.alarmQ.values());
            }
        }
        finally {
            this.dumped = true;
        }
    }

    @Override
    public void resetDump() {
        this.dumped = false;
    }
}

