/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.am._Alarm;
import com.ibm.ffdc.Manager;
import com.ibm.ws.util.BinaryHeap;

class AlarmManagerThreadBH
implements Dumpable,
Runnable {
    private static final TraceComponent tc = Tr.register(AlarmManagerThreadBH.class, null, null);
    protected boolean dumped = false;
    BinaryHeap alarmQ;
    boolean deferredAlarms = false;

    AlarmManagerThreadBH(BinaryHeap _AlarmQ, boolean runDeferred) {
        Tr.registerDumpable(tc, this);
        this.alarmQ = _AlarmQ;
        this.deferredAlarms = runDeferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean threadContinue = true;
        while (threadContinue) {
            try {
                _Alarm next = null;
                BinaryHeap binaryHeap = this.alarmQ;
                synchronized (binaryHeap) {
                    next = null;
                    if (this.alarmQ.isEmpty()) {
                        this.alarmQ.wait();
                    } else {
                        next = (_Alarm)this.alarmQ.minimum();
                        long delta = next.expirationTime - System.currentTimeMillis();
                        if (delta <= 0L) {
                            this.alarmQ.deleteMin();
                            next.fired = true;
                        } else {
                            next = null;
                            if (!this.deferredAlarms || AlarmManager.getActiveWork() > 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alarm manager thread waiting", new Long(delta));
                                }
                                this.alarmQ.wait(delta);
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alarm Manager waiting for next server work request");
                                }
                                this.alarmQ.wait();
                            }
                        }
                    }
                }
                if (next == null) continue;
                next.execute();
            }
            catch (InterruptedException ex) {
                try {
                    Manager.Ffdc.log(ex, this, "com.ibm.ejs.util.am.AlarmManagerThread.run", "121", this);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm manager thread received an exception: ", ncdfe);
                    }
                    threadContinue = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Alarm Manager Dump --");
            Tr.dump(tc, this.alarmQ.size() + " scheduled alarms");
            BinaryHeap binaryHeap = this.alarmQ;
            synchronized (binaryHeap) {
                Tr.dump(tc, "alarm queue contents", this.alarmQ.elements());
            }
        }
        finally {
            this.dumped = true;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }
}

