/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManagerBH;
import com.ibm.ejs.util.am.AlarmManagerCSLM;
import java.util.concurrent.Executor;

public class AlarmManager {
    private static final TraceComponent tc = Tr.register(AlarmManager.class, null, null);
    private static Implementation impl = null;

    public static final Alarm create(long n, AlarmListener listener, Object alarmContext) {
        return impl.createDeferrable(n, listener, alarmContext);
    }

    public static final Alarm create(long n, AlarmListener listener) {
        return impl.createDeferrable(n, listener, null);
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext) {
        return impl.createNonDeferrable(n, l, alarmContext);
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext, Executor executor) {
        return impl.createNonDeferrable(n, l, alarmContext, executor);
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l) {
        return impl.createNonDeferrable(n, l, null);
    }

    public static final Alarm createDeferrable(long n, AlarmListener l, Object alarmContext) {
        return impl.createDeferrable(n, l, alarmContext);
    }

    public static final Alarm createDeferrable(long n, AlarmListener l) {
        return impl.createDeferrable(n, l, null);
    }

    static final void cancel(Alarm a) {
        impl.cancel(a);
    }

    public static final boolean disableAlarm(Alarm a) {
        return impl.disableAlarm(a);
    }

    public static synchronized void incActiveWork() {
        impl.incActiveWork();
    }

    public static void decActiveWork() {
        impl.decActiveWork();
    }

    public static synchronized int getActiveWork() {
        return impl.getActiveWork();
    }

    static {
        boolean isCSLM = true;
        try {
            Class.forName("java.util.concurrent.ConcurrentSkipListMap");
        }
        catch (Exception e) {
            isCSLM = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "AlarmManager isCSLM: ", isCSLM);
        }
        impl = isCSLM ? new AlarmManagerCSLM() : new AlarmManagerBH();
    }

    static interface Implementation {
        public Alarm createNonDeferrable(long var1, AlarmListener var3, Object var4);

        public Alarm createNonDeferrable(long var1, AlarmListener var3, Object var4, Executor var5);

        public Alarm createDeferrable(long var1, AlarmListener var3, Object var4);

        public void cancel(Alarm var1);

        public boolean disableAlarm(Alarm var1);

        public void incActiveWork();

        public void decActiveWork();

        public int getActiveWork();
    }
}

