/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.client.ui;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.logging.MessageConverter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NLS {
    private static TraceComponent tc = Tr.register(NLS.class);
    private static NLS messages = null;
    static final String baseClassPackage = "com.ibm.ejs.resources";
    private String bundleName;
    private ResourceBundle bundle;

    private static NLS getMessages() {
        if (messages == null) {
            messages = new NLS("messages");
        }
        return messages;
    }

    public NLS(String bundleName) {
        this(bundleName, Locale.getDefault());
    }

    public NLS(String bundleName, Locale locale) {
        block6: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NLS, " + bundleName + '/' + locale);
            }
            this.bundleName = bundleName;
            try {
                String fullBundleName = bundleName;
                this.bundle = TraceNLS.getResourceBundle(fullBundleName, locale);
            }
            catch (MissingResourceException e) {
                try {
                    String fullBundleName = "com.ibm.ejs.resources." + bundleName;
                    this.bundle = TraceNLS.getResourceBundle(fullBundleName, locale);
                }
                catch (MissingResourceException ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ejs.sm.client.ui.NLS.NLS", "171", this);
                    if (!tc.isEventEnabled()) break block6;
                    String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                    Tr.warning(tc, msg, new Object[]{ex});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NLS");
        }
    }

    public NLS(String bundleName, boolean fullyQualified) {
        this(bundleName, Locale.getDefault(), fullyQualified, true);
    }

    public NLS(String bundleName, Locale locale, boolean fullyQualified) {
        this(bundleName, locale, fullyQualified, true);
    }

    public NLS(String bundleName, Locale locale, boolean fullyQualified, boolean logFFDC) {
        block4: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NLS, " + bundleName + '/' + locale);
            }
            this.bundleName = bundleName;
            try {
                String fullBundleName = fullyQualified ? bundleName : "com.ibm.ejs.resources." + bundleName;
                this.bundle = TraceNLS.getResourceBundle(fullBundleName, locale);
            }
            catch (MissingResourceException ex) {
                if (!logFFDC) break block4;
                Manager.Ffdc.log(ex, this, "com.ibm.ejs.sm.client.ui.NLS.NLS", "241", this);
                if (!tc.isEventEnabled()) break block4;
                String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                Tr.warning(tc, msg, new Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NLS");
        }
    }

    public NLS(String bundleName, Locale locale, ClassLoader cl) {
        block6: {
            this.bundle = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NLS, " + bundleName + '/' + locale);
            }
            this.bundleName = bundleName;
            try {
                this.bundle = ResourceBundle.getBundle(bundleName, locale, cl);
            }
            catch (Exception ex) {
                try {
                    this.bundle = TraceNLS.getResourceBundle(bundleName, locale);
                }
                catch (Exception ex2) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ejs.sm.client.ui.NLS.NLS", "280", this);
                    if (!tc.isEventEnabled()) break block6;
                    String msg = NLS.getMessages().getString("NLS.resourceBundleError", "Encountered an error while loading class PropertyResourceBundle from a JAR file {0}");
                    Tr.warning(tc, msg, new Object[]{ex});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NLS");
        }
    }

    public String getString(String key) throws MissingResourceException {
        if (key == null) {
            if (tc.isEventEnabled()) {
                String msg = NLS.getMessages().getString("NLS.nullKey", "Null lookup key passed to NLS");
                Tr.warning(tc, msg);
            }
            return null;
        }
        if (this.bundle == null) {
            if (tc.isEventEnabled()) {
                String msg = NLS.getMessages().getString("NLS.noBundles", "Encountered an internal error. No valid bundles.");
                Tr.warning(tc, msg);
            }
            throw new MissingResourceException(this.bundleName, this.bundleName, key);
        }
        String rtn = null;
        rtn = this.bundle.getString(key);
        if (TraceNLS.isMessageIdConversionEnabled()) {
            rtn = MessageConverter.convert(rtn, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6);
        }
        return rtn;
    }

    public String getString(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        try {
            String result = this.getString(key);
            if (TraceNLS.isMessageIdConversionEnabled()) {
                result = MessageConverter.convert(result, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6);
            }
            return result;
        }
        catch (MissingResourceException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ejs.sm.client.ui.NLS.getString", "353", this);
            return defaultString;
        }
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = this.getString(key);
            if (TraceNLS.isMessageIdConversionEnabled()) {
                result = MessageConverter.convert(result, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6);
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ejs.sm.client.ui.NLS.getFormattedMessage", "375", this);
            return MessageFormat.format(defaultString, args);
        }
    }

    public int getInteger(String key, int defaultValue) {
        int result = defaultValue;
        try {
            if (key != null) {
                result = this.getInteger(key);
            }
        }
        catch (MissingResourceException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ejs.sm.client.ui.NLS.getInteger", "393", this);
        }
        return result;
    }

    public int getInteger(String key) throws MissingResourceException {
        String result = this.getString(key);
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException nfe) {
            Manager.Ffdc.log(nfe, this, "com.ibm.ejs.sm.client.ui.NLS.getInteger", "411", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse " + result + " as Integer.");
            }
            String msg = NLS.getMessages().getString("NLS.integerParseError", "Unable to parse as integer.");
            throw new MissingResourceException(msg, this.bundleName, key);
        }
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public String getName() {
        return this.bundleName;
    }

    public String getKey(String key) throws MissingResourceException {
        return this.getString(key);
    }

    public String getKey(String key, String defaultString) {
        return this.getString(key, defaultString);
    }

    public boolean isResourceLoaded() {
        return this.bundle != null;
    }
}

