/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.TraceStateChangeListener;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class TraceComponent {
    public static final String $sccsid = "@(#) 1.11 SERV1/ws/code/ras.lite/src/com/ibm/ejs/ras/TraceComponent.java, WAS.ras.lite, WAS70.SERV1, cf050925.09 07/08/31 05:40:03 [6/25/09 08:11:55]";
    private String name;
    private String group = "";
    private String bundle;
    private static final int TRACE_LEVEL_OFF = 16;
    private int traceLevel = 16;
    private Logger logger = null;
    private volatile boolean isDumpEnabled = false;
    private volatile boolean isDebugEnabled = false;
    private volatile boolean isEntryEnabled = false;
    private volatile boolean isEventEnabled = false;
    private volatile boolean isDetailEnabled = false;
    private volatile boolean isConfigEnabled = false;
    private volatile boolean isInfoEnabled = false;
    private volatile boolean isAuditEnabled = false;
    private volatile boolean isWarningEnabled = false;
    private volatile boolean isErrorEnabled = false;
    private volatile boolean isFatalEnabled = false;
    private volatile boolean isServiceEnabled = false;
    private static volatile long noActiveTraceComponents = 0L;
    private TraceStateChangeListener wsLogger = null;
    private static String[][] traceLevels = new String[][]{{"all"}, {"finest", "debug"}, {"finer", "entryExit"}, {"fine", "event"}, {"detail"}, {"config"}, {"info"}, {"audit"}, {"warning"}, {"severe", "error"}, {"fatal"}, {"off"}};

    TraceComponent(String name2) {
        this.name = name2;
    }

    public TraceComponent(String name2, String group, String bundle) {
        this.name = name2;
        if (group != null) {
            this.group = group;
        }
        this.bundle = bundle;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private static synchronized void incrementNoActiveTraceComponents() {
        ++noActiveTraceComponents;
    }

    private static synchronized void decrementNoActiveTraceComponents() {
        if (noActiveTraceComponents > 0L) {
            --noActiveTraceComponents;
        }
    }

    public final synchronized void setTraceSpec(String s) {
        if (s != null) {
            boolean oldTraceState = this.isDumpEnabled | this.isDebugEnabled | this.isEntryEnabled | this.isEventEnabled | this.isDetailEnabled | this.isConfigEnabled | this.isInfoEnabled | this.isAuditEnabled | this.isWarningEnabled | this.isErrorEnabled | this.isFatalEnabled | this.isServiceEnabled;
            this.isDumpEnabled = false;
            this.isDebugEnabled = false;
            this.isEntryEnabled = false;
            this.isEventEnabled = false;
            this.isDetailEnabled = false;
            this.isConfigEnabled = false;
            this.isInfoEnabled = false;
            this.isAuditEnabled = false;
            this.isWarningEnabled = false;
            this.isErrorEnabled = false;
            this.isFatalEnabled = false;
            this.isServiceEnabled = false;
            this.traceLevel = 16;
            StringTokenizer st = new StringTokenizer(s, ":");
            while (st.hasMoreTokens()) {
                this.traceSpec(st.nextToken());
            }
            boolean newTraceState = this.isDumpEnabled | this.isDebugEnabled | this.isEntryEnabled | this.isEventEnabled | this.isDetailEnabled | this.isConfigEnabled | this.isInfoEnabled | this.isAuditEnabled | this.isWarningEnabled | this.isErrorEnabled | this.isFatalEnabled | this.isServiceEnabled;
            if (!oldTraceState && newTraceState) {
                TraceComponent.incrementNoActiveTraceComponents();
            }
            if (oldTraceState && !newTraceState) {
                TraceComponent.decrementNoActiveTraceComponents();
            }
            if (this.wsLogger != null) {
                this.wsLogger.traceStateChanged();
            }
        }
    }

    public static boolean isAnyTracingEnabled() {
        return noActiveTraceComponents > 0L;
    }

    public final boolean isDumpEnabled() {
        return this.isDumpEnabled;
    }

    final void setResourceBundleName(String name2) {
        this.bundle = name2;
    }

    public final String getResourceBundleName() {
        return this.bundle;
    }

    public final void setLoggerForCallback(TraceStateChangeListener logger) {
        this.wsLogger = logger;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.isEntryEnabled;
    }

    public final boolean isEventEnabled() {
        return this.isEventEnabled;
    }

    public final boolean isDetailEnabled() {
        return this.isDetailEnabled;
    }

    public final boolean isConfigEnabled() {
        return this.isConfigEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public final boolean isAuditEnabled() {
        return this.isAuditEnabled;
    }

    public final boolean isWarningEnabled() {
        return this.isWarningEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public final boolean isFatalEnabled() {
        return this.isFatalEnabled;
    }

    public final boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }

    private void traceSpec(String s) {
        String clazz = "*";
        String level = "all";
        String setting = "enabled";
        StringTokenizer st = new StringTokenizer(s, "=");
        if (st.hasMoreTokens()) {
            clazz = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            level = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            setting = st.nextToken();
        }
        if (setting.equals("enabled")) {
            boolean process;
            if (clazz.endsWith("*")) {
                if (clazz.length() > 1) {
                    clazz = clazz.substring(0, clazz.length() - 1);
                }
                process = clazz.equals("*") || this.name.startsWith(clazz) || this.group.startsWith(clazz);
            } else {
                boolean bl = process = this.name.equals(clazz) || this.group.equals(clazz);
            }
            if (process) {
                int found = -1;
                int traceLevelCount = 1;
                for (int i = 0; i < Array.getLength(traceLevels) && found < 0; ++i) {
                    for (int j = 0; j < Array.getLength(traceLevels[i]) && found < 0; ++j) {
                        if (level.equals(traceLevels[i][j])) {
                            found = i;
                            this.traceLevel = traceLevelCount;
                        }
                        ++traceLevelCount;
                    }
                }
                if (found >= 0) {
                    this.isDumpEnabled = found <= 0;
                    this.isDebugEnabled = found <= 1;
                    this.isEntryEnabled = found <= 2;
                    this.isEventEnabled = found <= 3;
                    this.isDetailEnabled = found <= 4;
                    this.isConfigEnabled = found <= 5;
                    this.isInfoEnabled = found <= 6;
                    this.isAuditEnabled = found <= 7;
                    this.isServiceEnabled = found <= 7;
                    this.isWarningEnabled = found <= 8;
                    this.isErrorEnabled = found <= 9;
                    this.isFatalEnabled = found <= 10;
                }
            }
        }
    }

    public final int getLevel() {
        return this.traceLevel;
    }
}

