/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.PoolImplBase;
import com.ibm.ejs.csi.PoolManagerImpl;
import com.ibm.websphere.csi.PoolDiscardStrategy;
import com.ibm.websphere.csi.PooledObject;
import com.ibm.websphere.pmi.PmiBean;

public final class PoolImplThreadSafe
extends PoolImplBase {
    private Object[] elements;
    private int topOfPool;
    private PoolDiscardStrategy discardStrategy;
    private int maxDrainAmount;
    private int ivInactiveNoDrainCount = 0;
    private boolean ivManaged = true;
    private PmiBean beanPerf = null;

    PoolImplThreadSafe(int min2, int max2, int drainAggressivenessPercentage, PmiBean pmiBean, PoolDiscardStrategy d, PoolManagerImpl poolManager) {
        this.minSize = min2;
        this.maxSize = max2;
        this.elements = new Object[this.maxSize];
        this.topOfPool = 0;
        this.discardStrategy = d;
        this.poolMgr = poolManager;
        this.beanPerf = pmiBean;
        int drainOpportunity = this.maxSize - this.minSize;
        this.maxDrainAmount = drainOpportunity <= 0 ? 0 : (drainOpportunity <= 100 / drainAggressivenessPercentage ? drainOpportunity : drainOpportunity * drainAggressivenessPercentage / 100);
        if (this.beanPerf != null) {
            this.beanPerf.poolCreated(this.topOfPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        this.inactive = false;
        this.ivInactiveNoDrainCount = 0;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            Object o;
            if (this.topOfPool > 0) {
                o = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
            } else {
                o = null;
            }
            if (!this.ivManaged) {
                this.poolMgr.add(this);
                this.ivManaged = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.beanPerf != null) {
                this.beanPerf.objectRetrieve(this.topOfPool, o != null);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Object o) {
        boolean discarded = false;
        if (o instanceof PooledObject) {
            ((PooledObject)o).reset();
        }
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            if (this.topOfPool < this.maxSize && this.ivManaged) {
                this.elements[this.topOfPool++] = o;
            } else {
                discarded = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (discarded) {
                if (o instanceof PooledObject) {
                    ((PooledObject)o).discard();
                } else if (this.discardStrategy != null) {
                    this.discardStrategy.discard(o);
                }
            }
            if (this.beanPerf != null) {
                this.beanPerf.objectReturn(this.topOfPool, discarded);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void periodicDrain() {
        Object[] objectArray;
        int numDiscarded = 0;
        Object o = null;
        while (this.inactive && this.topOfPool > this.minSize && numDiscarded < this.maxDrainAmount) {
            objectArray = this.elements;
            // MONITORENTER : this.elements
            if (this.inactive && this.topOfPool > this.minSize && numDiscarded < this.maxDrainAmount) {
                o = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
                ++numDiscarded;
            }
            // MONITOREXIT : objectArray
            if (o instanceof PooledObject) {
                ((PooledObject)o).discard();
                continue;
            }
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(o);
        }
        if (this.inactive && numDiscarded == 0) {
            objectArray = this.elements;
            // MONITORENTER : this.elements
            ++this.ivInactiveNoDrainCount;
            if (this.ivInactiveNoDrainCount > 4) {
                this.poolMgr.remove(this);
                this.ivManaged = false;
            }
            // MONITOREXIT : objectArray
        } else {
            this.ivInactiveNoDrainCount = 0;
        }
        if (this.beanPerf == null) return;
        this.beanPerf.poolDrained(this.topOfPool, numDiscarded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void completeDrain() {
        Object o = null;
        int numDiscarded = this.topOfPool;
        while (true) {
            if (this.topOfPool <= 0) {
                if (this.beanPerf == null) return;
                this.beanPerf.poolDrained(0, numDiscarded);
                return;
            }
            Object[] objectArray = this.elements;
            // MONITORENTER : this.elements
            if (this.topOfPool > 0) {
                o = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
            }
            // MONITOREXIT : objectArray
            if (o instanceof PooledObject) {
                ((PooledObject)o).discard();
                continue;
            }
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(o);
        }
    }
}

