/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ArchiveUtil {
    protected static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = ArchiveUtil.class.getName();
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    public static final String DOT_JSP = ".jsp";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static java.io.File tempDirectory;
    protected static boolean isAIX;
    public static final boolean DO_ADD_DIRECTORIES = true;
    public static final boolean DONT_ADD_DIRECTORIES = false;
    public static final boolean DO_LIST_DETAILS = true;
    public static final boolean DONT_LIST_DETAILS = false;
    public static final int COPY_BUFFER_SIZE = 32768;
    protected static Object systemTempDirSync;
    protected static boolean didSetSystemTempDirName;
    protected static String systemTempDirName;

    public static String classNameToJavaUri(String className) {
        return className.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String className) {
        return className.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(DOT_CLASS)) {
            return null;
        }
        String truncated = ArchiveUtil.truncateIgnoreCase(classUri, DOT_CLASS);
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String directoryname, String filename, char separator) {
        String uri = directoryname;
        if (!directoryname.endsWith(separator + "") && !filename.startsWith(separator + "")) {
            uri = uri + separator;
        }
        return uri + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            if (!(in instanceof ZipInputStream)) {
                in.close();
            }
            if (!(out instanceof ZipOutputStream)) {
                out.close();
            }
        }
    }

    public static java.io.File createTempDirectory(String baseName, java.io.File parentDirectory) throws IOException {
        java.io.File tempFile;
        String methodName = "createTempDirectory";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{baseName, parentDirectory});
        }
        if ((tempFile = ArchiveUtil.createTempFile(baseName, parentDirectory)).exists()) {
            if (!tempFile.delete()) {
                logger.logp(Level.SEVERE, className, methodName, "Could not delete new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            } else {
                logger.logp(Level.FINER, className, methodName, "Deleted new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            }
        } else {
            logger.logp(Level.SEVERE, className, methodName, "New temporary file already deleted [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
        }
        if (!tempFile.mkdir()) {
            logger.logp(Level.WARNING, className, methodName, "Could not create temporary directory [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            if (!parentDirectory.exists()) {
                logger.logp(Level.SEVERE, className, methodName, "Parent directory does not exist [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File createTempFile(String baseName) throws IOException {
        return ArchiveUtil.createTempFile(baseName, ArchiveUtil.getTempDirectory());
    }

    public static java.io.File createTempFile(String baseName, java.io.File directory) throws IOException {
        String fileName;
        String methodName = "createTempFile";
        boolean isLoggable = logger.isLoggable(Level.FINER);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{baseName, directory});
        }
        if (directory == null) {
            if (isLoggable) {
                logger.logp(Level.FINER, className, methodName, "No temporary location was specified; using the system defined location");
            }
        } else if (!directory.exists()) {
            if (isLoggable) {
                logger.logp(Level.FINER, className, methodName, "Temporary location does not exist!");
            }
            logger.logp(Level.WARNING, className, methodName, "Specified temporary directory [ {0} ] with basename [ {1} ] does not exist; using system temporary directory", new Object[]{directory, baseName});
            directory = null;
            if (isLoggable) {
                String tempDir = ArchiveUtil.getSystemTempDirName();
                logger.logp(Level.FINER, className, methodName, "system temporary directory [ {0} ]", tempDir);
            }
        } else if (!directory.isDirectory()) {
            logger.logp(Level.SEVERE, className, methodName, "Temporary location [ {0} ] with basename [ {1} ] is not a directory", new Object[]{directory, baseName});
        }
        if ((fileName = ArchiveUtil.getFileNameTail(baseName)).length() < 3) {
            fileName = "WSTMP" + fileName;
        }
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "Temp File Prefix: [ {0} ]", fileName);
        }
        java.io.File tempFile = java.io.File.createTempFile(fileName, null, directory);
        if (isLoggable) {
            if (!tempFile.exists()) {
                logger.logp(Level.WARNING, className, methodName, "Temp File Was Not Created: [ {0} ]", tempFile);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN Temp File: [ {0} ]", tempFile);
        }
        return tempFile;
    }

    public static boolean delete(java.io.File rootFile) {
        Level useLevel;
        boolean doLog;
        boolean didDelete;
        String methodName = "delete";
        boolean isFinestEnabled = logger.isLoggable(Level.FINEST);
        String fileName = rootFile.getName();
        if (isFinestEnabled) {
            logger.logp(Level.FINEST, className, methodName, "ENTRY on file [ {0} ]", fileName);
        }
        if (rootFile == null) {
            if (isFinestEnabled) {
                logger.logp(Level.FINEST, className, methodName, "RETURN [ true ] - file is null");
            }
            return true;
        }
        if (!rootFile.exists()) {
            if (isFinestEnabled) {
                logger.logp(Level.FINEST, className, methodName, "RETURN [ true ] - file already does not exist");
            }
            return true;
        }
        boolean isDirectory = rootFile.isDirectory();
        int numChildren = 0;
        int numChildDeleteFailures = 0;
        if (isDirectory) {
            java.io.File[] childFiles;
            if (isFinestEnabled) {
                logger.logp(Level.FINEST, className, methodName, "Detected directory; recursing");
            }
            if ((childFiles = rootFile.listFiles()) != null) {
                numChildren = childFiles.length;
                for (int childFileNo = 0; childFileNo < numChildren; ++childFileNo) {
                    java.io.File nextChildFile = childFiles[childFileNo];
                    if (ArchiveUtil.delete(nextChildFile)) continue;
                    ++numChildDeleteFailures;
                }
            } else {
                logger.logp(Level.WARNING, className, methodName, "Failed to obtain directory listing for [ {0} ]", fileName);
            }
        }
        boolean didDeleteRoot = rootFile.delete();
        boolean bl = didDelete = numChildDeleteFailures == 0 && didDeleteRoot;
        if (!didDelete) {
            doLog = true;
            useLevel = Level.WARNING;
        } else {
            doLog = isFinestEnabled;
            useLevel = Level.FINEST;
        }
        if (doLog) {
            logger.logp(useLevel, className, methodName, "Is directory [ {0} ]", new Boolean(isDirectory));
            if (isDirectory) {
                logger.logp(useLevel, className, methodName, "Num children [ {0} ]", new Integer(numChildren));
                logger.logp(useLevel, className, methodName, "Failed child deletes [ {0} ]", new Integer(numChildDeleteFailures));
            }
            logger.logp(useLevel, className, methodName, "Root was deleted [ {0} ]", new Boolean(didDeleteRoot));
            logger.logp(useLevel, className, methodName, "RETURN [ {0} ]", new Boolean(didDelete));
        }
        return didDelete;
    }

    public static List getWriteProtectedFiles(java.io.File aFile, List aList) {
        if (aList == null) {
            aList = new ArrayList<java.io.File>();
        }
        if (aFile.exists() && !aFile.canWrite()) {
            aList.add(aFile);
        }
        if (aFile.isDirectory()) {
            java.io.File[] files = aFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ArchiveUtil.getWriteProtectedFiles(files[i], aList);
            }
        }
        return aList;
    }

    public static String deriveEARRelativeURI(String classpathEntry, Archive anArchive) {
        String methodName = "deriveEARRelativeURI";
        if (anArchive.isEARFile()) {
            logger.throwing(className, methodName, new Throwable("Dummy throwable for trace"));
            logger.logp(Level.SEVERE, className, "deriveEARRelativeURI", "Call on EAR is not allowed; EAR [ {0} ]", anArchive.getURI());
            return null;
        }
        return ArchiveUtil.deriveEARRelativeURI(classpathEntry, anArchive.getURI());
    }

    public static String deriveEARRelativeURI(String classpathEntry, String archiveUri) {
        String workingDirLowerCase;
        String resolvedPathLowerCase;
        String resolvedPath;
        String parent;
        String workingDir;
        String methodName = "deriveEARRelativeURI";
        boolean isLoggable = logger.isLoggable(Level.FINEST);
        if (isLoggable) {
            logger.logp(Level.FINEST, className, methodName, "ENTRY Archive [ {0} ] and classpath entry [ {1} ]", new Object[]{archiveUri, classpathEntry});
        }
        try {
            workingDir = new java.io.File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to obtain canonical path for current directory processing archive [ {0} ] and classpath entry [ {1} ]", new Object[]{archiveUri, classpathEntry});
            logger.throwing(className, methodName, e);
            if (isLoggable) {
                logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            }
            return null;
        }
        if (isLoggable) {
            logger.logp(Level.FINEST, className, methodName, "Working directory [ {0} ]", workingDir);
        }
        if ((parent = ArchiveUtil.getFileNameParent(archiveUri)) == null || parent.equals("")) {
            parent = ".";
        }
        if (isLoggable) {
            logger.logp(Level.FINEST, className, methodName, "Selected parent [ {0} ]", parent);
        }
        try {
            resolvedPath = new java.io.File(parent, classpathEntry).getCanonicalPath();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, className, methodName, "Unable to obtain canonical path for resolved entry processing archive [ {0} ], classpath entry [ {1} ], and parent [ {2} ]", new Object[]{archiveUri, classpathEntry, parent});
            logger.throwing(className, methodName, e);
            if (isLoggable) {
                logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            }
            return null;
        }
        if (isLoggable) {
            logger.logp(Level.FINEST, className, methodName, "Resolved entry [ {0} ]", resolvedPath);
        }
        if (!(resolvedPathLowerCase = resolvedPath.toLowerCase()).startsWith(workingDirLowerCase = workingDir.toLowerCase())) {
            logger.logp(Level.FINER, className, methodName, "Resolved entry reaches outside of parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{archiveUri, classpathEntry, parent, resolvedPath});
            if (isLoggable) {
                logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            }
            return null;
        }
        if (resolvedPathLowerCase.equals(workingDirLowerCase)) {
            if (!classpathEntry.equals("./")) {
                logger.logp(Level.FINER, className, methodName, "Resolved entry maps to parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{archiveUri, classpathEntry, parent, resolvedPath});
            }
            if (isLoggable) {
                logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            }
            return null;
        }
        int start = workingDir.length() == 0 ? 0 : (workingDir.endsWith(java.io.File.separator) ? workingDir.length() : workingDir.length() + 1);
        String resolvedEntry = resolvedPath.substring(start, resolvedPath.length());
        resolvedEntry = resolvedEntry.replace(java.io.File.separatorChar, '/');
        if (isLoggable) {
            logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", resolvedEntry);
        }
        return resolvedEntry;
    }

    public static String getFileNameExtension(String uri) {
        int index;
        if (uri != null && (index = uri.lastIndexOf(".")) != -1) {
            return uri.substring(index + 1);
        }
        return "";
    }

    public static String getFileNameParent(String uri) {
        int lastIndex;
        String methodName = "getFileNameParent";
        if (uri == null) {
            logger.logp(Level.WARNING, className, methodName, "RETURN null; null module URI.");
            return "";
        }
        String tempURI = uri.replace('\\', '/');
        if (tempURI.endsWith("/")) {
            logger.logp(Level.WARNING, className, methodName, "Module URI has trailing file separator characters [ {0} ]", uri);
            while (tempURI.endsWith("/")) {
                tempURI = tempURI.substring(0, tempURI.length() - 1);
            }
        }
        if ((lastIndex = tempURI.lastIndexOf(47)) == -1) {
            logger.logp(Level.FINER, className, methodName, "ENTER / RETURN empty string; module URI has no parent directories [ {0} ]", uri);
            return "";
        }
        if (lastIndex == 0) {
            logger.logp(Level.WARNING, className, methodName, "RETURN '/'; module URI has a leading separator [ {0} ]", uri);
            return "/";
        }
        logger.logp(Level.FINER, className, methodName, "ENTER URI [ {0} ]", uri);
        String result = uri.substring(0, lastIndex);
        logger.logp(Level.FINER, className, methodName, "RETURN trimmed URI [ {0} ]", result);
        return result;
    }

    public static String getFileNameTail(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }

    public static ModuleFile getModuleFile(EObject ddObject) {
        String methodName = "getModuleFile";
        logger.logp(Level.FINEST, className, methodName, "ENTER [ {0} ]", ddObject);
        Resource res = ddObject.eResource();
        if (res == null) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; Descriptor resource is null.");
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(res);
        if (archive == null) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; Archive is null.");
            return null;
        }
        if (!archive.isModuleFile()) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; Archive is not a module.");
            return null;
        }
        if (!(res instanceof XMLResource)) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; Archive resource is not an XML Resource.");
            return null;
        }
        XMLResource xmlRes = (XMLResource)res;
        if (xmlRes.isAlt()) {
            ModuleFile mf = ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, res);
            logger.logp(Level.FINEST, className, methodName, "RETURN module file found using altDD [ {0} ]", mf);
            return mf;
        }
        logger.logp(Level.FINEST, className, methodName, "RETURN module file found [ {0} ]", archive);
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile ear, Resource res) {
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        Module m = ear.getDeploymentDescriptor().getModuleHavingAltDD(uri);
        if (m == null) {
            return null;
        }
        ModuleRef ref = ear.getModuleRef(m);
        if (ref == null) {
            return null;
        }
        return ref.getModuleFile();
    }

    public static String getModuleFileTypeName(int moduleType) {
        switch (moduleType) {
            case 2: {
                return CommonArchiveResourceHandler.A_Application_file;
            }
            case 1: {
                return CommonArchiveResourceHandler.An_Application_Client_JAR_file;
            }
            case 3: {
                return CommonArchiveResourceHandler.An_EJB_JAR_file;
            }
            case 4: {
                return CommonArchiveResourceHandler.A_WAR_file;
            }
            case 5: {
                return CommonArchiveResourceHandler.A_RAR_file;
            }
        }
        return null;
    }

    public static Archive getArchive(Resource res) {
        String methodName = "getArchive";
        logger.logp(Level.FINEST, className, methodName, "ENTER with resource [ {0} ]", res);
        if (res == null) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; resource is null.");
            return null;
        }
        ResourceSet set = res.getResourceSet();
        if (set == null) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; resource set is null.");
            return null;
        }
        URIConverter conv = set.getURIConverter();
        if (conv == null || !(conv instanceof ArchiveURIConverterImpl)) {
            logger.logp(Level.FINEST, className, methodName, "RETURN null; URI converter is null or not an archive converter.");
            return null;
        }
        Archive a = ((ArchiveURIConverterImpl)conv).getArchive();
        logger.logp(Level.FINEST, className, methodName, "RETURN archive [{0}]", a);
        return a;
    }

    public static String getOSUri(String uri) {
        char sep = java.io.File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static String getOSUri(String directoryname, String filename) {
        String osDirName = ArchiveUtil.getOSUri(directoryname);
        String osFileName = ArchiveUtil.getOSUri(filename);
        return ArchiveUtil.concatUri(osDirName, osFileName, java.io.File.separatorChar);
    }

    public static EObject getRoot(Resource aResource) throws EmptyResourceException {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            throw new EmptyResourceException(aResource.getURI().toString());
        }
        return (EObject)extent.get(0);
    }

    public static java.io.File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String aString) {
        return ArchiveUtil.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        for (int i = 0; i < size && tok.hasMoreTokens(); ++i) {
            tokens[i] = tok.nextToken();
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String message) {
        logger.logp(Level.FINER, className, "inform", message);
    }

    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArchiveUtil.copy(in, out);
        return out.toByteArray();
    }

    public static boolean isJavaResource(Resource aResource) {
        return JavaURL.isJavaURL((String)aResource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource res) {
        return URIMappingRegistryImpl.INSTANCE.getURI(res.getURI()) != res.getURI();
    }

    public static boolean isPlatformMetaResource(Resource res) {
        URI uri = res.getURI();
        return "platform".equals(uri.scheme()) && "meta".equals(uri.segment(0));
    }

    public static boolean isNullOrEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive referencedJAR, Archive referencingJAR) {
        if (referencedJAR.isWARFile()) {
            return false;
        }
        if (referencedJAR == referencingJAR) {
            return false;
        }
        return referencingJAR.isApplicationClientFile() || !referencedJAR.isApplicationClientFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Archive archive, String uri) throws FileNotFoundException, IOException {
        InputStream in = null;
        try {
            in = archive.getInputStream(uri);
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void setIsRuntime(boolean aBoolean) {
        isRuntime = aBoolean;
    }

    public static void setShouldUseTempDirectoryForRead(boolean value) {
        String methodName = "setShouldUseTempDirectoryForRead";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{new Boolean(shouldUseTempDirectoryForRead), new Boolean(value)});
        }
        shouldUseTempDirectoryForRead = value;
    }

    public static void setTempDirectory(java.io.File newTempDirectory) {
        String methodName = "setTempDirectory";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{tempDirectory, newTempDirectory});
        }
        tempDirectory = newTempDirectory;
        tempDirectoryName = newTempDirectory.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "'tempDirectoryName' (absolute path) [ {0} ]", tempDirectoryName);
        if (!tempDirectory.exists()) {
            logger.logp(Level.WARNING, className, methodName, "Temporary directory [ {0} ] does not exist", tempDirectory);
        } else if (!tempDirectory.isDirectory()) {
            logger.logp(Level.SEVERE, className, methodName, "Temporary directory [ {0} ] is not a directory", tempDirectory);
        } else {
            logger.logp(Level.FINER, className, methodName, "Temporary directory verified to exist and is a directory.");
        }
    }

    public static void setTempDirectoryName(String newTempDirectoryName) throws ArchiveException {
        String methodName = "setTempDirectoryName";
        logger.logp(Level.FINER, className, methodName, "ENTER; New name [ {0} ]", newTempDirectoryName);
        java.io.File dir = new java.io.File(newTempDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                logger.logp(Level.WARNING, className, methodName, "Could not create temporary directory.");
                String message = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_dir_EXC_, new Object[]{newTempDirectoryName});
                ArchiveException ex = new ArchiveException(message);
                logger.throwing(className, methodName, ex);
                throw ex;
            }
            logger.logp(Level.FINER, className, methodName, "Verified that the temporary directory exists; marking for deletion.");
            DeleteOnExitUtility.markForDeletion(dir);
        }
        ArchiveUtil.setTempDirectory(dir);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] toLocalURLs(List entries, String uriRoot) {
        int entryNo;
        String methodName = "toLocalURLs";
        boolean isFinerEnabled = logger.isLoggable(Level.FINER);
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "ENTER");
            logger.logp(Level.FINER, className, methodName, "  URI Root [ {0} ]", uriRoot);
            Iterator useEntries = entries.iterator();
            entryNo = 0;
            while (useEntries.hasNext()) {
                logger.logp(Level.FINER, className, methodName, "  Entry [ {0} ]", useEntries.next());
                ++entryNo;
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (entryNo = 0; entryNo < entries.size(); ++entryNo) {
            URL aUrl;
            java.io.File aFile;
            String uri;
            String pathEntry = uri = (String)entries.get(entryNo);
            boolean createdTempZip = false;
            if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Processing [ {0} ]", pathEntry);
            }
            if (!(aFile = new java.io.File(pathEntry)).isAbsolute()) {
                pathEntry = ArchiveUtil.getOSUri(uriRoot, pathEntry);
                if (isFinerEnabled) {
                    logger.logp(Level.FINER, className, methodName, "Target has a relative path; adjusted to [ {0} ]", pathEntry);
                }
                aFile = new java.io.File(pathEntry);
            } else if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Target has an absolute path");
            }
            if (!aFile.exists()) {
                if (!isFinerEnabled) continue;
                logger.logp(Level.FINER, className, methodName, "Skipping; Target location does not exist [ {0} ]", aFile);
                continue;
            }
            if (!createdTempZip) {
                if (aFile.isDirectory()) {
                    if (isFinerEnabled) {
                        logger.logp(Level.FINER, className, methodName, "Target is a directory");
                    }
                    if (!pathEntry.endsWith(java.io.File.separator)) {
                        pathEntry = pathEntry + java.io.File.separatorChar;
                        if (isFinerEnabled) {
                            logger.logp(Level.FINER, className, methodName, "Adjusted path to add separator [ {0} ]", pathEntry);
                        }
                        aFile = new java.io.File(pathEntry);
                    }
                } else {
                    ZipFile zip = null;
                    try {
                        ArchiveUtil.aixDisplay("ArchiveUtil.toLocalURLs");
                        if (isFinerEnabled) {
                            logger.logp(Level.FINER, className, methodName, "Attempting to open target as archive ...");
                        }
                        zip = new ZipFile(aFile);
                    }
                    catch (Exception ex) {
                        String message = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_classpath_WARN_, new Object[]{pathEntry});
                        ArchiveUtil.inform(message);
                        if (!isFinerEnabled) continue;
                        logger.throwing(className, methodName, ex);
                        logger.logp(Level.FINER, className, methodName, "Skipping; Failed to open target as archive [ {0} ]", aFile);
                        continue;
                    }
                    finally {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException ignore) {}
                        }
                    }
                }
            }
            if ((aUrl = ArchiveUtil.createURL(aFile)) != null) {
                urls.add(aUrl);
                continue;
            }
            String message = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_cp_file_WARN_, new Object[]{pathEntry});
            ArchiveUtil.inform(message);
        }
        URL[] urlArray = new URL[urls.size()];
        URL[] result = urls.toArray(urlArray);
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "  Count of URLs [ {0} ]", new Integer(result.length));
            for (int urlNo = 0; urlNo < result.length; ++urlNo) {
                logger.logp(Level.FINER, className, methodName, "  URL [ {0} ] [ {1} ]", new Object[]{new Integer(urlNo), result[urlNo]});
            }
            logger.logp(Level.FINER, className, methodName, "RETURN");
        }
        return result;
    }

    private static URL createURL(java.io.File aFile) {
        URL aUrl;
        block2: {
            String methodName = "createURL";
            aUrl = null;
            try {
                aUrl = aFile.toURL();
            }
            catch (MalformedURLException ex) {
                if (!logger.isLoggable(Level.FINER)) break block2;
                logger.throwing(className, methodName, ex);
                logger.logp(Level.FINER, className, methodName, "RETURN null; Exception processing [ {0} ]", aFile);
            }
        }
        return aUrl;
    }

    public static String truncateFromFrontIgnoreCase(String aString, String leadingSubString) {
        if (!aString.toLowerCase().startsWith(leadingSubString.toLowerCase())) {
            return aString;
        }
        return aString.substring(leadingSubString.length(), aString.length());
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }

    public static String uriToClassName(String uri) {
        return ArchiveUtil.truncateIgnoreCase(uri.replace('/', '.'), DOT_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        if (moduleFile == null) {
            return false;
        }
        if (moduleFile.isRARFile()) {
            return true;
        }
        InputStream in = null;
        String uri = moduleFile.getDeploymentDescriptorUri();
        try {
            in = moduleFile.getInputStream(uri);
            DocumentType docType = XmlDocumentReader.readDocumentType((InputStream)in, (String)uri);
            if (docType == null) {
                boolean bl = false;
                return bl;
            }
            String[] ids = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
            if (ids == null) {
                boolean ex = false;
                return ex;
            }
            boolean ex = ids[0].equals(docType.getPublicId()) && ids[1].equals(docType.getSystemId());
            return ex;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFastSpecVersion(ModuleFile moduleFile) {
        String methodName = "getFastSpecVersion";
        logger.logp(Level.FINER, className, methodName, "ENTER Module URI [ {0} ]", moduleFile.getURI());
        InputStream in = null;
        String uri = moduleFile.getDeploymentDescriptorUri();
        LoadStrategy loadStrategy = moduleFile.getLoadStrategy();
        if (loadStrategy instanceof LoadStrategyImpl) {
            String resourcesPath;
            try {
                resourcesPath = ((LoadStrategyImpl)loadStrategy).getResourcesPath();
                logger.logp(Level.FINER, className, methodName, "Resource path [ {0} ]", resourcesPath);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Failed to obtain resources path.");
                resourcesPath = null;
            }
            if (resourcesPath != null) {
                String ddPath = resourcesPath + "/" + uri;
                logger.logp(Level.FINER, className, methodName, "Descriptor path [ {0} ]", ddPath);
                try {
                    in = new FileInputStream(ddPath);
                    logger.logp(Level.FINER, className, methodName, "Obtained resource based input stream");
                }
                catch (IOException e) {
                    logger.logp(Level.FINER, className, methodName, "Unable to open resource based input stream.");
                }
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Unknown load strategy type [ {0} ]", loadStrategy.getClass().getName());
        }
        if (in == null) {
            try {
                in = moduleFile.getInputStream(uri);
                logger.logp(Level.FINER, className, methodName, "Obtained a binaries based input stream");
            }
            catch (IOException e) {
                logger.throwing(className, methodName, e);
                logger.logp(Level.FINER, className, methodName, "Failed to open binaries based input stream");
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Integer(-1));
                return -1;
            }
        }
        try {
            DocumentType docType = null;
            InputSource source = new InputSource(in);
            XmlDocumentReader aReader = new XmlDocumentReader(source);
            aReader.setValidate(false);
            Document aDocument = aReader.parseDocument();
            if (aDocument != null) {
                docType = aDocument.getDoctype();
            }
            int version = -1;
            if (null != docType) {
                String publicID = docType.getPublicId();
                String systemID = docType.getSystemId();
                if (publicID != null && systemID != null) {
                    version = ArchiveUtil.lookupVersion(moduleFile, publicID, systemID);
                }
            }
            if (version == -1) {
                NamedNodeMap map;
                String schemaName = null;
                String versionString = null;
                if (aDocument != null && null == docType && null != (map = aDocument.getDocumentElement().getAttributes())) {
                    Node versionNode;
                    Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                    if (null != schemaNode) {
                        schemaName = schemaNode.getNodeValue();
                    }
                    if (null != (versionNode = map.getNamedItem("version"))) {
                        versionString = versionNode.getNodeValue();
                    }
                }
                if (null != schemaName) {
                    version = ArchiveUtil.lookupVersion(moduleFile, schemaName);
                }
                if (version == -1) {
                    version = ArchiveUtil.parseVersionString(moduleFile, versionString);
                }
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Integer(version));
            int n = version;
            return n;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static int parseVersionString(ModuleFile moduleFile, String versionAttr) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (null == versionAttr) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5")) {
                version = 50;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (null == versionAttr) {
                version = 21;
            } else if (versionAttr.equals("1.1")) {
                version = 11;
            } else if (versionAttr.equals("2.0")) {
                version = 20;
            } else if (versionAttr.equals("2.1")) {
                version = 21;
            } else if (versionAttr.equals("3.0")) {
                version = 30;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (null == versionAttr) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5")) {
                version = 50;
            }
        } else if (moduleFile.isWARFile()) {
            if (null == versionAttr) {
                version = 24;
            } else if (versionAttr.equals("2.2")) {
                version = 22;
            } else if (versionAttr.equals("2.3")) {
                version = 23;
            } else if (versionAttr.equals("2.4")) {
                version = 24;
            } else if (versionAttr.equals("2.5")) {
                version = 25;
            }
        } else if (moduleFile.isRARFile()) {
            version = null == versionAttr ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String schemaName) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd") != -1) {
                version = 30;
            } else if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isWARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd")) {
                version = 25;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (moduleFile.isRARFile() && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String publicID, String systemID) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application_1.3.dtd"))) {
                version = 13;
            } else if (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd"))) {
                version = 12;
            } else if (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.4//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_4.dtd") || systemID.equals("http://java.sun.com/dtd/application_1_4.dtd"))) {
                version = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemID.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (moduleFile.isApplicationClientFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isWARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemID.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (moduleFile.isRARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemID.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return version;
    }

    protected static void aixDisplay(String text) {
        if (ArchiveUtil.getIsAIX()) {
            System.out.println(text);
        }
    }

    protected static boolean getIsAIX() {
        return isAIX;
    }

    public static ZipFileLoadStrategy createExpandedZipFileLoadStrategy(String uri, Archive parent) throws ArchiveException {
        String methodName = "createExpandedZipFileLoadStrategy";
        boolean isLoggable = logger.isLoggable(Level.FINER);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTER on URI [ {0} ] for parent [ {0} ]", new Object[]{uri, parent});
        }
        CommonarchiveFactoryImpl factory = (CommonarchiveFactoryImpl)CommonarchiveFactory.eINSTANCE;
        ZipFileLoadStrategy loadStrategy = factory.createNestedZipFileLoadStrategy(uri, parent.getLoadStrategy());
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "RETURN Load strategy [ {0} ]", loadStrategy);
        }
        return loadStrategy;
    }

    public static LoadStrategy createExpandedLoadStrategy(String uri, Archive parent) {
        String methodName = "createExpandedLoadStrategy";
        boolean isLoggable = logger.isLoggable(Level.FINER);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTER on URI [ {0} ] for parent [ {0} ]", new Object[]{uri, parent});
        }
        CommonarchiveFactoryImpl factory = (CommonarchiveFactoryImpl)CommonarchiveFactory.eINSTANCE;
        LoadStrategy loadStrategy = factory.createNestedLoadStrategy(uri, parent.getLoadStrategy(), true);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "RETURN Load strategy [ {0} ]", loadStrategy);
        }
        return loadStrategy;
    }

    public static LoadStrategy createCompressedLoadStrategy(String uri, Archive parent) {
        String methodName = "createCompressedLoadStrategy";
        boolean isLoggable = logger.isLoggable(Level.FINER);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTER on URI [ {0} ] for parent [ {0} ]", new Object[]{uri, parent});
        }
        NestedArchiveLoadStrategyImpl compressedLoadStrategy = new NestedArchiveLoadStrategyImpl(parent.getLoadStrategy());
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "RETURN Load strategy [ {0} ]", compressedLoadStrategy);
        }
        return compressedLoadStrategy;
    }

    public static boolean isMergedDD(EObject module) {
        String uri;
        if (module == null) {
            return false;
        }
        Resource moduleResource = module.eResource();
        return moduleResource != null && (uri = moduleResource.getURI().toString()).contains("_merged");
    }

    public static List listArchiveEntries(java.io.File file, boolean addDirectories) throws IOException {
        return ArchiveUtil.listArchiveEntries(file, addDirectories, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List listArchiveEntries(java.io.File file, boolean addDirectories, boolean listDetails) throws IOException {
        String methodName = "listArchiveEntries";
        String fileName = file.getName();
        logger.logp(Level.FINEST, className, methodName, "ENTRY [ {0} ]", fileName);
        ArrayList<Object> entryNames = new ArrayList<Object>();
        JarFile jarFile = new JarFile(file);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextEntry = entries.nextElement();
                String nextEntryName = nextEntry.getName();
                if (!addDirectories && nextEntry.isDirectory()) {
                    logger.logp(Level.FINEST, className, methodName, "Skipping directory archive entry [ {0} ]", nextEntryName);
                    continue;
                }
                logger.logp(Level.FINEST, className, methodName, "Next archive entry [ {0} ]", nextEntryName);
                if (listDetails) {
                    entryNames.add(new EntryDetails(nextEntry));
                    continue;
                }
                entryNames.add(nextEntryName);
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed to close archive file [ {0} ]", fileName);
            }
        }
        return entryNames;
    }

    public static Set collectFileUris(Iterator files) {
        HashSet<String> fileUris = new HashSet<String>();
        while (files.hasNext()) {
            File nextFile = (File)files.next();
            fileUris.add(nextFile.getURI());
        }
        return fileUris;
    }

    public static String concatenateUris(String parentUri, String childUri) {
        if (parentUri == null || parentUri.length() == 0) {
            return childUri;
        }
        if (childUri == null || childUri.length() == 0) {
            return parentUri;
        }
        return parentUri + "/" + childUri;
    }

    public static void dumpStackTrace(String className, String methodName) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer sb = new StringBuffer("Stack trace of " + methodName + " caller:\n\n");
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < traceElements.length; ++i) {
            sb.append("                                                              ").append(traceElements[i] + "\n");
        }
        logger.logp(Level.FINER, className, methodName, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.io.File writeFileToTemp(String sourceName, InputStream sourceStream, String baseTempName) throws IOException {
        String methodName = "writeFileToTemp";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        java.io.File tempFile = ArchiveUtil.createTempFileWithFallback(baseTempName);
        String tempName = tempFile.getName();
        logger.logp(Level.FINER, className, methodName, "Opening output [ {0} ]", tempName);
        FileOutputStream tempStream = new FileOutputStream(tempFile);
        try {
            long bytesWritten = ArchiveUtil.transfer(sourceName, sourceStream, tempName, tempStream);
        }
        finally {
            ((OutputStream)tempStream).close();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File extractFileToTemp(String sourceZipName, String sourceEntryName, String baseTempName) throws IOException {
        String methodName = "extractFileToTemp";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        java.io.File tempFile = ArchiveUtil.createTempFileWithFallback(baseTempName);
        ArchiveUtil.transferEntryOut(sourceZipName, sourceEntryName, tempFile);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File createTempFileWithFallback(String baseName) throws IOException {
        java.io.File tempFile;
        String methodName = "createTempFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", baseName);
        java.io.File tempDir = ArchiveUtil.getTempDirectory();
        logger.logp(Level.FINER, className, methodName, "Using temporary directory [ {0} ] ", tempDir);
        try {
            tempFile = ArchiveUtil.createTempFile(baseName);
            logger.logp(Level.FINER, className, methodName, "Using temporary file [ {0} ] ", tempFile);
        }
        catch (IOException firstException) {
            logger.logp(Level.WARNING, className, methodName, "Failed to create temp file in defined preset temporary directory.");
            logger.throwing(className, methodName, firstException);
            try {
                tempFile = ArchiveUtil.createTempFile(baseName, null);
            }
            catch (IOException secondException) {
                logger.logp(Level.WARNING, className, methodName, "Failed to create temp file in system temporary directory.");
                logger.throwing(className, methodName, secondException);
                throw firstException;
            }
        }
        DeleteOnExitUtility.markForDeletion(tempFile);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferEntryOut(String sourceZipName, String sourceEntryName, java.io.File outputFile) throws IOException {
        String methodName = "transferEntryOut";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        logger.logp(Level.FINER, className, methodName, "Opening output [ {0} ]", outputFile.getName());
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            logger.logp(Level.FINER, className, methodName, "Opening source zip [ {0} ]", sourceZipName);
            ZipFile sourceZipFile = new ZipFile(sourceZipName);
            try {
                logger.logp(Level.FINER, className, methodName, "Locating source entry [ {0} ]", sourceEntryName);
                ZipEntry sourceEntry = sourceZipFile.getEntry(sourceEntryName);
                if (sourceEntry == null) {
                    throw new FileNotFoundException("Could not find [ " + sourceEntryName + " ] in [ " + sourceZipName + " ]");
                }
                logger.logp(Level.FINER, className, methodName, "Opening source entry input stream [ {0} ]", sourceEntryName);
                BufferedInputStream sourceEntryStream = new BufferedInputStream(sourceZipFile.getInputStream(sourceEntry));
                long bytesWritten = ArchiveUtil.transfer(sourceEntryName, sourceEntryStream, outputFile.getName(), outputStream);
            }
            finally {
                sourceZipFile.close();
            }
        }
        finally {
            ((OutputStream)outputStream).close();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static long transfer(String sourceName, InputStream sourceStream, String targetName, OutputStream targetStream) throws IOException {
        int nextRead;
        String methodName = "transfer";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER copy from [ {0} ] to [ {1} ]", new Object[]{sourceName, targetName});
        }
        byte[] buffer = new byte[32768];
        long totalRead = 0L;
        while ((nextRead = sourceStream.read(buffer)) > 0) {
            totalRead += (long)nextRead;
            targetStream.write(buffer, 0, nextRead);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Long(totalRead));
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemTempDirName() {
        String methodName = "getSystemTempDirName";
        Object object = systemTempDirSync;
        synchronized (object) {
            if (!didSetSystemTempDirName) {
                try {
                    systemTempDirName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("java.io.tmpdir");
                        }
                    });
                }
                catch (SecurityException securityException) {
                    systemTempDirName = null;
                    logger.logp(Level.FINER, className, methodName, "Unable to obtain system temporary directory.");
                }
                logger.logp(Level.FINER, className, methodName, "Recorded system temp directory [ {0} ]", systemTempDirName);
                didSetSystemTempDirName = true;
            }
        }
        return systemTempDirName;
    }

    static {
        String osName = System.getProperty("os.name");
        isAIX = osName != null && osName.equalsIgnoreCase("AIX");
        systemTempDirSync = new Object();
        didSetSystemTempDirName = false;
    }

    public static class EntryDetails {
        public final String name;
        public final long size;
        public final long lastModified;
        public final boolean isDirectory;

        public EntryDetails(ZipEntry zipEntry) {
            this.name = zipEntry.getName();
            this.size = zipEntry.getSize();
            this.lastModified = zipEntry.getTime();
            this.isDirectory = zipEntry.isDirectory();
        }
    }
}

