/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.LifeCycleTracker;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.LifeCycleTrackerElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategy;

public class ZipFileLoadStrategyImpl
extends LoadStrategyImpl
implements ZipFileLoadStrategy {
    protected static boolean TRACK_ZIPFILE_ACCESS = true;
    protected static boolean ZIPFILE_OPEN = true;
    protected static final String OPEN_STRING = "ZIPFILE OPEN ";
    protected static final String CLOSE_STRING = "ZIPFILE CLOSE";
    protected static String className = ZipFileLoadStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static Logger loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    protected java.io.File _file = null;
    private String _absolutePath = null;
    protected ZipFile _zipFile = null;
    private StackTraceElement[] _createStack = null;
    private StackTraceElement[] _openStack = null;
    private StackTraceElement[] _closeStack = null;
    private String _createTime = null;
    private String _openTime = null;
    private String _closeTime = null;
    protected String _hash;
    public static final LifeCycleTracker lct = new LifeCycleTracker(loggerLCT);
    protected static final DateFormat stampFormat = new SimpleDateFormat("M/dd/yy HH:mm:ss:SSS z");

    protected static String getTimeStamp() {
        return stampFormat.format(Calendar.getInstance().getTime());
    }

    public ZipFileLoadStrategyImpl() {
        String methodName = "constructor without file";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", this);
        if (loggerLCT.isLoggable(Level.FINER)) {
            this._createTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._createStack = Thread.currentThread().getStackTrace();
        }
    }

    public ZipFileLoadStrategyImpl(java.io.File file) throws IOException {
        String methodName = "constructor with file";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        if (loggerLCT.isLoggable(Level.FINER)) {
            this._createTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._createStack = Thread.currentThread().getStackTrace();
        }
        this.setFile(file);
        this.setZipFile(new ZipFile(file));
        this.closeZipFile(!TRACK_ZIPFILE_ACCESS);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this);
    }

    public String getBinariesPath() throws FileNotFoundException {
        String methodName = "getBinariesPath";
        Archive archive = (Archive)this.container;
        String archiveURI = archive != null ? archive.getURI() : "***NULL ARCHIVE***";
        logger.logp(Level.FINER, className, methodName, "ENTRY for archive [ {0} ]", archiveURI);
        String absolutePath = this.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", absolutePath);
        return absolutePath;
    }

    protected void finalize() throws Throwable {
        String methodName = "finalize";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        super.finalize();
        this.describeFile(Level.FINEST, "Debug for finalize() case");
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this);
    }

    public void closeZipFile() throws IOException {
        this.closeZipFile(TRACK_ZIPFILE_ACCESS);
    }

    public void closeZipFile(boolean trackZipFileAccess) throws IOException {
        String methodName = "closeZipFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        ZipFile zipToClose = this._zipFile;
        if (zipToClose != null) {
            logger.logp(Level.FINER, className, methodName, "Closing zip file [ {0} ]", zipToClose.getName());
            if (trackZipFileAccess) {
                this.trackZipFileAccess(!ZIPFILE_OPEN);
            }
            this.setZipFile(null);
            zipToClose.close();
        } else {
            logger.logp(Level.FINER, className, methodName, "The zip file was already closed.");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this);
    }

    public void close() {
        String methodName = "close";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        this.describeFile(Level.FINEST, "Debug for close() case");
        super.close();
        try {
            this.closeZipFile();
        }
        catch (IOException e) {
            logger.logp(Level.FINEST, className, methodName, "Ignoring Throwable exception from zipfile close [ {0} ]", e);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this);
    }

    protected boolean primContains(String uri) {
        String methodName = "close";
        ZipFile zf = this.getZipFile();
        if (zf == null) {
            logger.logp(Level.SEVERE, className, methodName, "ZipFile not found [ {0} ].", this.getZipFileName());
            this.errorDescribeFile("Error case - primContains() found null zipfile");
            return false;
        }
        return zf.getEntry(uri) != null;
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this._absolutePath;
    }

    public java.io.File getFile() {
        return this._file;
    }

    public java.io.File getFile(boolean cannotBeNull) throws FileNotFoundException {
        java.io.File file = this.getFile();
        if (!cannotBeNull) {
            return file;
        }
        if (file != null) {
            return file;
        }
        String errorMessage = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.archive_closed_EXC_, new Object[]{((Archive)this.container).getURI()});
        if (logger.isLoggable(Level.SEVERE)) {
            logger.logp(Level.SEVERE, className, "getFile", errorMessage);
            this.errorDescribeFile("Error case - getFile() found null file");
        }
        throw new FileNotFoundException(errorMessage);
    }

    public List getFiles() {
        String methodName = "getFiles";
        logger.entering(className, methodName);
        ArrayList<File> list = new ArrayList<File>();
        ZipFile zf = this.getZipFile();
        if (zf == null) {
            logger.logp(Level.SEVERE, className, methodName, "ZipFile not found [ {0} ].", this.getZipFileName());
            this.errorDescribeFile("Error case - getFiles() found null zipfile");
        } else {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || this.collectedLooseArchiveFiles.containsKey(entry.getName())) continue;
                File aFile = this.createFile(entry.getName());
                aFile.setSize(entry.getSize());
                aFile.setLastModified(entry.getTime());
                list.add(aFile);
            }
        }
        try {
            this.closeZipFile();
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException when closing zipfile");
        }
        logger.exiting(className, methodName, list);
        return list;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        String methodName = "getInputStream";
        try {
            ZipFile zf = this.getZipFile();
            ZipEntry entry = zf.getEntry(uri);
            if (entry == null) {
                throw new FileNotFoundException(uri);
            }
            return new BufferedInputStream(zf.getInputStream(entry));
        }
        catch (IllegalStateException zipClosed) {
            if (loggerLCT.isLoggable(Level.FINER)) {
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Create Stack", this._createTime, this._createStack));
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Open Stack", this._openTime, this._openStack));
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Close Stack", this._closeTime, this._closeStack));
            }
            throw new IOException(zipClosed.toString());
        }
        catch (NullPointerException e) {
            if (loggerLCT.isLoggable(Level.FINER)) {
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Create Stack", this._createTime, this._createStack));
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Open Stack", this._openTime, this._openStack));
                loggerLCT.logp(Level.SEVERE, className, methodName, this.dumpStack("Close Stack", this._closeTime, this._closeStack));
            }
            throw new IOException(e.toString());
        }
    }

    public ZipFile getZipFile() {
        java.io.File f = this.getFile();
        String methodName = "getZipFile";
        logger.logp(Level.FINEST, className, methodName, "ENTRY file [ {0} ]", f);
        this.describeFile(Level.FINEST, "Debug for getZipFile() case");
        if (f == null) {
            logger.logp(Level.SEVERE, className, methodName, "File not found.");
            this.errorDescribeFile("Error case - getZipFile() file not found");
        } else if (this._zipFile != null) {
            logger.logp(Level.FINEST, className, methodName, "The zip file is already opened; will answer the existing zip file.");
        } else {
            try {
                logger.logp(Level.FINER, className, methodName, "Opening zip file [ {0} ]", this._file.getName());
                this._zipFile = new ZipFile(f);
                this.trackZipFileAccess(ZIPFILE_OPEN);
            }
            catch (ZipException e) {
                logger.logp(Level.FINER, className, methodName, "Ignoring ZipException [ {0} ] ", e);
                logger.logp(Level.FINER, className, methodName, "An exception occurred while attempting to open the zipfile; null will be returned.");
            }
            catch (IOException e) {
                logger.logp(Level.FINER, className, methodName, "Ignoring IOException [ {0} ] ", e);
                logger.logp(Level.FINER, className, methodName, "An exception occurred while attempting to open the zipfile; null will be returned.");
            }
        }
        logger.logp(Level.FINEST, className, methodName, "RETURN [ {0} ]", this._zipFile);
        return this._zipFile;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        String methodName = "isUsing";
        logger.logp(Level.FINER, className, methodName, "ENTRY file [ {0} ]", aSystemFile);
        boolean inUse = false;
        java.io.File f = this.getFile();
        if (f != null && f.equals(aSystemFile)) {
            inUse = true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN ZipFileLoadStrategy isUsing file [ {0} ]", new Boolean(inUse));
        return inUse;
    }

    public void setFile(java.io.File newFile) {
        String methodName = "setFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", newFile);
        this.describeFile(Level.FINER, "Debug for setFile() old file");
        this._file = newFile;
        if (this._file != null) {
            this._absolutePath = this._file.getAbsolutePath();
        }
        this.describeFile(Level.FINER, "Debug for setFile() new file ");
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setZipFile(ZipFile newZipFile) {
        String methodName = "setZipFile";
        logger.logp(Level.FINEST, className, methodName, "ENTRY/RETURN  [ {0} ]", newZipFile);
        this._zipFile = newZipFile;
    }

    public String getZipFileName() {
        return this._absolutePath;
    }

    public void trackZipFileAccess(boolean zipFileOpen) {
        String traceActivityString;
        String methodName = "trackZipFileAccess";
        if (!loggerLCT.isLoggable(Level.FINER)) {
            return;
        }
        if (zipFileOpen) {
            this._openTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._openStack = Thread.currentThread().getStackTrace();
        } else {
            this._closeTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._closeStack = Thread.currentThread().getStackTrace();
        }
        if (zipFileOpen) {
            traceActivityString = OPEN_STRING;
            zflRepresentation zflr = new zflRepresentation(this._file, Thread.currentThread().getStackTrace());
            String hash = zflr.hashCode() + this._file.getPath();
            this._hash = lct.add(hash, zflr);
        } else {
            traceActivityString = CLOSE_STRING;
            lct.remove(this._hash);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n  Activity: ").append(traceActivityString).append("     ZipFileLoadStrategy [ ").append(this).append(" ] ");
        if (this._file != null) {
            sb.append("\n  Activity: ").append(traceActivityString).append("         file      [ ").append(Integer.toHexString(this._file.hashCode())).append(" ").append(this._file).append(" ] ");
        }
        sb.append("\n  Activity: ").append(traceActivityString).append("         zip file  [ ").append(this._zipFile).append(" ] ");
        sb.append("\n  Activity: ").append(traceActivityString).append("         container [ ").append(this.getContainer()).append(" ] ");
        logger.logp(Level.FINER, className, methodName, sb.toString());
    }

    protected void errorDescribeFile(String tag) {
        String methodName = "errorDescribeFile";
        this.describeFile(Level.SEVERE, tag);
        logger.logp(Level.SEVERE, className, methodName, this.dumpStack("Failure Stack", ZipFileLoadStrategyImpl.getTimeStamp(), Thread.currentThread().getStackTrace()));
        logger.logp(Level.SEVERE, className, methodName, this.dumpStack("Create Load Strategy Stack", this._createTime, this._createStack));
        logger.logp(Level.SEVERE, className, methodName, this.dumpStack("Open ZipFile Stack", this._openTime, this._openStack));
        logger.logp(Level.SEVERE, className, methodName, this.dumpStack("Close ZipFile Stack", this._closeTime, this._closeStack));
    }

    protected void describeFile(Level level, String tag) {
        String methodName = "describeFile";
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuffer sb = new StringBuffer("Describing file associated with ZipFileLoadStrategy [ ");
        sb.append(tag).append(" ] :\n");
        sb.append("\nLoadStrategy [ ").append(this).append(" ]");
        sb.append("\nContainer    [ ").append(this.container).append(" ]");
        if (this.container != null) {
            sb.append("\n   URI       [ ").append(this.container.getURI()).append(" ]");
            if (this.container.isArchive()) {
                Archive a = (Archive)this.container;
                if (a.isOpen()) {
                    sb.append("\n   Archive   [ open ]");
                } else {
                    sb.append("\n   Archive   [ CLOSED ]");
                }
            }
        }
        sb.append("\nisOpen       [ ").append(this.isOpen).append(" ]");
        sb.append("\nFile         [ ").append(this._file).append(" ]");
        sb.append("\n  Abs Path   [ ").append(this._absolutePath).append(" ]");
        if (this._file != null) {
            sb.append("\n  Name       [ ").append(this._file.getName()).append(" ]");
            sb.append("\n  Path       [ ").append(this._file.getPath()).append(" ]");
            sb.append("\n  Exists     [ ").append(this._file.exists()).append(" ] ");
        }
        sb.append("\nZip File     [ ").append(this._zipFile).append(" ]");
        if (this._zipFile != null) {
            sb.append("\n  Name       [ ").append(this._zipFile.getName()).append(" ]");
            sb.append("\n  Size       [ ").append(this._zipFile.size()).append(" ]");
        }
        logger.logp(level, className, methodName, sb.toString());
    }

    protected String dumpStack(String tag, String timeStamp, StackTraceElement[] trace) {
        StringBuffer sb = new StringBuffer();
        if (timeStamp == null || trace == null) {
            sb.append("\n  ");
            sb.append("Stack trace unavailable for [ ");
            sb.append(tag);
            sb.append(" ]\n");
        } else {
            sb.append("\n  ");
            sb.append("Stack trace for [ ");
            sb.append(tag);
            sb.append(" ] recorded at [");
            sb.append(timeStamp);
            sb.append(" ]:\n");
            for (int i = 0; i < trace.length; ++i) {
                sb.append("      ");
                sb.append(trace[i]);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private class zflRepresentation
    implements LifeCycleTrackerElement {
        private java.io.File _zfl_file;
        private StackTraceElement[] _trace;
        private String _timestamp;

        public zflRepresentation(java.io.File file, StackTraceElement[] trace) {
            this._zfl_file = file;
            this._trace = trace;
            this._timestamp = ZipFileLoadStrategyImpl.getTimeStamp();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("  Time Stamp: [ ");
            sb.append(this._timestamp);
            sb.append(" ]\n");
            sb.append("  File Name:  [ ");
            sb.append(this._zfl_file.getName());
            sb.append(" ]\n");
            sb.append("  File:       [ ");
            sb.append(this._zfl_file);
            sb.append(" ]\n");
            sb.append("  Stack Trace of zipfile creation: \n");
            for (int i = 0; i < this._trace.length; ++i) {
                sb.append("      ");
                sb.append(this._trace[i]);
                sb.append("\n");
            }
            return sb.toString();
        }

        public boolean matches(String s) {
            return s.equals(this._zfl_file.toString());
        }
    }
}

