/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmpDirUtil {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = TmpDirUtil.class.getName();
    public static final String JAVA_TMPDIR_PROPERTY_NAME = "java.io.tmpdir";

    public static String getSystemTempDirName() {
        String methodName = "getSystemTempDirName";
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String tmpDir = System.getProperty(TmpDirUtil.JAVA_TMPDIR_PROPERTY_NAME);
                    logger.logp(Level.FINER, className, "getSystemTempDirName", "System temporary directory [ {0} ]", tmpDir);
                    return tmpDir;
                }
            });
        }
        catch (SecurityException securityException) {
            logger.logp(Level.FINER, className, "getSystemTempDirName", "RETURN null - system temp directory name could not be retrieved");
            return null;
        }
    }

    public static List<File> mkdirs(String targetPath) throws IOException {
        return TmpDirUtil.mkdirs(new File(targetPath));
    }

    public static List<File> mkdirs(File targetFile) throws IOException {
        String methodName = "mkdirs";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", targetFile);
        ArrayList<File> created = new ArrayList<File>();
        File failedCreate = TmpDirUtil.makeParents(targetFile, created);
        if (failedCreate == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", created);
            return created;
        }
        logger.logp(Level.FINER, className, methodName, "Create failure on [ {0} ]", failedCreate);
        File failedDelete = TmpDirUtil.remove(created);
        String message = failedDelete == null ? "Failure attempting to create [ " + targetFile + " ]\n" + "Failed to create directory [ " + failedCreate + " ]" : "Multiple failures attempting to create [ " + targetFile + " ]\n" + "Failed to create [ " + failedCreate + " ]\n" + "Failed to delete [ " + failedDelete + " ]\n" + "Create sequence [ " + created + " ]";
        IOException e = new IOException(message);
        logger.throwing(className, methodName, e);
        throw e;
    }

    public static void rmdirs(String targetPath, List<File> created) throws IOException {
        File failedDelete;
        String methodName = "rmdirs";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ] [ {1} ]", new Object[]{targetPath, created});
        }
        if ((failedDelete = TmpDirUtil.remove(created)) == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN");
            return;
        }
        String message = "Failure attempting to delete temporary directories for [ " + targetPath + " ]\n" + "Failed to delete [ " + failedDelete.getPath() + " ]\n" + "Delete sequence [ " + created + " ]";
        IOException e = new IOException(message);
        logger.throwing(className, methodName, e);
        throw e;
    }

    public static File remove(List<File> created) {
        String methodName = "remove";
        File failedDelete = null;
        int last = created.size();
        while (failedDelete == null && last > 0) {
            File nextFile;
            if (!(nextFile = created.get(--last)).delete()) {
                logger.logp(Level.FINER, className, methodName, "Failed to delete [ {0} ]", nextFile);
                failedDelete = nextFile;
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Deleted [ {0} ]", nextFile);
        }
        return failedDelete;
    }

    public static File makeParents(File target, List<File> created) {
        String methodName = "makeParent";
        if (target == null) {
            logger.logp(Level.FINER, className, methodName, "ENTER / RETURN [ null ] - null target");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", target);
        if (target.exists()) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - Target already exists", target);
            return null;
        }
        File failedParent = TmpDirUtil.makeParents(target.getParentFile(), created);
        if (failedParent != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] - Failed on parent", failedParent);
            return failedParent;
        }
        if (!target.mkdir()) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] - Failed to create target", target);
            return target;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - Successfully created target [ {0} ]", target);
        created.add(target);
        return null;
    }
}

