/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TmpDirUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class TempZipFile {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = TempZipFile.class.getName();
    protected String tempDirName;
    protected File tempDir;
    protected List<File> createdDirs;
    protected String tempFileName;
    protected File tempFile;
    protected ZipFile zipFile;

    public abstract String getBaseName();

    public abstract InputStream getBaseInputStream() throws IOException;

    public abstract String getLogDescription();

    public ZipFile trigger() throws IOException {
        String methodName = "trigger";
        ZipFile useZipFile = this.getZipFile();
        if (useZipFile == null) {
            try {
                this.setTempFile();
                useZipFile = this.setZipFile();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Could not create temporary file for [ {0} ]", this.getLogDescription());
                logger.throwing(className, methodName, e);
                this.clearZipFile();
                this.clearTempFile();
                throw e;
            }
        }
        return useZipFile;
    }

    protected void clearTempFile() {
        String methodName = "clearTempFile";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        File useTempFile = this.tempFile;
        List<File> useCreatedDirs = this.createdDirs;
        File useTempDir = this.tempDir;
        this.tempFile = null;
        this.tempFileName = null;
        this.createdDirs = null;
        this.tempDir = null;
        this.tempDirName = null;
        if (useTempFile != null) {
            if (!useTempFile.delete()) {
                logger.logp(Level.WARNING, className, methodName, "Failed to delete temporary file [ {0} ]", useTempFile);
            } else {
                logger.logp(Level.FINER, className, methodName, "Deleted temporary file [ {0} ]", useTempFile);
            }
        }
        if (useTempDir != null && useCreatedDirs != null) {
            File failedDelete = TmpDirUtil.remove(useCreatedDirs);
            if (failedDelete != null) {
                logger.logp(Level.WARNING, className, methodName, "Failed to delete temporary directory [ {0} ] while deleting [ {1} ] for temporary file [ {2} ]", new Object[]{failedDelete, useCreatedDirs, useTempFile});
            } else {
                logger.logp(Level.FINER, className, methodName, "Deleted temporary directories [ {0} ] for temporary file [ {1} ]", new Object[]{useCreatedDirs, useTempFile});
            }
        }
        logger.log(Level.FINER, className, "RETURN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTempFile() throws IOException {
        String methodName = "setTempFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.getLogDescription());
        if (this.tempFile != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN - Already set");
            return;
        }
        String useName = this.getBaseName();
        this.tempDir = ArchiveUtil.getTempDirectory();
        if (this.tempDir == null) {
            this.tempDirName = TmpDirUtil.getSystemTempDirName();
            this.tempDir = new File(this.tempDirName);
        } else {
            this.tempDirName = this.tempDir.getAbsolutePath();
        }
        logger.logp(Level.FINER, className, methodName, "Temporary Directory [ {0} ]", this.tempDirName);
        this.createdDirs = TmpDirUtil.mkdirs(this.tempDir);
        logger.logp(Level.FINER, className, methodName, "Created [ {0} ]", this.createdDirs);
        try {
            this.tempFile = ArchiveUtil.createTempFile(useName);
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, className, methodName, "Could not create temporary file in directory [ {0} ]", this.tempDirName);
            logger.throwing(className, methodName, e);
            throw e;
        }
        logger.logp(Level.FINER, className, methodName, "Set temp file name [ {0} ]", this.tempFile);
        InputStream inputStream = this.getBaseInputStream();
        try {
            FileOutputStream outputStream = new FileOutputStream(this.tempFile, false);
            try {
                ArchiveUtil.transfer(useName, inputStream, this.tempFileName, outputStream);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.logp(Level.WARNING, className, methodName, "Could not close output stream for temporary file [ {0} ]", this.tempFile);
                    logger.throwing(className, methodName, e);
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Could not close input stream for [ {0} ] for temporary file [ {1} ]", new Object[]{useName, this.tempFile});
                logger.throwing(className, methodName, e);
                throw e;
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, className, methodName, "Could not close input stream for [ {0} ] for temporary file [ {1} ]", new Object[]{useName, this.tempFile});
            logger.throwing(className, methodName, e);
            throw e;
        }
        logger.logp(Level.FINER, className, methodName, "Wrote temporary file contents");
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void clearZipFile() {
        String methodName = "clearZipFile";
        if (this.zipFile == null) {
            return;
        }
        ZipFile useZipFile = this.zipFile;
        this.zipFile = null;
        try {
            useZipFile.close();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, className, methodName, "Failed to close temporary ZIP file [ {0} ]", this.zipFile);
            logger.throwing(className, methodName, e);
        }
    }

    protected ZipFile setZipFile() throws ZipException, IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.tempFile);
        }
        return this.zipFile;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    public void close() {
        this.clearZipFile();
        this.clearTempFile();
    }

    public void finalize() {
        this.close();
    }
}

