/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ArchiveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;

public abstract class SaveStrategyImpl
extends ArchiveStrategyImpl
implements SaveStrategy {
    public static final String className = SaveStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    protected SaveFilter filter;
    protected String resourcesPath;

    public SaveStrategyImpl() {
        logger.logp(Level.FINER, className, "SaveStrategyImpl()", "ENTER");
    }

    public void close() throws IOException {
    }

    public void finish() throws IOException {
    }

    public boolean isDirectory() {
        return false;
    }

    public SaveFilter getFilter() {
        if (this.filter == null) {
            this.filter = new SaveFilterImpl();
        }
        return this.filter;
    }

    public void setFilter(SaveFilter newFilter) {
        this.filter = newFilter;
    }

    protected boolean shouldSave(String uri) {
        String methodName = "shouldSave(String)";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] Archive [ {1} ]", new Object[]{uri, this.getArchive().getURI()});
        boolean result = this.getFilter().shouldSave(uri, this.getArchive());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    protected boolean shouldSave(File aFile) {
        ModuleFile m;
        String methodName = "shouldSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY File [ {0} ]", aFile.getURI());
        if (this.isLoadedResourceOrManifest(aFile)) {
            Resource res = this.archive.getLoadStrategy().getExistingMofResource(aFile.getURI());
            if (res == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN [ false ] -- no resource");
                return false;
            }
            boolean result = !this.shouldSave(res);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] (resource case)", new Boolean(result));
            return result;
        }
        Archive archive = this.getArchive();
        if (archive.isModuleFile() && (m = (ModuleFile)archive).getExportStrategy() != null && m.getExportStrategy().hasSaved(aFile.getURI())) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ false ] -- already exported");
            return false;
        }
        boolean result = this.shouldSave(aFile.getURI());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] (binaries case)", new Boolean(result));
        return result;
    }

    protected boolean isResource(File aFile) {
        if (this.isLoadedResourceOrManifest(aFile)) {
            Resource res = this.archive.getLoadStrategy().getExistingMofResource(aFile.getURI());
            return res != null;
        }
        return false;
    }

    protected boolean isLoadedResourceOrManifest(File aFile) {
        return this.getArchive().isMofResourceLoaded(aFile.getURI()) || aFile.getURI().equals("META-INF/MANIFEST.MF");
    }

    protected boolean shouldSave(Resource res) {
        String methodName = "shouldSave(Resource)";
        if (!res.isModified() && this.getArchive().getOptions().saveOnlyDirtyMofResources()) {
            logger.logp(Level.FINER, className, methodName, "ENTRY / RETURN [ false ] disabled clean resource save");
            return false;
        }
        boolean result = this.shouldSave(res.getURI().toString());
        logger.logp(Level.FINER, className, methodName, "ENTRY / RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    public void save() throws SaveFailureException {
        String methodName = "save()";
        logger.logp(Level.FINER, className, methodName, "ENTRY: Save on archive with URI [ {0} ]", this.getArchive().getURI());
        this.setResourcesPath();
        this.saveManifest();
        this.saveMofResources();
        this.saveFiles();
        this.archive.closeArchiveZipFile();
        logger.logp(Level.FINER, className, methodName, "RETURN: Save on archive with URI [ {0} ]", this.getArchive().getURI());
    }

    protected String getResourcesPath() {
        return this.resourcesPath;
    }

    protected void setResourcesPath() {
        this.resourcesPath = this.calculateResourcesPath();
    }

    protected String calculateResourcesPath() {
        String useResourcesPath;
        String binariesPath;
        String methodName = "setDistinctResources";
        Archive useArchive = this.getArchive();
        String useArchiveURI = useArchive.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ]", useArchiveURI);
        try {
            binariesPath = useArchive.getBinariesPath();
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to determine binaries path for [ {0} ]", useArchiveURI);
            if (logger.isLoggable(Level.FINEST)) {
                logger.throwing(className, methodName, e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] No binaries path");
            return null;
        }
        try {
            useResourcesPath = useArchive.getResourcesPath();
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to determine resources path for [ {0} ]", useArchiveURI);
            if (logger.isLoggable(Level.FINEST)) {
                logger.throwing(className, methodName, e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] No resources path");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "Binaries Path [ {0} ]", binariesPath);
        logger.logp(Level.FINER, className, methodName, "Resources Path [ {0} ]", useResourcesPath);
        if (binariesPath == null || useResourcesPath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] One of the paths is null");
            return null;
        }
        String result = binariesPath.equals(useResourcesPath) ? null : useResourcesPath;
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", result);
        return result;
    }

    protected InputStream getResourceInputStream(File aFile) throws IOException {
        String methodName = "getResourceInputStream";
        String fullPath = this.resourcesPath + java.io.File.separator + aFile.getURI();
        logger.logp(Level.FINER, className, methodName, "Opening resource based stream [ {0} ]", fullPath);
        try {
            return new FileInputStream(fullPath);
        }
        catch (IOException e) {
            logger.throwing(className, methodName, e);
            throw e;
        }
    }

    protected void saveManifest() throws SaveFailureException {
        if (!this.shouldSave("META-INF/MANIFEST.MF")) {
            return;
        }
        ArchiveManifest mf = this.getArchive().getManifest();
        if (mf.getManifestVersion() == null || mf.getManifestVersion().equals("")) {
            mf.setManifestVersion("1.0");
        }
        this.save(mf);
    }

    protected void saveMofResources() throws SaveFailureException {
        String methodName = "saveMofResources";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        ArrayList<Resource> xmiResources = new ArrayList<Resource>();
        ArrayList<Resource> xmlResources = new ArrayList<Resource>();
        for (Resource res : this.getArchive().getLoadedMofResources()) {
            if (!(ArchiveUtil.isJavaResource(res) || ArchiveUtil.isRegisteredURIMapping(res) || ArchiveUtil.isPlatformMetaResource(res))) {
                logger.logp(Level.FINER, className, methodName, "Resource [ {0} ] was selected for save", res);
                if (res instanceof CompatibilityXMIResource) {
                    ((CompatibilityXMIResource)res).setFormat(1);
                }
                if (res instanceof TranslatorResource) {
                    xmlResources.add(res);
                    continue;
                }
                xmiResources.add(res);
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Resource [ {0} ] was not selected for save", res);
        }
        this.basicSaveMofResources(xmiResources);
        this.basicSaveMofResources(xmlResources);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void basicSaveMofResources(List resources) throws SaveFailureException {
        int numResources = resources.size();
        for (int resourceNo = 0; resourceNo < numResources; ++resourceNo) {
            Resource res = (Resource)resources.get(resourceNo);
            this.saveMofResource(res);
        }
    }

    public void saveMofResource(Resource aResource) throws SaveFailureException {
        String methodName = "saveMofResource";
        logger.logp(Level.FINER, className, methodName, "ENTRY: Resource [ {0} ]", aResource.getURI());
        if (!this.shouldSave(aResource)) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Resource is not to be saved");
            return;
        }
        this.setEncoding(aResource);
        try {
            boolean wasModified = aResource.isModified();
            OutputStream os = this.getOutputStreamForResource(aResource);
            this.saveMofResource(aResource, os);
            aResource.setModified(wasModified);
        }
        catch (Exception e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN: Caught Exception:");
            throw new SaveFailureException(aResource.getURI().toString(), e);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN: Resource was saved");
    }

    protected void setEncoding(Resource aResource) {
        if (aResource instanceof XMLResource) {
            ((XMLResource)aResource).setEncoding(this.archive.getXmlEncoding());
        }
    }

    protected abstract OutputStream getOutputStreamForResource(Resource var1) throws IOException;

    protected void saveMofResource(Resource aResource, OutputStream os) throws IOException {
        aResource.save(os, Collections.EMPTY_MAP);
    }

    protected void saveFiles() throws SaveFailureException {
        String methodName = "saveFiles()";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        try {
            FileIterator iterator = this.getArchive().getFilesForSave();
            while (iterator.hasNext()) {
                File aFile = iterator.next();
                if (!this.shouldSave(aFile)) continue;
                this.save(aFile, iterator);
            }
        }
        catch (IOException iox) {
            logger.throwing(className, methodName, iox);
            logger.logp(Level.FINER, className, methodName, "RETURN: Caught IOException:");
            throw new SaveFailureException("Error_occurred_iterating_f_EXC_", iox);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void save(File aFile, FileIterator iterator) throws SaveFailureException {
        String methodName = "save(File, FileIterator)";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", aFile.getURI());
        if (aFile.isArchive() && this.shouldIterateOver((Archive)aFile)) {
            logger.logp(Level.FINER, className, methodName, "Iterating across nested contents");
            this.save((Archive)aFile);
        } else {
            InputStream in = null;
            if (!aFile.isDirectoryEntry()) {
                logger.logp(Level.FINER, className, methodName, "Saving as file");
                try {
                    if (this.getResourcesPath() != null && this.isResource(aFile)) {
                        in = this.getResourceInputStream(aFile);
                    }
                    in = iterator.getInputStream(aFile);
                }
                catch (IOException ex) {
                    logger.throwing(className, methodName, ex);
                    logger.logp(Level.FINER, className, methodName, "RETURN: Caught IOException attempting open of input stream:");
                    throw new SaveFailureException(aFile.getURI(), ex);
                }
            } else {
                logger.logp(Level.FINER, className, methodName, "Saving as directory");
            }
            this.save(aFile, in);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN: [ {0} ]", aFile);
    }

    protected boolean shouldIterateOver(Archive anArchive) {
        return anArchive.getLoadStrategy().requiresIterationOnSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Archive anArchive) throws SaveFailureException {
        String methodName = "save(Archive)";
        logger.logp(Level.FINER, className, methodName, "ENTRY on archive [ {0} ]", anArchive.getURI());
        ArchiveOptions useOptions = anArchive.getOptions();
        ArchiveOptions useParentOptions = this.getArchive().getOptions();
        SaveStrategy strat = null;
        try {
            strat = this.createNestedSaveStrategy(anArchive);
            if (useParentOptions != null && useParentOptions.getChildrenUseParentFilters()) {
                SaveFilter useFilter = this.getFilter();
                logger.logp(Level.FINER, className, methodName, "Passing save filter [ {0} ]", useFilter);
                strat.setFilter(useFilter);
            }
        }
        catch (IOException iox) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Caught IOException attempting to create nested save strategy");
            iox.printStackTrace(System.out);
            throw new SaveFailureException(anArchive.getURI(), iox);
        }
        logger.logp(Level.FINER, className, methodName, "Created nested save strategy [ {0} ]", strat);
        boolean priorSaveIncrementally = useOptions.getSaveIncrementally();
        boolean parentSaveIncrementally = useParentOptions.getSaveIncrementally();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Prior Save Incrementally [ {0} ]", new Boolean(priorSaveIncrementally));
            logger.logp(Level.FINER, className, methodName, "Parent Save Incrementally [ {0} ]", new Boolean(parentSaveIncrementally));
        }
        useOptions.setSaveIncrementally(parentSaveIncrementally);
        try {
            anArchive.save(strat);
        }
        finally {
            useOptions.setSaveIncrementally(priorSaveIncrementally);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN on archive [ {0} ]", anArchive.getURI());
    }

    protected abstract SaveStrategy createNestedSaveStrategy(Archive var1) throws IOException;

    public abstract void save(File var1, InputStream var2) throws SaveFailureException;
}

