/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NestedJarException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIteratorDirect;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.GatedTempZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedArchiveLoadStrategyImpl
extends LoadStrategyImpl {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = NestedArchiveLoadStrategyImpl.class.getName();
    protected String logDescription;
    protected TempZipFile tempZipFile = new TempZipFile(){

        public InputStream getBaseInputStream() throws IOException {
            return NestedArchiveLoadStrategyImpl.this.getParent().getInputStream(NestedArchiveLoadStrategyImpl.this.getContainer().getURI());
        }

        public String getBaseName() {
            return NestedArchiveLoadStrategyImpl.this.getContainer().getName();
        }

        public String getLogDescription() {
            return NestedArchiveLoadStrategyImpl.this.getLogDescription();
        }
    };
    protected GatedTempZipFile gatedTempZipFile = this.createGatedZipFile();
    protected LoadStrategy parent;
    @Deprecated
    protected Map<String, Integer> entryNamesToPositions;
    public static final String DYNAMIC_EXPANSION_PROPERTY = "com.ibm.config.eclipse.wtp.dynamic.expansion";
    public static final boolean DYNAMIC_EXPANSION_PROPERTY_DEFAULT = true;
    public static boolean dynamicExtractionEnabled = NestedArchiveLoadStrategyImpl.getProperty("com.ibm.config.eclipse.wtp.dynamic.expansion", true);

    public NestedArchiveLoadStrategyImpl(LoadStrategy parentStrategy) {
        String methodName = "NestedArchiveLoadStrategyImpl";
        this.setParent(parentStrategy);
        this.setLogDescription();
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN", this.getLogDescription());
    }

    public String getLogDescription() {
        return this.logDescription;
    }

    protected void setLogDescription() {
        int useContainerHash;
        String useUri;
        String useLogDescription = "NestedArchiveLoadStrategy [ " + this.hashCode() + " ]";
        Container useContainer = this.getContainer();
        if (useContainer != null) {
            useUri = useContainer.getURI();
            useContainerHash = useContainer.hashCode();
        } else {
            useUri = "*** NULL CONTAINER ***";
            useContainerHash = 0;
        }
        this.logDescription = useLogDescription = useLogDescription + " URI [ " + useUri + " ] Container [ " + useContainerHash + " ]";
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.setLogDescription();
    }

    protected GatedTempZipFile createGatedZipFile() {
        if (dynamicExtractionEnabled) {
            return new GatedTempZipFile(this.tempZipFile);
        }
        return new GatedTempZipFile(this.tempZipFile, -1);
    }

    protected TempZipFile getTempZipFile() {
        return this.tempZipFile;
    }

    protected GatedTempZipFile getGatedTempZipFile() {
        return this.gatedTempZipFile;
    }

    @Override
    public void close() {
        this.getGatedTempZipFile().close();
        super.close();
    }

    protected ZipFile zipFileCheck() {
        return this.getGatedTempZipFile().zipFileCheck();
    }

    protected ZipFile getZipFile() {
        return this.getGatedTempZipFile().getZipFile();
    }

    protected boolean containsUsingZipFile(String entryName) {
        return this.getZipFile().getEntry(entryName) != null;
    }

    protected InputStream getInputStreamFromZipFile(String entryName) throws IOException, FileNotFoundException {
        ZipFile useZipFile = this.getZipFile();
        ZipEntry zipEntry = useZipFile.getEntry(entryName);
        if (zipEntry == null) {
            throw new FileNotFoundException(entryName);
        }
        return new BufferedInputStream(useZipFile.getInputStream(zipEntry));
    }

    @Override
    protected boolean primContains(String entryName) {
        if (this.usingIndex()) {
            return this.containsUsingIndex(entryName);
        }
        if (this.zipFileCheck() != null) {
            return this.containsUsingZipFile(entryName);
        }
        return this.containsSequentially(entryName);
    }

    @Override
    public InputStream getInputStream(String entryName) throws IOException, FileNotFoundException {
        if (this.usingIndex()) {
            return this.getInputStreamUsingIndex(entryName);
        }
        if (this.zipFileCheck() != null) {
            return this.getInputStreamFromZipFile(entryName);
        }
        return this.getInputStreamSequentially(entryName);
    }

    public void setParent(LoadStrategy parent) {
        this.parent = parent;
    }

    public LoadStrategy getParent() {
        return this.parent;
    }

    protected ZipInputStream getZipInputStream() throws IOException, FileNotFoundException {
        String containerUri = this.getContainer().getURI();
        InputStream inputStream = this.getParent().getInputStream(containerUri);
        return new ZipInputStream(inputStream);
    }

    protected void throwNestedJarException(IOException e) throws NestedJarException {
        String message = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()});
        throw new NestedJarException(message, e);
    }

    protected ZipInputStream safeGetZipInputStream() throws NestedJarException {
        try {
            return this.getZipInputStream();
        }
        catch (IOException e) {
            this.throwNestedJarException(e);
            return null;
        }
    }

    protected ZipEntry safeGetNextEntry(ZipInputStream zipInputStream) throws NestedJarException {
        try {
            return zipInputStream.getNextEntry();
        }
        catch (IOException e) {
            this.throwNestedJarException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> getFiles() throws NestedJarException {
        String methodName = "getFiles";
        ArrayList<File> list = new ArrayList<File>();
        ZipInputStream zipInputStream = this.safeGetZipInputStream();
        try {
            ZipEntry entry;
            while ((entry = this.safeGetNextEntry(zipInputStream)) != null) {
                if (entry.isDirectory()) continue;
                File aFile = this.createFile(entry.getName());
                aFile.setSize(entry.getSize());
                aFile.setLastModified(entry.getTime());
                list.add(aFile);
            }
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed to close input stream for [ {0} ]", this.getLogDescription());
                logger.throwing(className, methodName, e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ZipInputStream getZipInputStreamSkippedTo(String entryName) throws IOException, FileNotFoundException {
        ZipEntry selectedEntry;
        ZipInputStream zipInputStream;
        block7: {
            String methodName = "getZipInputStreamSkippedTo";
            zipInputStream = this.getZipInputStream();
            selectedEntry = null;
            try {
                ZipEntry nextEntry;
                while (selectedEntry == null && (nextEntry = zipInputStream.getNextEntry()) != null) {
                    if (!entryName.equals(nextEntry.getName())) continue;
                    selectedEntry = nextEntry;
                }
                if (selectedEntry != null) break block7;
            }
            catch (Throwable throwable) {
                if (selectedEntry != null) throw throwable;
                try {
                    zipInputStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    logger.logp(Level.WARNING, className, methodName, "Failed to close zip input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                    logger.throwing(className, methodName, e);
                }
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed to close zip input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                logger.throwing(className, methodName, e);
            }
        }
        if (selectedEntry != null) return zipInputStream;
        throw new FileNotFoundException(entryName);
    }

    protected InputStream getInputStreamSequentially(String entryName) throws IOException, FileNotFoundException {
        return new BufferedInputStream(this.getZipInputStreamSkippedTo(entryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean containsSequentially(String entryName) {
        ZipEntry selectedEntry;
        block13: {
            ZipEntry nextEntry;
            ZipInputStream zipInputStream;
            String methodName = "containsSequentially";
            try {
                zipInputStream = this.getZipInputStream();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed obtain zip input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                logger.throwing(className, methodName, e);
                return false;
            }
            selectedEntry = null;
            while (selectedEntry == null && (nextEntry = zipInputStream.getNextEntry()) != null) {
                if (!entryName.equals(nextEntry.getName())) continue;
                selectedEntry = nextEntry;
            }
            try {
                zipInputStream.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed to close input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                logger.throwing(className, methodName, e);
            }
            break block13;
            catch (IOException e) {
                try {
                    logger.logp(Level.WARNING, className, methodName, "Failed scan entries for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                    logger.throwing(className, methodName, e);
                }
                catch (Throwable throwable) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException e2) {
                        logger.logp(Level.WARNING, className, methodName, "Failed to close input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                        logger.throwing(className, methodName, e2);
                    }
                    throw throwable;
                }
                try {
                    zipInputStream.close();
                }
                catch (IOException e3) {
                    logger.logp(Level.WARNING, className, methodName, "Failed to close input stream for [ {0} ] on [ {1} ]", new Object[]{entryName, this.getLogDescription()});
                    logger.throwing(className, methodName, e3);
                }
            }
        }
        return selectedEntry != null;
    }

    @Override
    public FileIterator getFileIterator() throws IOException {
        FileIterator result;
        String methodName = "getFileIterator";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY [ {0} ]", this.getContainer().getURI());
        if (((Archive)this.getContainer()).getOptions().isReadOnly()) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Selecting direct iterator");
            result = new NestedArchiveIteratorDirect(this.getContainer().getFiles(), this.getZipInputStream());
        } else {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Selecting normal file iterator");
            result = super.getFileIterator();
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ {0} ]", result);
        return result;
    }

    @Override
    public FileIterator getFileIteratorDirect() throws IOException {
        return this.getFileIterator();
    }

    public void closeFileIteratorDirect(NestedArchiveIteratorDirect iterator) throws IOException {
        if (!(this.parent instanceof ZipFileLoadStrategyImpl)) {
            iterator.closeInputStream();
        }
    }

    @Deprecated
    public boolean usingIndex() {
        return false;
    }

    @Deprecated
    public void setUrisToPositions(Map<String, Integer> entryNamesToPositions) {
        this.entryNamesToPositions = entryNamesToPositions;
    }

    @Deprecated
    public Map<String, Integer> getUrisToPositions() {
        if (this.entryNamesToPositions == null && this.usingIndex()) {
            this.buildIndex();
        }
        return this.entryNamesToPositions;
    }

    @Deprecated
    protected boolean containsUsingIndex(String entryName) {
        return this.getUrisToPositions().containsKey(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void buildIndex() throws NestedJarException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ZipInputStream zipInputStream = this.safeGetZipInputStream();
        try {
            ZipEntry entry;
            int offset = 1;
            while ((entry = this.safeGetNextEntry(zipInputStream)) != null) {
                map.put(entry.getName(), new Integer(offset));
                ++offset;
            }
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.setUrisToPositions(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected InputStream getInputStreamUsingIndex(String entryName) throws IOException, FileNotFoundException {
        Integer position = this.getUrisToPositions().get(entryName);
        if (position == null) {
            throw new FileNotFoundException(entryName);
        }
        int targetPosition = position;
        ZipInputStream zipInputStream = this.getZipInputStream();
        BufferedInputStream resultStream = null;
        try {
            for (int currentPosition = 0; currentPosition < targetPosition; ++currentPosition) {
                zipInputStream.getNextEntry();
            }
            resultStream = new BufferedInputStream(zipInputStream);
        }
        finally {
            if (resultStream == null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return resultStream;
    }

    public static boolean getProperty(final String propertyName, final boolean propertyDefaultValue) {
        Boolean propertyValue;
        String methodName = "getProperty";
        try {
            propertyValue = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String propertyValue = System.getProperty(propertyName, null);
                    if (propertyValue == null) {
                        logger.logp(Level.FINER, CLASS_NAME, "getProperty", "Null Property [ {0} ]; using default", new Object[]{propertyName});
                        return new Boolean(propertyDefaultValue);
                    }
                    logger.logp(Level.FINER, CLASS_NAME, "getProperty", "Property [ {0} ] Value [ {1} ]", new Object[]{propertyName, propertyValue});
                    return new Boolean(propertyValue);
                }
            });
        }
        catch (SecurityException securityException) {
            logger.logp(Level.FINER, CLASS_NAME, "getProperty", "Failed to retrieve system property [ {0} ]; using default", propertyName);
            logger.throwing(CLASS_NAME, "getProperty", securityException);
            propertyValue = new Boolean(propertyDefaultValue);
        }
        logger.logp(Level.FINER, CLASS_NAME, "getProperty", "Property [ {0} ] Value [ {1} ]", new Object[]{propertyName, propertyValue});
        return propertyValue;
    }
}

