/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFile;

public class GatedTempZipFile {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = GatedTempZipFile.class.getName();
    protected TempZipFile tempZipFile;
    public static final int DEFAULT_EXPANSION_THRESHHOLD = 3;
    public static final int NO_EXPANSION = -1;
    protected int expansionThreshHold;
    protected int accessCount;
    protected boolean accessFailure;

    public GatedTempZipFile(TempZipFile tempZipFile, int expansionThreshHold) {
        this.tempZipFile = tempZipFile;
        this.expansionThreshHold = expansionThreshHold;
    }

    public GatedTempZipFile(TempZipFile tempZipFile) {
        this.tempZipFile = tempZipFile;
        this.expansionThreshHold = 3;
    }

    public TempZipFile getTempZipFile() {
        return this.tempZipFile;
    }

    protected void setExpansionThreshHold(int expansionThreshHold) {
        this.expansionThreshHold = expansionThreshHold;
    }

    protected int getExpansionThreshHold() {
        return this.expansionThreshHold;
    }

    protected void resetAccessCount() {
        String methodName = "resetAccessCount";
        logger.logp(Level.FINER, className, methodName, "Count [ {0} ]", new Integer(this.accessCount));
        logger.logp(Level.FINER, className, methodName, "Failure [ {0} ]", new Boolean(this.accessFailure));
        this.accessCount = 0;
        this.accessFailure = false;
    }

    protected int incrementAccessCount() {
        if (this.accessCount < Integer.MAX_VALUE) {
            ++this.accessCount;
        }
        return this.accessCount;
    }

    protected int getAccessCount() {
        return this.accessCount;
    }

    protected boolean getAccessFailure() {
        return this.accessFailure;
    }

    protected void setAccessFailure() {
        this.accessFailure = true;
    }

    public ZipFile zipFileCheck() {
        String methodName = "zipFileCheck";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        int updatedAccessCount = this.incrementAccessCount();
        logger.logp(Level.FINER, className, methodName, "Updated access count [ {0} ]", new Integer(updatedAccessCount));
        int useThreshHold = this.getExpansionThreshHold();
        if (useThreshHold == -1) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - expansion is disabled");
            return null;
        }
        if (updatedAccessCount < useThreshHold) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - count less then threshhold [ {0} ]", new Integer(useThreshHold));
            return null;
        }
        if (this.getAccessFailure()) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - failure on prior expansion attempt");
            return null;
        }
        TempZipFile useTempZipFile = this.getTempZipFile();
        try {
            ZipFile zipFile = useTempZipFile.trigger();
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", zipFile);
            return zipFile;
        }
        catch (IOException e) {
            this.setAccessFailure();
            logger.logp(Level.WARNING, className, methodName, "Failure to generate temp zip file");
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] - failed trigger");
            return null;
        }
    }

    public ZipFile getZipFile() {
        return this.getTempZipFile().getZipFile();
    }

    public void close() {
        this.getTempZipFile().close();
        this.resetAccessCount();
    }

    public void finalize() {
        this.close();
    }
}

