/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;

public class Ear12ImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return Ear12ImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        Application appl = (Application)this.primLoadDeploymentDescriptor();
        this.versionCheck((EObject)appl);
        EARFile earFile = this.getEARFile();
        earFile.setDeploymentDescriptor(appl);
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        protected static final String className = Discriminator.class.getName();

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createEARFile();
        }

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.EAR12;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached EAR12 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = anArchive.containsFile("META-INF/application.xml");
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN EAR12 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new Ear12ImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.EAR_File, "META-INF/application.xml");
        }
    }
}

