/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;

public abstract class DirectoryLoadStrategyImpl
extends LoadStrategyImpl
implements DirectoryArchiveLoadStrategy {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = DirectoryLoadStrategyImpl.class.getName();
    protected static final boolean PERMIT_NONRELATIVE_PATHS = true;
    protected static final boolean DO_NOT_PERMIT_NONRELATIVE_PATHS = false;
    protected ZipFile binariesZipFile;
    protected String binariesZipFilePath;
    protected String tempArchiveBinariesPath;
    protected java.io.File tempArchiveBinariesFile;
    protected boolean isSetContainerData;
    protected String archiveUri;
    protected String archiveResourcesPath;
    protected String archiveBinariesPath;
    protected boolean archiveBinariesIsDistinct;
    protected java.io.File archiveBinariesFile;
    protected boolean archiveBinariesExists;
    protected boolean archiveBinariesIsDirectory;
    protected String directoryUri;
    protected String directoryUriAsZipString;
    protected static char SEPARATOR_CHAR = java.io.File.separatorChar;
    static boolean IS_AIX = "AIX".equals(System.getProperty("os.name"));

    public ZipFile getBinariesZipFile() {
        return this.binariesZipFile;
    }

    public String getBinariesZipFilePath() {
        return this.binariesZipFilePath;
    }

    protected ZipFile forceBinariesZipFile() throws IOException {
        String methodName = "forceBinariesZipFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.binariesZipFile == null) {
            String useBinariesPath = this.getResolvedBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Opening ZIP file on location [ {0} ]", useBinariesPath);
            this.binariesZipFile = new ZipFile(this.getResolvedBinariesFile());
            this.binariesZipFilePath = useBinariesPath;
        } else {
            logger.logp(Level.FINER, className, methodName, "The binaries zip file is already open.");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this.binariesZipFile);
        return this.binariesZipFile;
    }

    protected void closeBinariesZipFile() {
        String methodName = "closeBinariesZipFile";
        if (this.binariesZipFile != null) {
            ZipFile useBinaryZipFile = this.binariesZipFile;
            this.binariesZipFile = null;
            String useBinariesZipFilePath = this.binariesZipFilePath;
            this.binariesZipFilePath = null;
            logger.logp(Level.FINER, className, methodName, "ENTRY Closing binaries zip [ {0} ] ...", useBinariesZipFilePath);
            try {
                useBinaryZipFile.close();
                logger.logp(Level.FINER, className, methodName, "RETURN Closed binaries Element [ {0} ]", useBinariesZipFilePath);
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, className, methodName, "RETURN Ignoring close exception [ {0} ].", useBinariesZipFilePath);
                logger.throwing(className, methodName, e);
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Skipping; the binaries zip is not open.");
        }
    }

    public boolean getHaveExtractedBinaries() {
        return this.tempArchiveBinariesPath != null;
    }

    protected String getResolvedBinariesPath() {
        return this.tempArchiveBinariesPath != null ? this.tempArchiveBinariesPath : this.archiveBinariesPath;
    }

    protected java.io.File getResolvedBinariesFile() {
        return this.tempArchiveBinariesFile != null ? this.tempArchiveBinariesFile : this.archiveBinariesFile;
    }

    protected void resolveBinariesFile() throws IOException {
        String methodName = "resolveBinariesFile";
        logger.logp(Level.FINER, className, methodName, "ENTER URI [ {0} ] Archive Binaries [ {1} ]", new Object[]{this.getArchiveURI(), this.getArchiveBinariesPath()});
        if (this.getArchiveBinariesExists()) {
            logger.logp(Level.FINER, className, methodName, "RETURN Set binaries location exists");
        } else if (this.getHaveExtractedBinaries()) {
            logger.logp(Level.FINER, className, methodName, "RETURN Temporary binaries location already created");
        } else {
            logger.logp(Level.FINER, className, methodName, "Binaries location does not exist");
            this.createTempBinariesFile();
            logger.logp(Level.FINER, className, methodName, "RETURN Created temporary binaries file");
        }
    }

    protected void createTempBinariesFile() throws IOException {
        String methodName = "createTempBinariesFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        Container currentContainer = this.getContainer();
        Container parentContainer = currentContainer.getContainer();
        if (parentContainer == null) {
            if (currentContainer.isArchive()) {
                logger.logp(Level.FINER, className, methodName, "No set parent; trying options [ {0} ]", this.archiveBinariesPath);
                Archive childArchive = (Archive)currentContainer;
                parentContainer = childArchive.getOptions().getParentEarFile();
            } else {
                logger.logp(Level.FINER, className, methodName, "No set parent, and the bound container is not yet an archive [ {0} ]", this.archiveBinariesPath);
            }
        }
        if (parentContainer == null) {
            logger.logp(Level.FINER, className, methodName, "No parent for binaries [ {0} ]", this.archiveBinariesPath);
            throw new FileNotFoundException("Unable to set parent for binaries [ " + this.archiveBinariesPath + " ]");
        }
        String useArchiveURI = this.getArchiveURI();
        InputStream archiveInputStream = parentContainer.getInputStream(useArchiveURI);
        this.tempArchiveBinariesFile = ArchiveUtil.writeFileToTemp(useArchiveURI, archiveInputStream, useArchiveURI);
        this.tempArchiveBinariesPath = this.tempArchiveBinariesFile.getCanonicalPath();
        logger.logp(Level.FINER, className, methodName, "Temp archive binaries path [ {0} ]", this.tempArchiveBinariesPath);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void deleteTempBinariesFile() {
        String methodName = "deleteTempBinariesFile";
        if (this.tempArchiveBinariesFile != null) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Deleting temp binaries file [ {0} ] ...", this.tempArchiveBinariesPath);
            java.io.File useTempFile = this.tempArchiveBinariesFile;
            String useTempFilePath = this.tempArchiveBinariesPath;
            this.tempArchiveBinariesFile = null;
            this.tempArchiveBinariesPath = null;
            if (!useTempFile.delete()) {
                logger.logp(Level.INFO, className, methodName, "RETURN Strange: Unable to delete temp binaries file [ {0} ]", useTempFilePath);
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN Deleted temp binaries file [ {0} ]", useTempFilePath);
            }
            DeleteOnExitUtility.fileHasBeenDeleted(useTempFile);
        } else {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Skipping: Temp extraction was not performed");
        }
    }

    protected void ensureContainerData() {
        String methodName = "ensureContainerData";
        Container useContainer = this.getContainer();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "Load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Container [ {0} ]", this.container);
        }
        this.archiveUri = useContainer.getURI();
        if (useContainer.isReadOnlyDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Read-only directory case");
            ReadOnlyDirectory useDirectory = (ReadOnlyDirectory)useContainer;
            try {
                this.archiveResourcesPath = useDirectory.getAbsolutePath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine directory path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveResourcesPath = null;
            }
            if (this.archiveResourcesPath != null) {
                String localizedUri = this.archiveUri;
                if (java.io.File.separatorChar == '\\') {
                    localizedUri = localizedUri.replace('/', '\\');
                }
                if (!this.archiveResourcesPath.endsWith(localizedUri)) {
                    logger.logp(Level.FINER, className, methodName, "Strange: directory [ {0} ] does not show the expected trailing archive URI [ {1} ]", new Object[]{this.archiveResourcesPath, localizedUri});
                } else {
                    if (this.archiveResourcesPath.length() != localizedUri.length()) {
                        this.archiveResourcesPath = this.archiveResourcesPath.substring(0, this.archiveResourcesPath.length() - localizedUri.length());
                    }
                    if (this.archiveResourcesPath.endsWith(java.io.File.separator)) {
                        this.archiveResourcesPath = this.archiveResourcesPath.substring(0, this.archiveResourcesPath.length() - java.io.File.separator.length());
                    }
                    logger.logp(Level.FINER, className, methodName, "Updated archive resources path to [ {0} ]", this.archiveResourcesPath);
                }
            }
            this.archiveBinariesPath = this.archiveResourcesPath;
        } else if (useContainer.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "Archive case");
            Archive useArchive = (Archive)useContainer;
            try {
                this.archiveResourcesPath = useArchive.getResourcesPath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine archive resources path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveResourcesPath = null;
            }
            try {
                this.archiveBinariesPath = useArchive.getBinariesPath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine archive binaries path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveBinariesPath = null;
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Non-archive, non-read-only directory case!  Skipping assignment of resources and binaries paths.");
            this.archiveResourcesPath = null;
            this.archiveBinariesPath = null;
        }
        boolean bl = this.archiveBinariesIsDistinct = this.archiveBinariesPath != null && !this.archiveBinariesPath.equals(this.archiveResourcesPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Archive URI [ {0} ]", this.archiveUri);
            logger.logp(Level.FINER, className, methodName, "Archive Resources Path [ {0} ]", this.archiveResourcesPath);
            logger.logp(Level.FINER, className, methodName, "Archive Binaries Path [ {0} ]", this.archiveBinariesPath);
            logger.logp(Level.FINER, className, methodName, "Archive Binaries Is Distinct [ {0} ]", new Boolean(this.archiveBinariesIsDistinct));
        }
        if (this.archiveBinariesIsDistinct) {
            this.archiveBinariesFile = new java.io.File(this.archiveBinariesPath);
            this.archiveBinariesExists = this.archiveBinariesFile.exists();
            boolean bl2 = this.archiveBinariesIsDirectory = this.archiveBinariesExists && this.archiveBinariesFile.isDirectory();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, methodName, "Archive Binaries Exists [ {0} ]", new Boolean(this.archiveBinariesExists));
                logger.logp(Level.FINER, className, methodName, "Archive Binaries Is Directory [ {0} ]", new Boolean(this.archiveBinariesIsDirectory));
            }
        }
        this.isSetContainerData = true;
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public String getArchiveURI() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveUri;
    }

    public String getArchiveResourcesPath() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveResourcesPath;
    }

    public String getArchiveBinariesPath() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesPath;
    }

    public boolean getArchiveBinariesIsDistinct() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesIsDistinct;
    }

    public java.io.File getArchiveBinariesFile() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesFile;
    }

    public boolean getArchiveBinariesExists() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesExists;
    }

    public boolean getArchiveBinariesIsDirectory() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesIsDirectory;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        java.io.File dir = new java.io.File(this.getDirectoryUri());
        return dir.equals(aSystemFile);
    }

    public String getDirectoryUri() {
        String methodName = "getDirectoryUri";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", this.directoryUri);
        return this.directoryUri;
    }

    public void setDirectoryUri(String newDirectoryUri) {
        String methodName = "setDirectoryUri";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", newDirectoryUri);
        this.directoryUri = newDirectoryUri;
    }

    public String getDirectoryUriAsZipString() {
        return this.directoryUriAsZipString;
    }

    public void setDirectoryUriAsZipString(String newDirectoryUriAsZipString) {
        String methodName = "setDirectoryUriAsZipString";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", newDirectoryUriAsZipString);
        this.directoryUriAsZipString = newDirectoryUriAsZipString;
    }

    public DirectoryLoadStrategyImpl(String aDirectoryUri) {
        String normalized;
        String methodName = "DirectoryLoadStrategyImpl(String)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "This load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Directory URI [ {0} ]", aDirectoryUri);
        }
        this.setDirectoryUri(aDirectoryUri);
        try {
            normalized = new java.io.File(aDirectoryUri).getCanonicalPath();
        }
        catch (IOException iox) {
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException obtaining load strategy canonical path [ {0} ]", iox.getMessage());
            logger.throwing(className, methodName, iox);
            normalized = aDirectoryUri;
        }
        this.setDirectoryUriAsZipString(normalized.replace(java.io.File.separatorChar, '/'));
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setContainer(Container useContainer) {
        String methodName = "setContainer";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "This load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Archive [ {0} ]", this.container);
        }
        super.setContainer(useContainer);
        this.isSetContainerData = false;
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public synchronized void close() {
        String methodName = "close";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "This load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Archive [ {0} ]", this.getContainer());
        }
        this.closeBinariesZipFile();
        this.deleteTempBinariesFile();
        super.close();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected abstract void addDirectory(java.io.File var1, List var2);

    protected void addFile(java.io.File aFile, List aList) {
        this.addFile(aFile, aList, false, null, null);
    }

    protected void addFile(java.io.File aFile, List aList, boolean permitNonRelativePaths, java.io.File directory, String directoryURI) {
        String uri;
        String methodName = "addFile";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY File [ {0} ] Directory [ {1} ] Permit non-relative [ {2} ]", new Object[]{aFile, directory, new Boolean(permitNonRelativePaths)});
        }
        String filename = null;
        if (permitNonRelativePaths) {
            filename = aFile.getName();
            uri = directoryURI + "/" + filename;
        } else {
            uri = this.getURIFrom(aFile);
        }
        logger.logp(Level.FINER, className, methodName, "File path [ {0} ]", uri);
        if (this.collectedLooseArchiveFiles.containsKey(uri)) {
            return;
        }
        File cFile = this.createFile(uri, null, permitNonRelativePaths, directory, filename);
        cFile.setSize(aFile.length());
        cFile.setLastModified(aFile.lastModified());
        aList.add(cFile);
        logger.logp(Level.FINER, className, methodName, "RETURN Added file [ {0} ]", cFile);
    }

    protected void addFiles(java.io.File aDirectory, List aList) {
        this.addFiles(aDirectory, aList, false, null);
    }

    protected void addFiles(java.io.File aDirectory, List aList, boolean permitNonRelativePaths, String libDirUri) {
        String[] fileNames;
        String methodName = "addFiles";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Directory [ {0} ] Non-relative [ {1} ] Lib Dir [ {2} ]", new Object[]{aDirectory, new Boolean(permitNonRelativePaths), libDirUri});
        }
        if ((fileNames = aDirectory.list()) == null) {
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = ArchiveUtil.concatUri(aDirectory.getPath(), fileNames[i], SEPARATOR_CHAR);
            if (fileNames[i] == null || IS_AIX && ".backup".equals(fileNames[i])) {
                logger.logp(Level.FINER, className, methodName, "Skipping AIX .backup file [ {0} ]", fileName);
                continue;
            }
            java.io.File aFile = new java.io.File(fileName);
            if (aFile.isDirectory() && !this.isArchive(this.getURIFrom(aFile))) {
                this.addDirectory(aFile, aList);
                continue;
            }
            this.addFile(aFile, aList, permitNonRelativePaths, aDirectory, libDirUri);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected boolean primContains(String uri) {
        return new java.io.File(this.getFileNameFrom(uri)).exists();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        String methodName = "getAbsolutePath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String path = new java.io.File(this.getDirectoryUri()).getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", path);
        return path;
    }

    protected abstract java.io.File getDirectoryForList();

    protected String getLooseFileName(String uri) {
        LooseArchive useLooseArchive = this.getLooseArchive();
        if (useLooseArchive == null) {
            return null;
        }
        int looseArchiveID = useLooseArchive.eClass().getClassifierID();
        if (looseArchiveID == 0) {
            return this.getURIFromLooseArchivesIfAvailable(((LooseApplication)useLooseArchive).getLooseArchives(), uri);
        }
        if (looseArchiveID == 5) {
            return this.getURIFromLooseArchivesIfAvailable(((LooseWARFile)useLooseArchive).getLooseLibs(), uri);
        }
        return null;
    }

    protected String getResourceFileNameFor(String uri) {
        if (SEPARATOR_CHAR != '/') {
            uri = uri.replace('/', SEPARATOR_CHAR);
        }
        return this.getArchiveResourcesPath() + SEPARATOR_CHAR + uri;
    }

    protected String getFileNameFrom(String uri) {
        String looseFileName = this.getLooseFileName(uri);
        if (looseFileName != null) {
            return looseFileName;
        }
        if (SEPARATOR_CHAR != '/') {
            uri = uri.replace('/', SEPARATOR_CHAR);
        }
        return this.getDirectoryUri() + SEPARATOR_CHAR + uri;
    }

    private String getURIFromLooseArchivesIfAvailable(List looseArchives, String uri) {
        for (LooseArchive looseArchiveElement : looseArchives) {
            if (!uri.equals(looseArchiveElement.getUri())) continue;
            return looseArchiveElement.getBinariesPath();
        }
        return null;
    }

    public List getFiles() {
        String methodName = "getFiles";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.directoryUri);
        ArrayList list = new ArrayList();
        java.io.File directory = this.getDirectoryForList();
        logger.logp(Level.FINER, className, methodName, "Directory [ {0} ]", directory.getAbsolutePath());
        this.addFiles(directory, list);
        logger.logp(Level.FINER, className, methodName, "RETURN list of [ {0} ] files", Integer.toString(list.size()));
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "complete list of returned files:\n";
            Iterator i = list.iterator();
            while (i.hasNext()) {
                msg = msg + i.next() + "\n";
            }
            logger.logp(Level.FINEST, className, methodName, msg);
        }
        return list;
    }

    public List getFiles(String subfolderPath) {
        ArrayList list = new ArrayList();
        java.io.File containerDirectory = this.getDirectoryForList();
        java.io.File subfolder = new java.io.File(containerDirectory, subfolderPath);
        this.addFiles(subfolder, list);
        return list;
    }

    public InputStream getInputStream(String uri) throws IOException {
        String methodName = "getInputStream";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", uri);
        String looseFileName = this.getLooseFileName(uri);
        if (looseFileName != null) {
            logger.logp(Level.FINER, className, methodName, "Located as a loose file [ {0} ]", looseFileName);
            FileInputStream looseInputStream = new FileInputStream(looseFileName);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", looseInputStream);
            return looseInputStream;
        }
        InputStream inputStream = this.basicGetInputStream(uri);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
        return inputStream;
    }

    public InputStream basicGetInputStream(String uri) throws IOException {
        boolean resourcesFileIsDirectory;
        String methodName = "basicGetInputStream";
        String resourcesFileName = this.getResourceFileNameFor(uri);
        java.io.File resourcesFile = new java.io.File(resourcesFileName);
        boolean resourcesFileExists = resourcesFile.exists();
        boolean bl = resourcesFileIsDirectory = resourcesFileExists && resourcesFile.isDirectory();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", uri);
            logger.logp(Level.FINER, className, methodName, "LoadStrategy [ {0} ] and archive [ {1} ]", new Object[]{this, this.getContainer()});
            logger.logp(Level.FINER, className, methodName, "Resources file name [ {0} ]", resourcesFileName);
            logger.logp(Level.FINER, className, methodName, "Resources file exists [ {0} ]", new Boolean(resourcesFileExists));
            logger.logp(Level.FINER, className, methodName, "Resources file is directory [ {0} ]", new Boolean(resourcesFileIsDirectory));
        }
        if (resourcesFileExists && !resourcesFileIsDirectory) {
            FileInputStream inputStream = new FileInputStream(resourcesFileName);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
            return inputStream;
        }
        if (!this.getArchiveBinariesIsDistinct()) {
            throw new FileNotFoundException("File [ " + uri + " ]" + " not found in archive [ " + this.getArchiveURI() + " ]" + " at [ " + this.getArchiveResourcesPath() + "]");
        }
        logger.logp(Level.FINER, className, methodName, "File not in resources location, and there is a distinct binaries location.");
        if (this.getArchiveBinariesIsDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Binaries available exists as a directory");
            String binaryFileName = this.getArchiveBinariesPath() + java.io.File.separator + uri;
            FileInputStream inputStream = new FileInputStream(binaryFileName);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
            return inputStream;
        }
        this.resolveBinariesFile();
        String useBinariesPath = this.getResolvedBinariesPath();
        logger.logp(Level.FINER, className, methodName, "Using binaries zip [ {0} ]", useBinariesPath);
        ZipFile zipFile = this.forceBinariesZipFile();
        ZipEntry targetEntry = zipFile.getEntry(uri);
        if (targetEntry != null) {
            InputStream inputStream = zipFile.getInputStream(targetEntry);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
            return inputStream;
        }
        logger.logp(Level.FINER, className, methodName, "Failed to locate entry [ {0} ] in archive [ {1} ]", new Object[]{uri, useBinariesPath});
        throw new FileNotFoundException("Failed to locate entry [ " + uri + " ] in archive [ " + useBinariesPath + " ]");
    }

    protected String getURIFrom(java.io.File aFile) {
        String methodName = "getURIFrom";
        logger.logp(Level.FINER, className, methodName, "ENTRY - file [ {0} ]", aFile);
        String name = "";
        String relative = null;
        String root = this.getDirectoryUriAsZipString();
        logger.logp(Level.FINER, className, methodName, "Root directory [ {0} ]", root);
        try {
            name = aFile.getCanonicalPath();
            logger.logp(Level.FINER, className, methodName, "Canonical path [ {0} ]", name);
            relative = this.makeRelative(name, root);
        }
        catch (IOException iox) {
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException getting canonical path");
            name = null;
        }
        if (relative == null) {
            name = aFile.getAbsolutePath();
            logger.logp(Level.FINER, className, methodName, "Absolute path [ {0} ]", name);
            relative = this.makeRelative(name, root);
        }
        if (relative == null) {
            name = aFile.getPath();
            logger.logp(Level.FINER, className, methodName, "File path [ {0} ]", name);
            root = this.replaceSeparators(this.getDirectoryUri());
            logger.logp(Level.FINER, className, methodName, "Updated root directory [ {0} ]", root);
            relative = this.makeRelative(name, root);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", relative);
        return relative;
    }

    private String replaceSeparators(String path) {
        if (java.io.File.separatorChar != '/') {
            return path.replace(java.io.File.separatorChar, '/');
        }
        return path;
    }

    private String makeRelative(String fileName, String root) {
        String name;
        int offset;
        if (fileName == null || root == null) {
            return null;
        }
        for (offset = root.length(); offset > 0 && root.charAt(offset - 1) == '/'; --offset) {
        }
        if (offset < root.length()) {
            if (++offset < root.length()) {
                root = root.substring(0, offset);
            }
        } else {
            root = root + '/';
        }
        name = (name = this.replaceSeparators(fileName)).startsWith(root) ? name.substring(root.length()) : null;
        return name;
    }

    protected void collectFilesFromBinaries(List filesSoFar) {
        String methodName = "collectFilesFromBinaries";
        logger.logp(Level.FINER, className, methodName, "ENTRY Container URI [ {0} ]", this.getContainer().getURI());
        String additionalBinariesPath = this.getAdditionalBinariesPath();
        if (additionalBinariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Non-distinct binaries case)");
            return;
        }
        Set urisSoFar = ArchiveUtil.collectFileUris(filesSoFar.iterator());
        if (this.getArchiveBinariesIsDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Set binaries exists as a directory.");
            this.addFilesFromBinariesDirectory("", this.getArchiveBinariesFile(), filesSoFar, urisSoFar);
            logger.logp(Level.FINER, className, methodName, "RETURN Binaries directory case");
            return;
        }
        try {
            this.resolveBinariesFile();
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to extract binaries to temporary location:\nBinaries files were not added!\nThis load strategy [ {0} ] Container [ {1} ]", new Object[]{this, this.getContainer()});
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN Failed temp binaries file case");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "Using binaries zip [ {0} ]", this.getResolvedBinariesPath());
        this.addFilesFromBinariesFile(this.getResolvedBinariesFile(), filesSoFar, urisSoFar);
        logger.logp(Level.FINER, className, methodName, "RETURN Binaries file case");
    }

    protected void addFilesFromBinariesDirectory(String relativeUriFromContainer, java.io.File file, List filesSoFar, Set urisSoFar) {
        String methodName = "addFilesFromBinariesDirectory";
        String fileName = file.getName();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER Relative URI [ {0} ]; current location [ {1} ]", new Object[]{relativeUriFromContainer, fileName});
        }
        if (file.isDirectory()) {
            logger.logp(Level.FINER, className, methodName, "External directory [ {0} ]", fileName);
            java.io.File[] childFiles = file.listFiles();
            if (childFiles == null) {
                logger.logp(Level.WARNING, className, methodName, "Failed to list external directory [ {0} ]", fileName);
            } else {
                for (int fileNo = 0; fileNo < childFiles.length; ++fileNo) {
                    java.io.File nextChildFile = childFiles[fileNo];
                    String nextFileName = nextChildFile.getName();
                    String nextRelativeUri = ArchiveUtil.concatenateUris(relativeUriFromContainer, nextFileName);
                    if (urisSoFar.contains(nextRelativeUri)) {
                        logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; already listed", nextRelativeUri);
                        continue;
                    }
                    logger.logp(Level.FINER, className, methodName, "Processing new file [ {0} ]", nextRelativeUri);
                    this.addFilesFromBinariesDirectory(nextRelativeUri, nextChildFile, filesSoFar, urisSoFar);
                }
            }
        } else {
            this.addFileFromBinariesDirectory(relativeUriFromContainer, file, filesSoFar, urisSoFar, fileName);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void addFileFromBinariesDirectory(String relativeUriFromContainer, java.io.File file, List filesSoFar, Set urisSoFar, String fileName) {
        String methodName = "addFileFromBinariesDirectory";
        logger.logp(Level.FINER, className, methodName, "   External file [ {0} ]", fileName);
        logger.logp(Level.FINER, className, methodName, "   file [ {0} ]", file);
        logger.logp(Level.FINER, className, methodName, "   relativeUriFromContainer [ {0} ]", relativeUriFromContainer);
        boolean isWAR = this.container.isWARFile();
        boolean isWebInfClasses = relativeUriFromContainer.startsWith("WEB-INF/classes");
        if (isWAR && isWebInfClasses) {
            String filePath = file.getPath();
            logger.logp(Level.FINER, className, methodName, "   file path [ {0} ]", filePath);
            File newFile = this.createFile(relativeUriFromContainer, filePath, true, file, null);
            filesSoFar.add(newFile);
            urisSoFar.add(relativeUriFromContainer);
            logger.logp(Level.FINER, className, methodName, "Added from WAR WEB-INF/classes: URI [ {0} ]", newFile.getURI());
        } else if (!fileName.endsWith(".jar")) {
            logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; not a JAR file", fileName);
        } else {
            try {
                Archive archive = this.createNestedArchiveFromBinaries(relativeUriFromContainer);
                filesSoFar.add(archive);
                urisSoFar.add(relativeUriFromContainer);
                logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ]", relativeUriFromContainer);
            }
            catch (OpenFailureException e) {
                logger.throwing(className, methodName, (Throwable)((Object)e));
                logger.logp(Level.SEVERE, className, methodName, "Failed to create archive [ {0} ]", relativeUriFromContainer);
            }
        }
    }

    protected void addFilesFromBinariesFile(java.io.File binariesRootFile, List filesSoFar, Set urisSoFar) {
        List entries;
        String methodName = "addArchivesFromBinaryFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        try {
            entries = ArchiveUtil.listArchiveEntries(binariesRootFile, false, true);
        }
        catch (IOException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "Failed to open binaries location [ {0} ]", binariesRootFile);
            return;
        }
        int numEntries = 0;
        int numAdded = 0;
        for (ArchiveUtil.EntryDetails nextEntry : entries) {
            File file;
            String nextEntryName = nextEntry.name;
            ++numEntries;
            if (urisSoFar.contains(nextEntryName)) {
                logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; already listed", nextEntryName);
                continue;
            }
            if (nextEntry.isDirectory) {
                logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; is-directory is true", nextEntryName);
                continue;
            }
            if (!nextEntryName.endsWith(".jar")) {
                logger.logp(Level.FINER, className, methodName, "Adding file [ {0} ]", nextEntryName);
                file = this.createNestedFileFromBinaries(nextEntry);
            } else {
                logger.logp(Level.FINER, className, methodName, "Adding java archive [ {0} ]", nextEntryName);
                try {
                    file = this.createNestedArchiveFromBinaries(nextEntryName);
                }
                catch (OpenFailureException e) {
                    logger.throwing(className, methodName, (Throwable)((Object)e));
                    logger.logp(Level.SEVERE, className, methodName, "Failed top open archive [ {0} ]", nextEntryName);
                    file = this.createNestedFileFromBinaries(nextEntry);
                }
            }
            filesSoFar.add(file);
            urisSoFar.add(nextEntryName);
            ++numAdded;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN Count of entries [ {0} ]; count of entries added [ {1} ]", new Object[]{new Integer(numEntries), new Integer(numAdded)});
        }
    }

    protected File createNestedFileFromBinaries(ArchiveUtil.EntryDetails details) {
        String methodName = "createNestedFileFromBinaries(EntryDetails)";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{details.name, useArchiveUri});
        }
        File file = this.createFile(details.name, details.size, details.lastModified, details.isDirectory);
        logger.logp(Level.FINER, className, methodName, "RETURN file [ {0} ]", file);
        return file;
    }

    protected File createNestedFileFromBinaries(ZipEntry entry) {
        String methodName = "createNestedFileFromBinaries(ZipEntry)";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{entry.getName(), useArchiveUri});
        }
        File file = this.createFile(entry.getName(), entry.getSize(), entry.getTime(), entry.isDirectory());
        logger.logp(Level.FINER, className, methodName, "RETURN file [ {0} ]", file);
        return file;
    }

    protected Archive createNestedArchiveFromBinaries(String uri) throws OpenFailureException {
        String methodName = "createNestedArchiveFromBinaries";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{uri, useArchiveUri});
        }
        CommonarchiveFactoryImpl factory = (CommonarchiveFactoryImpl)CommonarchiveFactory.eINSTANCE;
        Archive archive = factory.openNestedArchive(uri, this.getArchive(), true);
        archive.setCanImportAs(false);
        logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", archive);
        return archive;
    }
}

