/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ExportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War22ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War25ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.WarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class WARFileImpl
extends ModuleFileImpl
implements WARFile {
    protected WebApp deploymentDescriptor = null;
    protected WebApp mergedDeploymentDescriptor = null;
    protected List sourceFiles;
    protected static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static final String className = WARFileImpl.class.getName();
    public static final String SYSTEM_PROPERTY_MERGE_CONTENT = "org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl.getDeploymentDescriptor_mergeContent";
    protected static final boolean mergeContent = Boolean.getBoolean("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl.getDeploymentDescriptor_mergeContent");

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.WAR_FILE;
    }

    public String getMergedDeploymentDescriptorUri() {
        return "WEB-INF/web_merged.xml";
    }

    protected String getDDObjectId() {
        return "WebApp_ID";
    }

    public boolean isGeneratedDD() {
        if (this.deploymentDescriptor == null) {
            this.getDeploymentDescriptor(false);
        }
        return super.isGeneratedDD();
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add(copy);
        return copy;
    }

    public File addCopyLib(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_lib_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/lib/");
    }

    protected RuntimeClasspathEntry createLibClasspathEntry(String libPath) {
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(libPath);
        entry.setWarFile(this);
        return entry;
    }

    protected List getAllFileEntriesRecursive(java.io.File aFile, List aList) {
        if (!aFile.exists()) {
            return aList;
        }
        String name = aFile.getName();
        if (name.regionMatches(true, name.length() - 4, ".jar", 0, 4)) {
            aList.add(aFile.getAbsolutePath());
        } else if (aFile.isDirectory()) {
            java.io.File[] children = aFile.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.getAllFileEntriesRecursive(children[i], aList);
            }
        }
        return aList;
    }

    public List getClasses() {
        return this.filterFilesByPrefix("WEB-INF/classes/");
    }

    public WebApp getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(true);
    }

    public WebApp getDeploymentDescriptor(boolean mergeContent) throws DeploymentDescriptorLoadException {
        String methodName = "getDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        logger.logp(Level.FINER, className, methodName, "mergeContent [ {0} ]", new Boolean(mergeContent));
        if (mergeContent && this.mergedDeploymentDescriptor != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN cached merged deployment descriptor [ {0} ]", this.mergedDeploymentDescriptor);
            return this.mergedDeploymentDescriptor;
        }
        WebApp dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.WARFile_dd_load_error_0, new Object[]{e.getMessage()}));
                logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        WebApp webAppDD = this.getDeploymentDescriptorGen();
        webAppDD.storeJ2EEVersionID();
        this.setModuleVersion(webAppDD.getVersionID());
        if (mergeContent) {
            logger.logp(Level.FINER, className, methodName, "webAppDD.isMetadataComplete(): " + webAppDD.isMetadataComplete());
            logger.logp(Level.FINER, className, methodName, "WARFile.isAnnotationsSupported(): " + this.isAnnotationsSupported());
            if (!webAppDD.isMetadataComplete() && this.isAnnotationsSupported()) {
                logger.logp(Level.FINER, className, "getDeploymentDescriptor", "Condition(s) for processing annotations passed.");
                this.mergedDeploymentDescriptor = (WebApp)this.copyDeploymentDescriptor((EObject)webAppDD);
                this.mergedDeploymentDescriptor.storeJ2EEVersionID();
                this.processAnnotations(this.mergedDeploymentDescriptor);
                this.closeArchiveZipFile();
                logger.exiting(className, methodName, this.mergedDeploymentDescriptor);
                return this.mergedDeploymentDescriptor;
            }
            logger.logp(Level.FINER, className, methodName, "Condition(s) for processing annotations did NOT pass.");
        }
        this.closeArchiveZipFile();
        logger.logp(Level.FINER, className, methodName, "RETURN WAR File deployment descriptor [ {0} ]", webAppDD);
        return webAppDD;
    }

    private void processAnnotations(WebApp webAppDD) throws AnnotationsException {
        AnnotationsProcessor processor;
        String methodName = "processAnnotations";
        logger.entering(className, methodName, webAppDD);
        try {
            processor = this.getAnnotationsProcessor();
        }
        catch (AnnotationsProcessorException ape) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_annotations_processor_load_failure_0, new Object[]{ape}));
            logger.exiting(className, methodName);
            return;
        }
        MergeData mergeData = this.createMergeData((EObject)webAppDD);
        try {
            processor.merge(mergeData);
        }
        catch (Exception e) {
            this.processMergeException(e);
        }
        logger.exiting(className, methodName);
    }

    protected void cleanupOnClose() {
        logger.logp(Level.FINER, className, "cleanupOnClose", "ENTRY/RETURN");
        this.mergedDeploymentDescriptor = null;
    }

    public String getDeploymentDescriptorUri() {
        return "WEB-INF/web.xml";
    }

    public int getNoDescriptorVersionID() {
        return 25;
    }

    public List getLibs() {
        return this.filterFilesByPrefix("WEB-INF/lib/", true);
    }

    public List getLibArchives() {
        return this.filterFiles("WEB-INF/lib/", new String[]{"jar", "zip"}, true);
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String absolutePath;
        try {
            absolutePath = this.getLoadStrategy().getBinariesPath();
        }
        catch (IOException ex) {
            return new RuntimeClasspathEntry[0];
        }
        ArrayList<RuntimeClasspathEntry> entries = new ArrayList<RuntimeClasspathEntry>();
        if (this.getLoadStrategy().isDirectory()) {
            String classesPath = ArchiveUtil.getOSUri(absolutePath, "WEB-INF/classes/");
            entries.add(this.createRuntimeClasspathEntry(classesPath));
            this.addWebLibs(absolutePath, entries);
        }
        entries.add(this.createRuntimeClasspathEntry(absolutePath));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected void addWebLibs(String absolutePath, List entries) {
        java.io.File aFile = new java.io.File(ArchiveUtil.getOSUri(absolutePath, "WEB-INF/lib/"));
        List libs = this.getAllFileEntriesRecursive(aFile, new ArrayList());
        for (int i = 0; i < libs.size(); ++i) {
            String libPath = (String)libs.get(i);
            entries.add(this.createLibClasspathEntry(libPath));
        }
        this.addLooseLibsToRuntimeClasspath(entries);
    }

    protected void addLooseLibsToRuntimeClasspath(List entries) {
        LooseWARFile loose = (LooseWARFile)this.getLoadStrategy().getLooseArchive();
        if (loose == null) {
            return;
        }
        EList looseLibs = loose.getLooseLibs();
        for (int i = 0; i < looseLibs.size(); ++i) {
            LooseLibrary lib = (LooseLibrary)looseLibs.get(i);
            entries.add(this.createLibClasspathEntry(lib.getBinariesPath()));
        }
    }

    protected List calculateSourceCandidateFiles() {
        EList filesList = this.getFiles();
        Vector<File> retFiles = new Vector<File>();
        for (File file : filesList) {
            String aUri = file.getURI();
            if (!aUri.startsWith("WEB-INF") || aUri.startsWith("WEB-INF/lib/")) continue;
            retFiles.add(file);
        }
        return retFiles;
    }

    protected List getSourceCandidateFiles() {
        if (this.sourceFiles == null) {
            this.sourceFiles = this.calculateSourceCandidateFiles();
        }
        return this.sourceFiles;
    }

    protected String makeRelative(String pathString, String relToPathString) {
        if (pathString.startsWith(relToPathString)) {
            return ArchiveUtil.truncateFromFrontIgnoreCase(pathString, relToPathString);
        }
        return pathString;
    }

    public File getSourceFile(File aClassFile) {
        String classURI;
        List sourceFilesList = this.getSourceCandidateFiles();
        String convertedClassURI = classURI = aClassFile.getURI();
        if (!classURI.endsWith(".class")) {
            return null;
        }
        convertedClassURI = ArchiveUtil.classUriToJavaUri(aClassFile.getURI());
        convertedClassURI = this.makeRelative(convertedClassURI, "WEB-INF/classes/");
        int bestLength = Short.MAX_VALUE;
        File bestMatch = null;
        File file2 = null;
        String aUri = null;
        for (File file2 : sourceFilesList) {
            int excessLength;
            aUri = file2.getURI();
            if (!aUri.endsWith(convertedClassURI) || aUri.equals(classURI) || (excessLength = aUri.length() - convertedClassURI.length()) >= bestLength) continue;
            bestMatch = file2;
            bestLength = excessLength;
        }
        return bestMatch;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getStandardDeploymentDescriptor(true);
    }

    public EObject getStandardDeploymentDescriptor(boolean merge) throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(merge);
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isWARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        WebApp webApp = ((WebapplicationPackage)EPackage.Registry.INSTANCE.getEPackage("webapplication.xmi")).getWebapplicationFactory().createWebApp();
        resource.setID((EObject)webApp, "WebApp_ID");
        this.setDeploymentDescriptorGen(webApp);
        resource.getContents().add(webApp);
        return webApp;
    }

    public void setDeploymentDescriptor(WebApp webApp) {
        String methodName = "setDeploymentDescriptor";
        if (ArchiveUtil.isMergedDD((EObject)webApp)) {
            logger.logp(Level.SEVERE, className, methodName, "An attempt was made to set the Deployment Descriptor on an WAR Module to the merged form.");
            logger.throwing(className, methodName, new Exception());
        }
        this.setDeploymentDescriptorGen(webApp);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)webApp);
    }

    public WebApp getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (WebApp)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public WebApp basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(WebApp newDeploymentDescriptor) {
        WebApp oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public void setMergedDeploymentDescriptorGen(WebApp newMergedDeploymentDescriptor) {
        this.mergedDeploymentDescriptor = newMergedDeploymentDescriptor;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((WebApp)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new WarFileDynamicClassLoader(this, parentCl, extraCl);
    }

    public boolean isAnnotationsSupported() {
        int version = this.getSpecVersionID();
        return version >= 25;
    }

    public boolean requiresIterationOnSave() {
        if (this.mergedDeploymentDescriptor == null) {
            return false;
        }
        return this.mergedDeploymentDescriptor.isMetadataComplete();
    }

    public String getContextRoot() {
        return null;
    }

    public void setContextRoot(String contextRoot) {
    }

    public ExportStrategy getExportStrategy() {
        if (this.exportStrategy == null) {
            int version;
            if (this.isModuleVersionSet()) {
                version = this.getModuleVersion();
            } else {
                WebApp webApp = this.getDeploymentDescriptor(mergeContent);
                version = webApp.getVersionID();
            }
            if (version >= 25) {
                logger.logp(Level.FINER, className, "getExportStrategy", "creating new WAR25ExportStrategyImpl for [ {0} ]", this);
                this.exportStrategy = new War25ExportStrategyImpl();
                this.exportStrategy.setArchive(this);
            } else {
                logger.logp(Level.FINER, className, "getExportStrategy", "creating new WAR22ExportStrategyImpl for [ {0} ]", this);
                this.exportStrategy = new War22ExportStrategyImpl();
                this.exportStrategy.setArchive(this);
            }
        }
        return this.exportStrategy;
    }

    static {
        logger.logp(Level.FINER, className, "<clinit>", "mergeContent [ {0} ]", Boolean.toString(mergeContent));
    }
}

