/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ConnectorDirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.JcaFactory;
import org.eclipse.jst.j2ee.jca.JcaPackage;

public class RARFileImpl
extends ModuleFileImpl
implements RARFile {
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static final String className = RARFileImpl.class.getName();
    protected Connector deploymentDescriptor = null;
    protected Connector mergedDeploymentDescriptor = null;

    public String getMergedDeploymentDescriptorUri() {
        return "META-INF/ra_merged.xml";
    }

    protected String getDDObjectId() {
        return "J2CResourceAdapter_ID";
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.RAR_FILE;
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add(copy);
        return copy;
    }

    protected SaveStrategy createSaveStrategyForConnectorDirectory(java.io.File dir, int expansionFlags) {
        return new ConnectorDirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    public void extractToConnectorDirectory(String aUri, int expansionFlags) throws SaveFailureException {
        java.io.File aDir = new java.io.File(aUri);
        if (this.getLoadStrategy().isUsing(aDir)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForConnectorDirectory(aDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{this.uri}), ex);
        }
    }

    public List getClasses() {
        return this.filterFilesByPrefix("com");
    }

    public Connector getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(true);
    }

    public Connector getDeploymentDescriptor(boolean mergeContent) throws DeploymentDescriptorLoadException {
        String methodName = "getDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        logger.logp(Level.FINER, className, methodName, "mergeContent [ {0} ]", new Boolean(mergeContent));
        if (mergeContent && this.mergedDeploymentDescriptor != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN cached merged deployment descriptor [ {0} ]", this.mergedDeploymentDescriptor);
            return this.mergedDeploymentDescriptor;
        }
        Connector dd = this.deploymentDescriptor;
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        if (mergeContent) {
            if (this.isAnnotationsSupported()) {
                logger.logp(Level.FINER, className, methodName, "Condition(s) for processing annotations passed.");
                this.mergedDeploymentDescriptor = (Connector)this.copyDeploymentDescriptor((EObject)this.deploymentDescriptor);
                this.processAnnotations(this.mergedDeploymentDescriptor);
                this.closeArchiveZipFile();
                logger.logp(Level.FINER, className, methodName, "RETURN merged deployment descriptor [ {0} ]", this.mergedDeploymentDescriptor);
                return this.mergedDeploymentDescriptor;
            }
            logger.logp(Level.FINER, className, methodName, "Condition(s) for processing annotations did not pass.");
        }
        this.closeArchiveZipFile();
        logger.logp(Level.FINER, className, methodName, "RETURN unmerged deployment descriptor [ {0} ]", this.deploymentDescriptor);
        return this.deploymentDescriptor;
    }

    private void processAnnotations(Connector connectorDD) throws AnnotationsException {
        AnnotationsProcessor processor;
        String methodName = "processAnnotations";
        logger.entering(className, methodName);
        try {
            processor = this.getAnnotationsProcessor();
        }
        catch (AnnotationsProcessorException ape) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_annotations_processor_load_failure_0, new Object[]{ape}));
            return;
        }
        MergeData mergeData = this.createMergeData((EObject)connectorDD);
        try {
            processor.merge(mergeData);
        }
        catch (AnnotationsProcessorException e) {
            this.processMergeException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.processMergeException(e);
        }
        logger.exiting(className, methodName);
    }

    protected void cleanupOnClose() {
        logger.logp(Level.FINER, className, "cleanupOnClose", "ENTRY/RETURN");
        this.mergedDeploymentDescriptor = null;
    }

    public Connector basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/ra.xml";
    }

    public int getNoDescriptorVersionID() {
        return -1;
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getStandardDeploymentDescriptor(true);
    }

    public EObject getStandardDeploymentDescriptor(boolean merge) throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(merge);
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isRARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        JcaPackage p = (JcaPackage)EPackage.Registry.INSTANCE.getEPackage("jca.xmi");
        JcaFactory fct = p.getJcaFactory();
        Connector connector = fct.createConnector();
        this.setDeploymentDescriptor(connector);
        resource.getContents().add(connector);
        return connector;
    }

    public void setDeploymentDescriptor(Connector connector) {
        String methodName = "setDeploymentDescriptor";
        if (ArchiveUtil.isMergedDD((EObject)connector)) {
            logger.logp(Level.SEVERE, className, methodName, "An attempt was made to set the Deployment Descriptor on an RAR Module to the merged form.");
            logger.throwing(className, methodName, new Exception());
        }
        this.deploymentDescriptor = connector;
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)connector);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((Connector)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new RarFileDynamicClassLoader(this, parentCl, extraCl);
    }

    public boolean isAnnotationsSupported() {
        String enabled;
        int version = this.getSpecVersionID();
        return version >= 15 && (enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("jee5.annotations.rar.enabled");
            }
        })) != null && enabled.equalsIgnoreCase("true");
    }
}

