/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

final class ResourceProxyValidator {
    static HashMap resourceURIMap = new HashMap();

    ResourceProxyValidator() {
    }

    private static void resolveContainedProxies(EObject refObject) {
        EList contained = refObject.eContents();
        for (int i = 0; i < contained.size(); ++i) {
            EObject mofObject = (EObject)contained.get(i);
            ResourceProxyValidator.resolveProxies(mofObject);
        }
    }

    private static void resolveNonContainedProxies(EObject refObject) {
        EList references = refObject.eClass().getEAllReferences();
        for (int i = 0; i < references.size(); ++i) {
            URI resourceURI;
            String protocol;
            EObject proxyOrObject;
            EReference reference = (EReference)references.get(i);
            if (reference.isContainment() || reference.isTransient()) continue;
            if (reference.isMany()) {
                Iterator value = ((List)refObject.eGet(reference)).iterator();
                while (value.hasNext()) {
                    proxyOrObject = (EObject)value.next();
                    if (!proxyOrObject.eIsProxy()) continue;
                    value.remove();
                }
                continue;
            }
            proxyOrObject = (EObject)refObject.eGet(reference, false);
            if (proxyOrObject == null || !proxyOrObject.eIsProxy() || (protocol = (resourceURI = ((EObjectImpl)proxyOrObject).eProxyURI().trimFragment()).scheme()) != null && protocol.equals("java")) continue;
            String id = ((EObjectImpl)proxyOrObject).eProxyURI().fragment();
            if (resourceURIMap.get(resourceURI) != null) {
                Resource cachedResource = (Resource)resourceURIMap.get(resourceURI);
                proxyOrObject = (EObject)((XMLResource)cachedResource).getIDToEObjectMap().get(id);
            } else {
                proxyOrObject = (EObject)refObject.eGet(reference);
                resourceURIMap.put(resourceURI, proxyOrObject.eResource());
            }
            if (proxyOrObject != null && !proxyOrObject.eIsProxy()) continue;
            refObject.eSet(reference, null);
        }
    }

    private static void resolveProxies(EObject refObject) {
        if (refObject != null) {
            ResourceProxyValidator.resolveNonContainedProxies(refObject);
            ResourceProxyValidator.resolveContainedProxies(refObject);
        }
    }

    static void checkForUnresolvableProxies(Resource resource) {
        resourceURIMap = new HashMap();
        if (resource != null) {
            EList topLevels = resource.getContents();
            for (int i = 0; i < topLevels.size(); ++i) {
                EObject mofObject = (EObject)topLevels.get(i);
                ResourceProxyValidator.resolveProxies(mofObject);
            }
        }
    }
}

