/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ArchiveURIConverterImpl
extends URIConverterImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = ArchiveURIConverterImpl.class.getName();
    protected static final String fileProtocol = "file";
    protected static final String platformProtocol = "platform";
    private String inFilepath;
    private String outFilepath;
    protected Archive archive;
    protected String resourcesPath;

    public ArchiveURIConverterImpl(Archive anArchive, String resourcesPath) {
        LoadStrategy l;
        String methodName = "ArchiveURIConverterImpl";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - archive [ {0} ]", anArchive);
        this.setArchive(anArchive);
        this.resourcesPath = resourcesPath;
        logger.logp(Level.FINER, CLASS_NAME, methodName, "resources path [ {0} ]", resourcesPath);
        this.setInputFilepath(resourcesPath);
        String outpath = resourcesPath;
        if (outpath == null && (l = anArchive.getLoadStrategy()) != null && l.isDirectory()) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "directory load strategy");
            try {
                outpath = l.getAbsolutePath();
                logger.logp(Level.FINER, CLASS_NAME, methodName, "outpath [ {0} ]", outpath);
            }
            catch (FileNotFoundException ignore) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Ignoring FileNotFoundException while getting absolute path");
            }
        }
        this.setOutputFilepath(outpath);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected String getSearchText(URI uri) {
        String uriText;
        String methodName = "getSearchText";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER");
            logger.logp(Level.FINER, CLASS_NAME, methodName, "URI String [ {0} ], ", uri.toString());
            logger.logp(Level.FINER, CLASS_NAME, methodName, "URI File String [ {0} ], ", uri.toFileString());
        }
        if ((uriText = uri.toFileString()) == null) {
            uriText = uri.toString();
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Entry URI file string is null; using basic string [ {0} ]", uriText);
        } else if (File.separatorChar != '/') {
            uriText = uriText.replace(File.separatorChar, '/');
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ {0} ]", uriText);
        }
        return uriText;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        String methodName = "createInputStream";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - URI [ {0} ]", uri);
        if (this.resourcesPath != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "resourcesPath not null [ {0} ]; attempting to create stream using makeInputStream", this.resourcesPath);
            InputStream directInputStream = this.makeInputStream(uri);
            if (directInputStream != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN - direct input stream [ {0} ]", directInputStream);
                return directInputStream;
            }
        }
        String searchText = this.getSearchText(uri);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Obtaining archive input stream using text [ {0} ]", searchText);
        InputStream archiveInputStream = this.getArchive().getInputStream(searchText);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN - archive input stream [ {0} ]", archiveInputStream);
        return archiveInputStream;
    }

    public void setArchive(Archive newArchive) {
        this.archive = newArchive;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
        this.setInputFilepath(resourcesPath);
        this.setOutputFilepath(resourcesPath);
    }

    public URI normalize(URI uri) {
        return this.getInternalURIMap().getURI(uri);
    }

    public String getInputFilepath() {
        return this.inFilepath;
    }

    public void setInputFilepath(String filepath) {
        this.inFilepath = filepath;
    }

    public String getOutputFilepath() {
        return this.outFilepath;
    }

    public void setOutputFilepath(String filepath) {
        this.outFilepath = filepath;
    }

    public InputStream makeInputStream(URI uri) throws IOException {
        String methodName = "makeInputStream";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - URI [ {0} ]", uri);
        URI converted = uri;
        if ((fileProtocol.equals(converted.scheme()) || converted.scheme() == null) && this.inFilepath != null) {
            return this.searchFilePath(converted.toString());
        }
        URL url = this.createURL(converted.toString());
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN input stream [ {0} ]", inputStream);
        return inputStream;
    }

    protected InputStream searchFilePath(String filename) throws IOException {
        String methodName = "searchFilePath";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - filename [ {0} ]", filename);
        File file = new File(filename);
        if (file.isAbsolute()) {
            FileInputStream inputStream = new FileInputStream(file);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN input stream for absolute file [ {0} ]", inputStream);
            return inputStream;
        }
        StringTokenizer st = new StringTokenizer(this.inFilepath, ";");
        while (st.hasMoreTokens()) {
            String f = st.nextToken();
            ZipFile zf = null;
            try {
                zf = new ZipFile(f);
            }
            catch (Exception e) {
                // empty catch block
            }
            InputStream in = null;
            if (zf != null) {
                in = this.searchZipFile(zf, filename);
                if (in == null) {
                    try {
                        zf.close();
                    }
                    catch (Exception e) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "Ignore Exception while closing zipfile [ {0} ]", zf);
                    }
                }
            } else {
                in = this.searchDirectory(f, filename);
            }
            if (in == null) continue;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN input stream for absolute file [ {0} ]", in);
            return in;
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN null");
        return null;
    }

    protected InputStream searchDirectory(String dir, String filename) throws IOException {
        String qualifiedFilename;
        File f;
        String methodName = "searchDirectory";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - directory [ {0} ]", dir);
        if (dir.equals(".")) {
            dir = System.getProperty("user.dir");
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Use directory specified by system property [ {0} ]", dir);
        }
        if (!(f = new File(qualifiedFilename = dir + System.getProperty("file.separator") + filename.replace('/', File.separatorChar))).exists()) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN null.  File doesn't exist.");
            return null;
        }
        FileInputStream fis = new FileInputStream(f);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN FileInputStream [ {0} ]", fis);
        return fis;
    }

    protected InputStream searchZipFile(ZipFile zip, String filename) throws IOException {
        String methodName = "searchZipFile";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - zip [ {0} ]", zip);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Search for entry [ {0} ]", filename);
        ZipEntry entry = zip.getEntry(filename);
        if (entry == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN null. Entry not found.");
            return null;
        }
        InputStream is = zip.getInputStream(entry);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN InputStream [ {0} ]", is);
        return is;
    }

    public URL createURL(String uri) throws MalformedURLException {
        String methodName = "createURL";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - uri [ {0} ]", uri);
        MalformedURLException m = null;
        if (uri == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN null.  URI is null.");
            return null;
        }
        URL url = null;
        try {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Create URL from uri [ {0} ]", uri);
            url = new URL(uri);
        }
        catch (Exception e) {
            m = (MalformedURLException)e;
        }
        if (url != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN URL [ {0} ]", url);
            return url;
        }
        int index = uri.indexOf(":");
        if (index == -1 || index == 1) {
            uri = "file:" + uri;
        } else if (index > 0) {
            uri = "file:" + uri.substring(index + 1);
        }
        try {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Create URL from uri [ {0} ]", uri);
            url = new URL(uri);
        }
        catch (Exception e) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Ignore Exception received while creating URL");
        }
        if (url != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN URL [ {0} ]", url);
            return url;
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN Throw MalformedURLException");
        throw m;
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        String methodName = "createOutputStream";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - uri [ {0} ]", uri);
        URI converted = uri;
        if (platformProtocol.equals(converted.scheme())) {
            URL resolvedURL = this.resolvePlatform(new URL(converted.toString()));
            logger.logp(Level.FINER, CLASS_NAME, methodName, "resolved URL [ {0} ]", resolvedURL);
            if (resolvedURL != null) {
                converted = URI.createFileURI(resolvedURL.getFile());
                logger.logp(Level.FINER, CLASS_NAME, methodName, "converted URI [ {0} ]", converted);
            }
        }
        if (fileProtocol.equals(converted.scheme()) || converted.scheme() == null) {
            OutputStream os = this.openFileOutputStream(converted);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN OutputStream [ {0} ]", os);
            return os;
        }
        URL url = this.createURL(converted.toString());
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoOutput(true);
        OutputStream os = urlConnection.getOutputStream();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN OutputStream [ {0} ]", os);
        return os;
    }

    protected URL resolvePlatform(URL url) throws IOException {
        return null;
    }

    protected OutputStream openFileOutputStream(URI uri) throws IOException {
        String methodName = "openFileOutputStream";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY - uri [ {0} ]", uri);
        File file = new File(uri.toFileString());
        if (!file.isAbsolute() && this.outFilepath != null) {
            String filename = this.outFilepath + File.separator + uri.toFileString();
            logger.logp(Level.FINER, CLASS_NAME, methodName, "File is not absolute. Try filename [ {0} ]", filename);
            file = new File(filename);
        }
        String parent = file.getParent();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Parent [ {0} ]", parent);
        if (parent != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Create parent directory structure.");
            new File(parent).mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN OutputStream [ {0} ]", outputStream);
        return outputStream;
    }
}

