/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.common.internal.impl;

import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.IconType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionGroupNonDuplicateList
extends EObjectContainmentEList {
    private static final long serialVersionUID = 5433645981967097122L;
    private HashSet<String> values = new HashSet();

    public DescriptionGroupNonDuplicateList(InternalEObject obj, Class<?> cls, int featureId) {
        super(cls, obj, featureId);
    }

    @Override
    public void add(int index, Object obj) {
        if (obj == null) {
            super.add(index, obj);
            return;
        }
        if (this.isDuplicate(obj)) {
            return;
        }
        this.values.add(this.getValue(obj));
        super.add(index, obj);
    }

    @Override
    public boolean add(Object obj) {
        if (obj == null) {
            return super.add(obj);
        }
        if (this.isDuplicate(obj)) {
            return false;
        }
        this.values.add(this.getValue(obj));
        return super.add(obj);
    }

    @Override
    public void clear() {
        this.values.clear();
        super.clear();
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            return super.remove(index);
        }
        this.values.remove(this.getValue(this.get(index)));
        return super.remove(index);
    }

    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            return super.remove(obj);
        }
        this.values.remove(this.getValue(obj));
        return super.remove(obj);
    }

    private boolean isDuplicate(Object obj) {
        int classifier = ((EObject)obj).eClass().getClassifierID();
        String value = null;
        switch (classifier) {
            case 18: {
                value = this.getDescriptionValue((Description)obj);
                break;
            }
            case 10: {
                value = this.getDisplayNameValue((DisplayName)obj);
                break;
            }
            case 9: {
                value = this.getIconTypeValue((IconType)obj);
            }
            default: {
                return false;
            }
        }
        return this.values.contains(value);
    }

    private String getValue(Object obj) {
        int classifier = ((EObject)obj).eClass().getClassifierID();
        String value = null;
        switch (classifier) {
            case 18: {
                value = this.getDescriptionValue((Description)obj);
                break;
            }
            case 10: {
                value = this.getDisplayNameValue((DisplayName)obj);
                break;
            }
            case 9: {
                value = this.getIconTypeValue((IconType)obj);
            }
        }
        return value;
    }

    private String getDescriptionValue(Description description) {
        String lang = description.getLang();
        String value = description.getValue();
        if (lang == null) {
            lang = "";
        }
        if (value == null) {
            value = "";
        }
        return lang + "|" + value;
    }

    private String getDisplayNameValue(DisplayName displayName) {
        String lang = displayName.getLang();
        String value = displayName.getValue();
        if (lang == null) {
            lang = "";
        }
        if (value == null) {
            value = "";
        }
        return lang + "|" + value;
    }

    private String getIconTypeValue(IconType iconType) {
        String lang = iconType.getLang();
        String largeIcon = iconType.getLargeIcon();
        String smallIcon = iconType.getSmallIcon();
        if (lang == null) {
            lang = "";
        }
        if (largeIcon == null) {
            largeIcon = "";
        }
        if (smallIcon == null) {
            smallIcon = "";
        }
        return lang + "|" + largeIcon + "|" + smallIcon;
    }
}

