/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.core.LoggingCoreUtilities;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.SerializableImpl;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class CommonBaseEventImpl
extends SerializableImpl
implements CommonBaseEvent,
ISerializableAsXml,
Cloneable {
    private static final long serialVersionUID = -7210409289362234835L;
    private static final EStructuralFeature anyFeature = EventPackage.eINSTANCE.getCommonBaseEvent_Any();
    private static final EStructuralFeature associatedEventsFeature = EventPackage.eINSTANCE.getCommonBaseEvent_AssociatedEvents();
    private static final EStructuralFeature contextDataElementsFeature = EventPackage.eINSTANCE.getCommonBaseEvent_ContextDataElements();
    private static final EStructuralFeature extendedDataElementsFeature = EventPackage.eINSTANCE.getCommonBaseEvent_ExtendedDataElements();
    private transient ContentHandler contentHandler;
    private transient boolean isComplete = false;
    protected static final String CREATION_TIME_EDEFAULT = null;
    protected String creationTime = CREATION_TIME_EDEFAULT;
    protected boolean creationTimeESet = false;
    protected static final String GLOBAL_INSTANCE_ID_EDEFAULT = null;
    protected String globalInstanceId = GLOBAL_INSTANCE_ID_EDEFAULT;
    protected static final long ELAPSED_TIME_EDEFAULT = 0L;
    protected long elapsedTime = 0L;
    protected boolean elapsedTimeESet = false;
    protected static final String EXTENSION_NAME_EDEFAULT = null;
    protected String extensionName = EXTENSION_NAME_EDEFAULT;
    protected static final String LOCAL_INSTANCE_ID_EDEFAULT = null;
    protected String localInstanceId = LOCAL_INSTANCE_ID_EDEFAULT;
    protected static final String MSG_EDEFAULT = null;
    protected String msg = MSG_EDEFAULT;
    protected static final short PRIORITY_EDEFAULT = 0;
    protected short priority = 0;
    protected boolean priorityESet = false;
    protected static final short REPEAT_COUNT_EDEFAULT = 0;
    protected short repeatCount = 0;
    protected boolean repeatCountESet = false;
    protected static final long SEQUENCE_NUMBER_EDEFAULT = 0L;
    protected long sequenceNumber = 0L;
    protected boolean sequenceNumberESet = false;
    protected static final short SEVERITY_EDEFAULT = 0;
    protected short severity = 0;
    protected boolean severityESet = false;
    protected static final String VERSION_EDEFAULT = "1.0.1";
    protected String version = "1.0.1";
    protected EList any = null;
    protected Situation situation = null;
    protected EList associatedEvents = null;
    protected EList contextDataElements = null;
    protected EList extendedDataElements = null;
    protected MsgDataElement msgDataElement = null;
    protected ComponentIdentification reporterComponentId = null;
    protected ComponentIdentification sourceComponentId = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected CommonBaseEventImpl() {
    }

    public EList getAny() {
        if (this.any == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.any = new EDataTypeEList(clazz, this, 11);
        }
        return this.any;
    }

    public EList getAssociatedEvents() {
        if (this.associatedEvents == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.hyades.logging.events.cbe.AssociatedEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.associatedEvents = new EObjectContainmentEList(clazz, this, 13);
        }
        return this.associatedEvents;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.isComplete = false;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public EList getContextDataElements() {
        if (this.contextDataElements == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.hyades.logging.events.cbe.ContextDataElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.contextDataElements = new EObjectContainmentEList(clazz, this, 14);
        }
        return this.contextDataElements;
    }

    public EList getContextDataElements(String name) {
        ListIterator it = this.getContextDataElements().listIterator();
        BasicEList res = new BasicEList();
        ContextDataElement cde = null;
        while (it.hasNext()) {
            cde = (ContextDataElement)it.next();
            if (cde == null || !cde.getName().equals(name)) continue;
            res.addUnique(cde);
        }
        return res;
    }

    public void setCreationTime(String newCreationTime) {
        String oldCreationTime = this.creationTime;
        this.creationTime = newCreationTime;
        boolean oldCreationTimeESet = this.creationTimeESet;
        this.creationTimeESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCreationTime, (Object)this.creationTime, !oldCreationTimeESet));
        }
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTimeAsLong(long inDateTime) {
        this.setCreationTime(LoggingCoreUtilities.convertMillisecondsToXsdDateTime(inDateTime));
    }

    public long getCreationTimeAsLong() {
        long result = 0L;
        if (this.isSetCreationTime()) {
            try {
                result = LoggingCoreUtilities.convertXsdDateTimeToMilliseconds(this.getCreationTime());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(String.valueOf(this.getCreationTime()) + " is not a valid xsd:dateTime string");
            }
        }
        return result;
    }

    public void setElapsedTime(long newElapsedTime) {
        long oldElapsedTime = this.elapsedTime;
        this.elapsedTime = newElapsedTime;
        boolean oldElapsedTimeESet = this.elapsedTimeESet;
        this.elapsedTimeESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, oldElapsedTime, this.elapsedTime, !oldElapsedTimeESet));
        }
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public EList getExtendedDataElements() {
        if (this.extendedDataElements == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.hyades.logging.events.cbe.ExtendedDataElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extendedDataElements = new EObjectContainmentEList(clazz, this, 15);
        }
        return this.extendedDataElements;
    }

    public EList getExtendedDataElements(String name) {
        ListIterator it = this.getExtendedDataElements().listIterator();
        BasicEList res = new BasicEList();
        ExtendedDataElement ede = null;
        while (it.hasNext()) {
            ede = (ExtendedDataElement)it.next();
            if (ede == null || !ede.getName().equals(name)) continue;
            res.addUnique(ede);
        }
        return res;
    }

    public void setExtensionName(String newExtensionName) {
        String oldExtensionName = this.extensionName;
        this.extensionName = newExtensionName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldExtensionName, (Object)this.extensionName));
        }
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setGlobalInstanceId(String newGlobalInstanceId) {
        String oldGlobalInstanceId = this.globalInstanceId;
        this.globalInstanceId = newGlobalInstanceId;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldGlobalInstanceId, (Object)this.globalInstanceId));
        }
    }

    public String getGlobalInstanceId() {
        return this.globalInstanceId;
    }

    public void setLocalInstanceId(String newLocalInstanceId) {
        String oldLocalInstanceId = this.localInstanceId;
        this.localInstanceId = newLocalInstanceId;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLocalInstanceId, (Object)this.localInstanceId));
        }
    }

    public String getLocalInstanceId() {
        return this.localInstanceId;
    }

    public void setMsg(String newMsg) {
        String oldMsg = this.msg;
        this.msg = newMsg;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldMsg, (Object)this.msg));
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsgDataElement(MsgDataElement newMsgDataElement) {
        if (newMsgDataElement != this.msgDataElement) {
            NotificationChain msgs = null;
            if (this.msgDataElement != null) {
                msgs = ((InternalEObject)((Object)this.msgDataElement)).eInverseRemove(this, -17, null, msgs);
            }
            if (newMsgDataElement != null) {
                msgs = ((InternalEObject)((Object)newMsgDataElement)).eInverseAdd(this, -17, null, msgs);
            }
            if ((msgs = this.basicSetMsgDataElement(newMsgDataElement, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newMsgDataElement, (Object)newMsgDataElement));
        }
    }

    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, MsgCatalogToken[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokens(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        this.setMsgDataElement(mde);
        return mde;
    }

    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, String[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokensAsStrings(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        this.setMsgDataElement(mde);
        return mde;
    }

    public MsgDataElement getMsgDataElement() {
        return this.msgDataElement;
    }

    public void setPriority(short newPriority) {
        short oldPriority = this.priority;
        this.priority = newPriority;
        boolean oldPriorityESet = this.priorityESet;
        this.priorityESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, oldPriority, this.priority, !oldPriorityESet));
        }
    }

    public short getPriority() {
        return this.priority;
    }

    public void setRepeatCount(short newRepeatCount) {
        short oldRepeatCount = this.repeatCount;
        this.repeatCount = newRepeatCount;
        boolean oldRepeatCountESet = this.repeatCountESet;
        this.repeatCountESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, oldRepeatCount, this.repeatCount, !oldRepeatCountESet));
        }
    }

    public short getRepeatCount() {
        return this.repeatCount;
    }

    public void setReporterComponentId(ComponentIdentification newReporterComponentId) {
        if (newReporterComponentId != this.reporterComponentId) {
            NotificationChain msgs = null;
            if (this.reporterComponentId != null) {
                msgs = ((InternalEObject)((Object)this.reporterComponentId)).eInverseRemove(this, -18, null, msgs);
            }
            if (newReporterComponentId != null) {
                msgs = ((InternalEObject)((Object)newReporterComponentId)).eInverseAdd(this, -18, null, msgs);
            }
            if ((msgs = this.basicSetReporterComponentId(newReporterComponentId, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 17, (Object)newReporterComponentId, (Object)newReporterComponentId));
        }
    }

    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();
        cid.setApplication(application);
        cid.setComponent(component);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setApplication(application);
        cid.setSubComponent(subComponent);
        cid.setThreadId(threadId);
        this.setReporterComponentId(cid);
    }

    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        this.setReporterComponentId(application, component, subComponent, componentType, componentIdType, null, null, location, locationType, null, null);
    }

    public ComponentIdentification getReporterComponentId() {
        return this.reporterComponentId;
    }

    public void setSequenceNumber(long newSequenceNumber) {
        long oldSequenceNumber = this.sequenceNumber;
        this.sequenceNumber = newSequenceNumber;
        boolean oldSequenceNumberESet = this.sequenceNumberESet;
        this.sequenceNumberESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, oldSequenceNumber, this.sequenceNumber, !oldSequenceNumberESet));
        }
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isSetCreationTime() {
        return this.creationTimeESet;
    }

    public boolean isSetElapsedTime() {
        return this.elapsedTimeESet;
    }

    public boolean isSetPriority() {
        return this.priorityESet;
    }

    public boolean isSetRepeatCount() {
        return this.repeatCountESet;
    }

    public boolean isSetSequenceNumber() {
        return this.sequenceNumberESet;
    }

    public boolean isSetSeverity() {
        return this.severityESet;
    }

    public void setSeverity(short newSeverity) {
        short oldSeverity = this.severity;
        this.severity = newSeverity;
        boolean oldSeverityESet = this.severityESet;
        this.severityESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, oldSeverity, this.severity, !oldSeverityESet));
        }
    }

    public short getSeverity() {
        return this.severity;
    }

    public void setSituation(Situation newSituation) {
        if (newSituation != this.situation) {
            NotificationChain msgs = null;
            if (this.situation != null) {
                msgs = ((InternalEObject)((Object)this.situation)).eInverseRemove(this, -13, null, msgs);
            }
            if (newSituation != null) {
                msgs = ((InternalEObject)((Object)newSituation)).eInverseAdd(this, -13, null, msgs);
            }
            if ((msgs = this.basicSetSituation(newSituation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newSituation, (Object)newSituation));
        }
    }

    public Situation getSituation() {
        return this.situation;
    }

    public void setSourceComponentId(ComponentIdentification newSourceComponentId) {
        if (newSourceComponentId != this.sourceComponentId) {
            NotificationChain msgs = null;
            if (this.sourceComponentId != null) {
                msgs = ((InternalEObject)((Object)this.sourceComponentId)).eInverseRemove(this, -19, null, msgs);
            }
            if (newSourceComponentId != null) {
                msgs = ((InternalEObject)((Object)newSourceComponentId)).eInverseAdd(this, -19, null, msgs);
            }
            if ((msgs = this.basicSetSourceComponentId(newSourceComponentId, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 18, (Object)newSourceComponentId, (Object)newSourceComponentId));
        }
    }

    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();
        cid.setApplication(application);
        cid.setComponent(component);
        cid.setSubComponent(subComponent);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setThreadId(threadId);
        this.setSourceComponentId(cid);
    }

    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        this.setSourceComponentId(application, component, subComponent, componentType, componentIdType, null, null, location, locationType, null, null);
    }

    public ComponentIdentification getSourceComponentId() {
        return this.sourceComponentId;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersion, (Object)this.version));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void addAny(String any) {
        this.getAny().add(any);
    }

    public void clearAny() {
        this.getAny().clear();
    }

    public AssociatedEvent addAssociatedEvent(String associationEngineName, String associationEngineType, String associationEngineId, String[] resolvedEvents) {
        AssociatedEvent ase = EventFactory.eINSTANCE.createAssociatedEvent();
        ase.setAssociationEngineInfo(associationEngineName, associationEngineType, associationEngineId);
        ase.setResolvedEventsAsArray(resolvedEvents);
        this.getAssociatedEvents().add(ase);
        return ase;
    }

    private ContextDataElement addContextDataElement(String contextType, String contextName, String contextValue, String contextId) {
        ContextDataElement cde = EventFactory.eINSTANCE.createContextDataElement();
        if (contextId != null) {
            cde.setContextId(contextId);
        }
        if (contextValue != null) {
            cde.setContextValue(contextValue);
        }
        cde.setName(contextName);
        cde.setType(contextType);
        this.getContextDataElements().add(cde);
        return cde;
    }

    public ContextDataElement addContextDataElementWithValue(String contextType, String contextName, String contextValue) {
        return this.addContextDataElement(contextType, contextName, contextValue, null);
    }

    public ContextDataElement addContextDataElementWithId(String contextType, String contextName, String contextId) {
        return this.addContextDataElement(contextType, contextName, null, contextId);
    }

    public ExtendedDataElement addExtendedDataElement(String name, int type, String value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        if (19 == type) {
            ede.setHexValue(value);
        } else {
            ede.getValues().add(value);
        }
        return ede;
    }

    public ExtendedDataElement addExtendedDataElement(String name, int type, String[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        ede.getValues().addAll(Arrays.asList(values));
        return ede;
    }

    public ExtendedDataElement addExtendedDataElement(String name, String value) {
        return this.addExtendedDataElement(name, 7, value);
    }

    public ExtendedDataElement addExtendedDataElement(String name, String[] values) {
        return this.addExtendedDataElement(name, 16, values);
    }

    public ExtendedDataElement addExtendedDataElement(ExtendedDataElement extendedDataElement) {
        this.getExtendedDataElements().add(extendedDataElement);
        return extendedDataElement;
    }

    public ExtendedDataElement addExtendedDataElement(String name) {
        ExtendedDataElement ede = EventFactory.eINSTANCE.createExtendedDataElement();
        ede.setName(name);
        this.getExtendedDataElements().add(ede);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithByteArrayValue(String name, byte[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsByteArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithByteValue(String name, byte value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsByte(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithNoValue(String name) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setType("noValue");
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithBooleanArrayValue(String name, boolean[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsBooleanArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithBooleanValue(String name, boolean value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsBoolean(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateArrayValue(String name, String[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateAsLongValue(String name, long value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateAsLong(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateValue(String name, String value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDate(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDatesAsLongValue(String name, long[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateAsLongArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDoubleArrayValue(String name, double[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDoubleArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDoubleValue(String name, double value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDouble(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithFloatArrayValue(String name, float[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsFloatArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithFloatValue(String name, float value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsFloat(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithIntArrayValue(String name, int[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsIntArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithIntValue(String name, int value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsInt(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithLongArrayValue(String name, long[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsLongArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithLongValue(String name, long value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsLong(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithShortArrayValue(String name, short[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsShortArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithShortValue(String name, short value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsShort(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, byte[] hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType("hexBinary");
        result.setName(name);
        result.setHexValueAsByteArray(hexValue);
        this.getExtendedDataElements().add(result);
        return result;
    }

    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, String hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType("hexBinary");
        result.setName(name);
        result.setHexValue(hexValue);
        this.getExtendedDataElements().add(result);
        return result;
    }

    public void clearExtendedDataElements() {
        this.getExtendedDataElements().clear();
    }

    public void removeExtendedDataElements(String name) {
        if (this.getExtendedDataElements() != null) {
            int counter = 0;
            while (counter < this.getExtendedDataElements().size()) {
                if (((ExtendedDataElement)this.extendedDataElements.get(counter)).getName().equals(name)) {
                    this.extendedDataElements.remove(counter--);
                }
                ++counter;
            }
        }
    }

    public ContextDataElement addContextDataElement(ContextDataElement contextDataElement) {
        this.getContextDataElements().add(contextDataElement);
        return contextDataElement;
    }

    public void clearContextDataElements() {
        this.getContextDataElements().clear();
    }

    public void removeContextDataElements(String name) {
        if (this.getContextDataElements() != null) {
            int counter = 0;
            while (counter < this.getContextDataElements().size()) {
                if (((ContextDataElement)this.getContextDataElements().get(counter)).getName().equals(name)) {
                    this.getContextDataElements().remove(counter--);
                }
                ++counter;
            }
        }
    }

    public AssociatedEvent addAssociatedEvent(AssociatedEvent associatedEvent) {
        this.getAssociatedEvents().add(associatedEvent);
        return associatedEvent;
    }

    public void clearAssociatedEvents() {
        this.getAssociatedEvents().clear();
    }

    public NotificationChain basicSetMsgDataElement(MsgDataElement newMsgDataElement, NotificationChain msgs) {
        MsgDataElement oldMsgDataElement = this.msgDataElement;
        this.msgDataElement = newMsgDataElement;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldMsgDataElement, (Object)newMsgDataElement);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetReporterComponentId(ComponentIdentification newReporterComponentId, NotificationChain msgs) {
        ComponentIdentification oldReporterComponentId = this.reporterComponentId;
        this.reporterComponentId = newReporterComponentId;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldReporterComponentId, (Object)newReporterComponentId);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetSituation(Situation newSituation, NotificationChain msgs) {
        Situation oldSituation = this.situation;
        this.situation = newSituation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldSituation, (Object)newSituation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetSourceComponentId(ComponentIdentification newSourceComponentId, NotificationChain msgs) {
        ComponentIdentification oldSourceComponentId = this.sourceComponentId;
        this.sourceComponentId = newSourceComponentId;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldSourceComponentId, (Object)newSourceComponentId);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws CompletionException {
        if (this.contentHandler != null) {
            CommonBaseEventImpl commonBaseEventImpl = this;
            synchronized (commonBaseEventImpl) {
                this.contentHandler.completeEvent(this);
            }
            this.isComplete = true;
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getCreationTime();
            }
            case 1: {
                return this.getGlobalInstanceId();
            }
            case 2: {
                return new Long(this.getElapsedTime());
            }
            case 3: {
                return this.getExtensionName();
            }
            case 4: {
                return this.getLocalInstanceId();
            }
            case 5: {
                return this.getMsg();
            }
            case 6: {
                return new Short(this.getPriority());
            }
            case 7: {
                return new Short(this.getRepeatCount());
            }
            case 8: {
                return new Long(this.getSequenceNumber());
            }
            case 9: {
                return new Short(this.getSeverity());
            }
            case 10: {
                return this.getVersion();
            }
            case 11: {
                return this.getAny();
            }
            case 12: {
                return this.getSituation();
            }
            case 13: {
                return this.getAssociatedEvents();
            }
            case 14: {
                return this.getContextDataElements();
            }
            case 15: {
                return this.getExtendedDataElements();
            }
            case 16: {
                return this.getMsgDataElement();
            }
            case 17: {
                return this.getReporterComponentId();
            }
            case 18: {
                return this.getSourceComponentId();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 12: {
                    return this.basicSetSituation(null, msgs);
                }
                case 13: {
                    return ((InternalEList)this.getAssociatedEvents()).basicRemove(otherEnd, msgs);
                }
                case 14: {
                    return ((InternalEList)this.getContextDataElements()).basicRemove(otherEnd, msgs);
                }
                case 15: {
                    return ((InternalEList)this.getExtendedDataElements()).basicRemove(otherEnd, msgs);
                }
                case 16: {
                    return this.basicSetMsgDataElement(null, msgs);
                }
                case 17: {
                    return this.basicSetReporterComponentId(null, msgs);
                }
                case 18: {
                    return this.basicSetSourceComponentId(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.isSetCreationTime();
            }
            case 1: {
                return GLOBAL_INSTANCE_ID_EDEFAULT == null ? this.globalInstanceId != null : !GLOBAL_INSTANCE_ID_EDEFAULT.equals(this.globalInstanceId);
            }
            case 2: {
                return this.isSetElapsedTime();
            }
            case 3: {
                return EXTENSION_NAME_EDEFAULT == null ? this.extensionName != null : !EXTENSION_NAME_EDEFAULT.equals(this.extensionName);
            }
            case 4: {
                return LOCAL_INSTANCE_ID_EDEFAULT == null ? this.localInstanceId != null : !LOCAL_INSTANCE_ID_EDEFAULT.equals(this.localInstanceId);
            }
            case 5: {
                return MSG_EDEFAULT == null ? this.msg != null : !MSG_EDEFAULT.equals(this.msg);
            }
            case 6: {
                return this.isSetPriority();
            }
            case 7: {
                return this.isSetRepeatCount();
            }
            case 8: {
                return this.isSetSequenceNumber();
            }
            case 9: {
                return this.isSetSeverity();
            }
            case 10: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 11: {
                return this.any != null && !this.any.isEmpty();
            }
            case 12: {
                return this.situation != null;
            }
            case 13: {
                return this.associatedEvents != null && !this.associatedEvents.isEmpty();
            }
            case 14: {
                return this.contextDataElements != null && !this.contextDataElements.isEmpty();
            }
            case 15: {
                return this.extendedDataElements != null && !this.extendedDataElements.isEmpty();
            }
            case 16: {
                return this.msgDataElement != null;
            }
            case 17: {
                return this.reporterComponentId != null;
            }
            case 18: {
                return this.sourceComponentId != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setCreationTime((String)newValue);
                return;
            }
            case 1: {
                this.setGlobalInstanceId((String)newValue);
                return;
            }
            case 2: {
                this.setElapsedTime((Long)newValue);
                return;
            }
            case 3: {
                this.setExtensionName((String)newValue);
                return;
            }
            case 4: {
                this.setLocalInstanceId((String)newValue);
                return;
            }
            case 5: {
                this.setMsg((String)newValue);
                return;
            }
            case 6: {
                this.setPriority((Short)newValue);
                return;
            }
            case 7: {
                this.setRepeatCount((Short)newValue);
                return;
            }
            case 8: {
                this.setSequenceNumber((Long)newValue);
                return;
            }
            case 9: {
                this.setSeverity((Short)newValue);
                return;
            }
            case 10: {
                this.setVersion((String)newValue);
                return;
            }
            case 11: {
                this.getAny().clear();
                this.getAny().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setSituation((Situation)newValue);
                return;
            }
            case 13: {
                this.getAssociatedEvents().clear();
                this.getAssociatedEvents().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getContextDataElements().clear();
                this.getContextDataElements().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getExtendedDataElements().clear();
                this.getExtendedDataElements().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setMsgDataElement((MsgDataElement)newValue);
                return;
            }
            case 17: {
                this.setReporterComponentId((ComponentIdentification)newValue);
                return;
            }
            case 18: {
                this.setSourceComponentId((ComponentIdentification)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.unsetCreationTime();
                return;
            }
            case 1: {
                this.setGlobalInstanceId(GLOBAL_INSTANCE_ID_EDEFAULT);
                return;
            }
            case 2: {
                this.unsetElapsedTime();
                return;
            }
            case 3: {
                this.setExtensionName(EXTENSION_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setLocalInstanceId(LOCAL_INSTANCE_ID_EDEFAULT);
                return;
            }
            case 5: {
                this.setMsg(MSG_EDEFAULT);
                return;
            }
            case 6: {
                this.unsetPriority();
                return;
            }
            case 7: {
                this.unsetRepeatCount();
                return;
            }
            case 8: {
                this.unsetSequenceNumber();
                return;
            }
            case 9: {
                this.unsetSeverity();
                return;
            }
            case 10: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 11: {
                this.getAny().clear();
                return;
            }
            case 12: {
                this.setSituation(null);
                return;
            }
            case 13: {
                this.getAssociatedEvents().clear();
                return;
            }
            case 14: {
                this.getContextDataElements().clear();
                return;
            }
            case 15: {
                this.getExtendedDataElements().clear();
                return;
            }
            case 16: {
                this.setMsgDataElement(null);
                return;
            }
            case 17: {
                this.setReporterComponentId(null);
                return;
            }
            case 18: {
                this.setSourceComponentId(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object arg0) {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (creationTime: ");
        if (this.creationTimeESet) {
            result.append(this.creationTime);
        } else {
            result.append("<unset>");
        }
        result.append(", globalInstanceId: ");
        result.append(this.globalInstanceId);
        result.append(", elapsedTime: ");
        if (this.elapsedTimeESet) {
            result.append(this.elapsedTime);
        } else {
            result.append("<unset>");
        }
        result.append(", extensionName: ");
        result.append(this.extensionName);
        result.append(", localInstanceId: ");
        result.append(this.localInstanceId);
        result.append(", msg: ");
        result.append(this.msg);
        result.append(", priority: ");
        if (this.priorityESet) {
            result.append(this.priority);
        } else {
            result.append("<unset>");
        }
        result.append(", repeatCount: ");
        if (this.repeatCountESet) {
            result.append(this.repeatCount);
        } else {
            result.append("<unset>");
        }
        result.append(", sequenceNumber: ");
        if (this.sequenceNumberESet) {
            result.append(this.sequenceNumber);
        } else {
            result.append("<unset>");
        }
        result.append(", severity: ");
        if (this.severityESet) {
            result.append(this.severity);
        } else {
            result.append("<unset>");
        }
        result.append(", version: ");
        result.append(this.version);
        result.append(", any: ");
        result.append(this.any);
        result.append(", situation: ");
        result.append(this.situation);
        result.append(", associatedEvents: ");
        result.append(this.associatedEvents);
        result.append(", contextDataElements: ");
        result.append(this.contextDataElements);
        result.append(", extendedDataElements: ");
        result.append(this.extendedDataElements);
        result.append(", msgDataElement: ");
        result.append(this.msgDataElement);
        result.append(", reporterComponentId: ");
        result.append(this.reporterComponentId);
        result.append(", sourceComponentId: ");
        result.append(this.sourceComponentId);
        result.append(')');
        return result.toString();
    }

    public void unsetCreationTime() {
        String oldCreationTime = this.creationTime;
        boolean oldCreationTimeESet = this.creationTimeESet;
        this.creationTime = CREATION_TIME_EDEFAULT;
        this.creationTimeESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldCreationTime, (Object)CREATION_TIME_EDEFAULT, oldCreationTimeESet));
        }
    }

    public void unsetElapsedTime() {
        long oldElapsedTime = this.elapsedTime;
        boolean oldElapsedTimeESet = this.elapsedTimeESet;
        this.elapsedTime = 0L;
        this.elapsedTimeESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 2, oldElapsedTime, 0L, oldElapsedTimeESet));
        }
    }

    public void unsetPriority() {
        short oldPriority = this.priority;
        boolean oldPriorityESet = this.priorityESet;
        this.priority = 0;
        this.priorityESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 6, oldPriority, 0, oldPriorityESet));
        }
    }

    public void unsetRepeatCount() {
        short oldRepeatCount = this.repeatCount;
        boolean oldRepeatCountESet = this.repeatCountESet;
        this.repeatCount = 0;
        this.repeatCountESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 7, oldRepeatCount, 0, oldRepeatCountESet));
        }
    }

    public void unsetSequenceNumber() {
        long oldSequenceNumber = this.sequenceNumber;
        boolean oldSequenceNumberESet = this.sequenceNumberESet;
        this.sequenceNumber = 0L;
        this.sequenceNumberESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 8, oldSequenceNumber, 0L, oldSequenceNumberESet));
        }
    }

    public void unsetSeverity() {
        short oldSeverity = this.severity;
        boolean oldSeverityESet = this.severityESet;
        this.severity = 0;
        this.severityESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 9, oldSeverity, 0, oldSeverityESet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            ListIterator iterator;
            if (this.sourceComponentId == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.SourceComponentId"));
            }
            if (this.situation == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation"));
            }
            if (this.creationTime == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.CreationTime"));
            }
            if (this.repeatCount > 0 && !this.isSetElapsedTime()) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ElapsedTime"));
            }
            if (this.version != null && !this.version.equals(VERSION_EDEFAULT)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_VERSION_EXC_", "CommonBaseEvent.Version", this.version));
            }
            if (this.localInstanceId != null && this.localInstanceId.length() > 128) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.LocalInstanceId", this.localInstanceId, new Integer(this.localInstanceId.length()), new Integer(128)));
            }
            if (this.extensionName != null && this.extensionName.length() > 64) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ExtensionName", this.extensionName, new Integer(this.extensionName.length()), new Integer(64)));
            }
            if (this.msg != null && this.msg.length() > 1024) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Msg", this.msg, new Integer(this.msg.length()), new Integer(1024)));
            }
            if (this.globalInstanceId != null) {
                if (this.globalInstanceId.length() < 32 || this.globalInstanceId.length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", "CommonBaseEvent.GlobalInstanceId", this.globalInstanceId));
                }
                if (!Character.isLetter(this.globalInstanceId.charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", "CommonBaseEvent.GlobalInstanceId", this.globalInstanceId));
                }
            }
            try {
                if (LoggingCoreUtilities.convertXsdDateTimeToMilliseconds(this.creationTime) == 0L) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_CREATION_TIME_EXC_", "CommonBaseEvent.CreationTime", this.creationTime));
            }
            if (this.severityESet && (this.severity < 0 || this.severity > 70)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_OUT_OF_RANGE_EXC_", new Short(this.severity), "CommonBaseEvent.Severity", new Short(0), new Short(70)));
            }
            if (this.priorityESet && (this.priority < 0 || this.priority > 100)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_OUT_OF_RANGE_EXC_", new Short(this.priority), "CommonBaseEvent.Priority", new Short(0), new Short(100)));
            }
            if (this.repeatCountESet && this.repeatCount < 0) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_OUT_OF_RANGE_EXC_", new Short(this.repeatCount), "CommonBaseEvent.RepeatCount", new Short(0), new Short(Short.MAX_VALUE)));
            }
            if (this.elapsedTimeESet && this.elapsedTime < 0L) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_OUT_OF_RANGE_EXC_", new Long(this.elapsedTime), "CommonBaseEvent.ElapsedTime", new Long(0L), new Long(Long.MAX_VALUE)));
            }
            if (this.sequenceNumberESet && this.sequenceNumber < 0L) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_OUT_OF_RANGE_EXC_", new Long(this.sequenceNumber), "CommonBaseEvent.SequenceNumber", new Long(0L), new Long(Long.MAX_VALUE)));
            }
            if (this.reporterComponentId != null) {
                this.reporterComponentId.validate();
            }
            if (this.msgDataElement != null) {
                this.msgDataElement.validate();
            }
            this.sourceComponentId.validate();
            this.situation.validate();
            if (this.contextDataElements != null) {
                iterator = this.contextDataElements.listIterator();
                ContextDataElement contextDataElement = null;
                while (iterator.hasNext()) {
                    contextDataElement = (ContextDataElement)iterator.next();
                    try {
                        contextDataElement.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", "CommonBaseEvent.ContextDataElement".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
            if (this.associatedEvents != null) {
                iterator = this.associatedEvents.listIterator();
                AssociatedEvent associatedEvent = null;
                while (iterator.hasNext()) {
                    associatedEvent = (AssociatedEvent)iterator.next();
                    try {
                        associatedEvent.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", "CommonBaseEvent.AssociatedEvent".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
            if (this.extendedDataElements != null) {
                iterator = this.getExtendedDataElements().listIterator();
                ExtendedDataElement extendedDataElement = null;
                while (iterator.hasNext()) {
                    extendedDataElement = (ExtendedDataElement)iterator.next();
                    try {
                        extendedDataElement.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", "CommonBaseEvent.ExtendedDataElement".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
        }
    }

    public String externalizeCanonicalXmlString() {
        return EventFormatter.toCanonicalXMLString(this);
    }

    public String externalizeCanonicalXmlDocString() {
        return EventFormatter.toCanonicalXMLDocString(this);
    }

    public void internalizeCanonicalXmlString(String value) {
        try {
            CommonBaseEvent event = EventFormatter.eventFromCanonicalXML(value);
            if (event != null) {
                TemplateContentHandlerImpl contentHandler = new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(event);
                this.setContentHandler(contentHandler);
                this.complete();
                this.setContentHandler(null);
            }
        }
        catch (Exception exception) {}
    }

    public void internalizeCanonicalXmlDocString(String value) {
        try {
            CommonBaseEvent[] events = EventFormatter.eventsFromCanonicalXMLDoc(value);
            if (events != null && events[0] != null) {
                TemplateContentHandlerImpl contentHandler = new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(events[0]);
                this.setContentHandler(contentHandler);
                this.complete();
                this.setContentHandler(null);
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            return EcoreUtil.copy(this);
        }
    }

    public void init() {
        this.unsetCreationTime();
        this.unsetElapsedTime();
        this.unsetPriority();
        this.unsetRepeatCount();
        this.unsetSequenceNumber();
        this.unsetSeverity();
        this.setExtensionName(EXTENSION_NAME_EDEFAULT);
        this.setLocalInstanceId(LOCAL_INSTANCE_ID_EDEFAULT);
        this.setMsg(MSG_EDEFAULT);
        this.setVersion(VERSION_EDEFAULT);
        this.setGlobalInstanceId(GLOBAL_INSTANCE_ID_EDEFAULT);
        this.clearExtendedDataElements();
        this.clearContextDataElements();
        this.clearAssociatedEvents();
        this.clearAny();
        this.setSituation(null);
        this.setMsgDataElement(null);
        this.setReporterComponentId(null);
        this.setSourceComponentId(null);
        this.isComplete = false;
    }

    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getCommonBaseEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            this.creationTime = (String)in.readObject();
            this.globalInstanceId = (String)in.readObject();
            this.elapsedTime = (Long)in.readObject();
            this.extensionName = (String)in.readObject();
            this.localInstanceId = (String)in.readObject();
            this.msg = (String)in.readObject();
            this.priority = (Short)in.readObject();
            this.repeatCount = (Short)in.readObject();
            this.sequenceNumber = (Long)in.readObject();
            this.severity = (Short)in.readObject();
            this.version = (String)in.readObject();
            this.eSet(anyFeature, in.readObject());
            this.situation = (Situation)in.readObject();
            this.eSet(associatedEventsFeature, in.readObject());
            this.eSet(contextDataElementsFeature, in.readObject());
            this.eSet(extendedDataElementsFeature, in.readObject());
            this.msgDataElement = (MsgDataElement)in.readObject();
            this.reporterComponentId = (ComponentIdentification)in.readObject();
            this.sourceComponentId = (ComponentIdentification)in.readObject();
            this.creationTimeESet = in.readBoolean();
            this.elapsedTimeESet = in.readBoolean();
            this.priorityESet = in.readBoolean();
            this.repeatCountESet = in.readBoolean();
            this.sequenceNumberESet = in.readBoolean();
            this.severityESet = in.readBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            out.writeObject(this.creationTime);
            out.writeObject(this.globalInstanceId);
            out.writeObject(new Long(this.elapsedTime));
            out.writeObject(this.extensionName);
            out.writeObject(this.localInstanceId);
            out.writeObject(this.msg);
            out.writeObject(new Short(this.priority));
            out.writeObject(new Short(this.repeatCount));
            out.writeObject(new Long(this.sequenceNumber));
            out.writeObject(new Short(this.severity));
            out.writeObject(this.version);
            if (this.any != null) {
                out.writeObject(new ArrayList(this.any));
            } else {
                out.writeObject(new ArrayList(0));
            }
            out.writeObject(this.situation);
            if (this.associatedEvents != null) {
                out.writeObject(new ArrayList(this.associatedEvents));
            } else {
                out.writeObject(new ArrayList(0));
            }
            if (this.contextDataElements != null) {
                out.writeObject(new ArrayList(this.contextDataElements));
            } else {
                out.writeObject(new ArrayList(0));
            }
            if (this.extendedDataElements != null) {
                out.writeObject(new ArrayList(this.extendedDataElements));
            } else {
                out.writeObject(new ArrayList(0));
            }
            out.writeObject(this.msgDataElement);
            out.writeObject(this.reporterComponentId);
            out.writeObject(this.sourceComponentId);
            out.writeBoolean(this.creationTimeESet);
            out.writeBoolean(this.elapsedTimeESet);
            out.writeBoolean(this.priorityESet);
            out.writeBoolean(this.repeatCountESet);
            out.writeBoolean(this.sequenceNumberESet);
            out.writeBoolean(this.severityESet);
        }
    }
}

