/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.impl.Element;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    private static final LogHelper log = new LogHelper(XMLHelper.class.getName());

    public static byte[] toByteArr(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            int n = Integer.parseInt(string.substring(i, i + 2), 16);
            byArray[i / 2] = (byte)(n & 0xFF);
        }
        return byArray;
    }

    public static void printHex(byte[] byArray) {
        XMLHelper.printHex(byArray, byArray.length);
    }

    public static void printHex(short[] sArray) {
        XMLHelper.printHex(sArray, sArray.length);
    }

    public static void printHex(int[] nArray) {
        XMLHelper.printHex(nArray, nArray.length);
    }

    public static void printHex(String string, byte[] byArray) {
        XMLHelper.printHex(string, byArray, byArray.length);
    }

    public static void printHex(String string, short[] sArray) {
        XMLHelper.printHex(string, sArray, sArray.length);
    }

    public static void printHex(String string, int[] nArray) {
        XMLHelper.printHex(string, nArray, nArray.length);
    }

    public static String toHexF(String string, byte[] byArray) {
        return XMLHelper.toHexF(string, byArray, byArray.length);
    }

    public static String toHexF(String string, short[] sArray) {
        return XMLHelper.toHexF(string, sArray, sArray.length);
    }

    public static String toHexF(String string, int[] nArray) {
        return XMLHelper.toHexF(string, nArray, nArray.length);
    }

    public static String toHexF(int[] nArray) {
        return XMLHelper.toHexF(nArray, nArray.length);
    }

    public static String toHexF(short[] sArray) {
        return XMLHelper.toHexF(sArray, sArray.length);
    }

    public static String toHexF(byte[] byArray) {
        return XMLHelper.toHexF(byArray, byArray.length);
    }

    public static String toHex(byte[] byArray) {
        return XMLHelper.toHex(byArray, byArray.length);
    }

    public static String toHex(short[] sArray) {
        return XMLHelper.toHex(sArray, sArray.length);
    }

    public static String toHex(int[] nArray) {
        return XMLHelper.toHex(nArray, nArray.length);
    }

    public static void printHex(String string, byte[] byArray, int n) {
        System.out.println(string);
        XMLHelper.printHex(byArray, n);
    }

    public static void printHex(String string, short[] sArray, int n) {
        System.out.println(string);
        XMLHelper.printHex(sArray, n);
    }

    public static void printHex(String string, int[] nArray, int n) {
        System.out.println(string);
        XMLHelper.printHex(nArray, n);
    }

    public static void printHex(byte[] byArray, int n) {
        System.out.print(XMLHelper.toHexF(byArray, n));
    }

    public static void printHex(short[] sArray, int n) {
        System.out.print(XMLHelper.toHexF(sArray, n));
    }

    public static void printHex(int[] nArray, int n) {
        System.out.print(XMLHelper.toHexF(nArray, n));
    }

    public static String toHexF(String string, int[] nArray, int n) {
        return string + "\n" + XMLHelper.toHexF(nArray, n);
    }

    public static String toHexF(String string, short[] sArray, int n) {
        return string + "\n" + XMLHelper.toHexF(sArray, n);
    }

    public static String toHexF(String string, byte[] byArray, int n) {
        return string + "\n" + XMLHelper.toHexF(byArray, n);
    }

    public static String toHexF(byte[] byArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        if (byArray == null) {
            return "<null>";
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(" " + XMLHelper.toHex(byArray[n2]));
            if (n2 % 16 == 15) {
                stringBuffer.append("\n");
                continue;
            }
            if (n2 % 8 == 7) {
                stringBuffer.append(" ");
                continue;
            }
            if (n2 % 4 != 3) continue;
            stringBuffer.append(" ");
        }
        if (n2 % 16 != 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String toHexF(short[] sArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        if (sArray == null) {
            return "<null>";
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(" " + XMLHelper.toHex(sArray[n2]));
            if (n2 % 16 == 7) {
                stringBuffer.append("\n");
                continue;
            }
            if (n2 % 4 != 3) continue;
            stringBuffer.append(" ");
        }
        if (n2 % 8 != 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String toHexF(int[] nArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        if (nArray == null) {
            return "<null>";
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(" " + XMLHelper.toHex(nArray[n2]));
            if (n2 % 4 != 3) continue;
            stringBuffer.append("\n");
        }
        if (n2 % 4 != 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String toHex(int[] nArray, int n) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(XMLHelper.toHex(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHex(short[] sArray, int n) {
        if (sArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(XMLHelper.toHex(sArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(XMLHelper.toHex(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte by) {
        Integer n = new Integer(by << 24 >>> 24);
        int n2 = n;
        if (n2 < 16) {
            return "0" + Integer.toString(n2, 16);
        }
        return Integer.toString(n2, 16);
    }

    public static String toHex(short s) {
        byte[] byArray = new byte[]{(byte)((s & 0xFF00) >>> 8), (byte)(s & 0xFF)};
        return XMLHelper.toHex(byArray[0]) + XMLHelper.toHex(byArray[1]);
    }

    public static String toHex(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        return XMLHelper.toHex(byArray[0]) + XMLHelper.toHex(byArray[1]) + XMLHelper.toHex(byArray[2]) + XMLHelper.toHex(byArray[3]);
    }

    public static String stripNewLinesFromString(String string) {
        int n = string.indexOf(13);
        while (-1 != n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            string = stringBuffer.toString();
            n = string.indexOf(13);
        }
        int n2 = string.indexOf(10);
        while (-1 != n2) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n2);
            string = stringBuffer.toString();
            n2 = string.indexOf(10);
        }
        return string;
    }

    public static String stripWhiteSpaceFromString(String string) {
        int n = string.indexOf(13);
        while (-1 != n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            string = stringBuffer.toString();
            n = string.indexOf(13);
        }
        int n2 = string.indexOf(10);
        while (-1 != n2) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n2);
            string = stringBuffer.toString();
            n2 = string.indexOf(10);
        }
        int n3 = string.indexOf(32);
        while (-1 != n3) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n3);
            string = stringBuffer.toString();
            n3 = string.indexOf(32);
        }
        return string;
    }

    public static IElement toElement(OMElement oMElement) throws Exception {
        Element element = new Element();
        element.set(oMElement);
        return element;
    }

    public static IElement toElement(org.w3c.dom.Element element) throws Exception {
        Element element2 = new Element();
        element2.set(element);
        return element2;
    }

    public static org.w3c.dom.Element toDOM(OMElement oMElement) throws Exception {
        if (null == oMElement) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            oMElement.serialize(byteArrayOutputStream);
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            return null;
        }
        if (0 == byteArrayOutputStream.size()) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(byteArrayInputStream);
        return document.getDocumentElement();
    }

    public static String toString(OMElement oMElement) throws Exception {
        if (null == oMElement) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        oMElement.serialize(byteArrayOutputStream);
        String string = null;
        try {
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ExceptionHelper.Log(log, unsupportedEncodingException);
            throw unsupportedEncodingException;
        }
        return string;
    }

    public static OMElement toOM(org.w3c.dom.Element element) throws Exception {
        if (null == element) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer serializer = SerializerFactory.getSerializer((Properties)properties);
        serializer.setOutputFormat(properties);
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        DOMSerializer dOMSerializer = serializer.asDOMSerializer();
        dOMSerializer.serialize((Node)element);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream);
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        return stAXOMBuilder.getDocumentElement();
    }

    public static String getTextContent(Text text) {
        return text.getNodeValue();
    }

    public static void setTextContent(Text text, String string) {
        text.setNodeValue(string);
    }

    public static String getTextContent(org.w3c.dom.Element element) {
        return element.getTextContent();
    }

    public static void setTextContent(org.w3c.dom.Element element, String string) {
        element.setTextContent(string);
    }

    public static void stripNewLinesFromElement(org.w3c.dom.Element element) {
        if (null == element) {
            return;
        }
        element.normalize();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (3 == node.getNodeType()) {
                Text text = (Text)node;
                String string = XMLHelper.getTextContent(text);
                string = XMLHelper.stripNewLinesFromString(string);
                XMLHelper.setTextContent(text, string);
            }
            if (1 != node.getNodeType()) continue;
            XMLHelper.stripNewLinesFromElement((org.w3c.dom.Element)node);
        }
    }

    public static void stripWhiteSpaceFromElement(org.w3c.dom.Element element) {
        if (null == element) {
            return;
        }
        element.normalize();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (3 == node.getNodeType()) {
                Text text = (Text)node;
                String string = XMLHelper.getTextContent(text);
                string = XMLHelper.stripWhiteSpaceFromString(string);
                XMLHelper.setTextContent(text, string);
            }
            if (1 != node.getNodeType()) continue;
            XMLHelper.stripWhiteSpaceFromElement((org.w3c.dom.Element)node);
        }
    }

    public static String toString(org.w3c.dom.Element element) throws IOException {
        if (null == element) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer serializer = SerializerFactory.getSerializer((Properties)properties);
        serializer.setOutputFormat(properties);
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        DOMSerializer dOMSerializer = serializer.asDOMSerializer();
        dOMSerializer.serialize((Node)element);
        String string = null;
        try {
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ExceptionHelper.Log(log, unsupportedEncodingException);
            throw unsupportedEncodingException;
        }
        return string;
    }

    public static void logElement(org.w3c.dom.Element element) throws IOException {
        String string = XMLHelper.toString(element);
        log.trace(string);
    }

    public static org.w3c.dom.Element toDOM(String string) throws IOException, Exception {
        if (null == string) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            throw exception;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            throw exception;
        }
        return document.getDocumentElement();
    }

    public static org.w3c.dom.Element reparseElement(org.w3c.dom.Element element) throws IOException, Exception {
        if (null == element) {
            return null;
        }
        Document document = element.getOwnerDocument();
        String string = XMLHelper.toString(element);
        org.w3c.dom.Element element2 = XMLHelper.toDOM(string);
        org.w3c.dom.Element element3 = (org.w3c.dom.Element)document.importNode(element2, true);
        return element3;
    }

    public static org.w3c.dom.Element domFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            throw exception;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            throw exception;
        }
        return document.getDocumentElement();
    }

    public static org.w3c.dom.Element domFromFile(String string) throws FileNotFoundException, Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExceptionHelper.Log(log, fileNotFoundException);
            throw fileNotFoundException;
        }
        return XMLHelper.domFromStream(fileInputStream);
    }

    public static OMElement omFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        return stAXOMBuilder.getDocumentElement();
    }

    public static OMElement omFromFile(String string) throws FileNotFoundException, Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExceptionHelper.Log(log, fileNotFoundException);
            throw fileNotFoundException;
        }
        return XMLHelper.omFromStream(fileInputStream);
    }

    public static OMElement toOM(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream);
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        return stAXOMBuilder.getDocumentElement();
    }
}

