/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import org.eclipse.higgins.sts.IObjectFactory;

public class ObjectFactoryHelper {
    public static Object getSingletonFromFactory(String string) throws Exception {
        Class clazz = ObjectFactoryHelper.getFactoryClass(string);
        Object t = clazz.newInstance();
        IObjectFactory iObjectFactory = (IObjectFactory)t;
        return iObjectFactory.getSingletonInstance();
    }

    public static Object getNewInstanceFromFactory(String string) throws Exception {
        Class clazz = ObjectFactoryHelper.getFactoryClass(string);
        Object t = clazz.newInstance();
        IObjectFactory iObjectFactory = (IObjectFactory)t;
        return iObjectFactory.getNewInstance();
    }

    public static Object getFromFactory(String string) throws Exception {
        Class clazz = ObjectFactoryHelper.getFactoryClass(string);
        Object t = clazz.newInstance();
        IObjectFactory iObjectFactory = (IObjectFactory)t;
        return iObjectFactory.getNewInstance();
    }

    private static Class getFactoryClass(String string) throws Exception {
        ClassLoader classLoader = null;
        Exception exception = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (clazz == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception3) {
                if (exception != null) {
                    throw exception;
                }
                throw exception3;
            }
        }
        return clazz;
    }
}

