/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class ExceptionHelper {
    public static void Log(LogHelper logHelper, Exception exception) {
        if (exception instanceof InvocationTargetException) {
            logHelper.error("InvocationTargetException Cause is:");
            InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
            Throwable throwable = invocationTargetException.getCause();
            ExceptionHelper.Log(logHelper, throwable);
        } else {
            String string = exception.getLocalizedMessage();
            if (null != string) {
                logHelper.error(string);
            }
            logHelper.error(exception);
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                String string2 = stackTraceElementArray[i].getClassName() + "::" + stackTraceElementArray[i].getMethodName() + " " + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber();
                logHelper.error(string2);
            }
        }
    }

    public static void Log(LogHelper logHelper, Throwable throwable) {
        if (null == throwable) {
            logHelper.error("ExceptionHelper::Log throwable is null");
        } else if (throwable instanceof InvocationTargetException) {
            logHelper.error("InvocationTargetException Cause is:");
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            Throwable throwable2 = invocationTargetException.getCause();
            ExceptionHelper.Log(logHelper, throwable2);
        } else {
            String string = throwable.getLocalizedMessage();
            if (null != string) {
                logHelper.error(string);
            }
            logHelper.error(throwable);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                String string2 = stackTraceElementArray[i].getClassName() + "::" + stackTraceElementArray[i].getMethodName() + " " + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber();
                logHelper.error(string2);
            }
        }
    }
}

