/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class DateHelper {
    private static final LogHelper log = new LogHelper(DateHelper.class.getName());
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final TimeZone tz = TimeZone.getTimeZone("UTC");

    public static String toString(Date date) {
        FieldPosition fieldPosition = new FieldPosition(0);
        dateFormat.setTimeZone(tz);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = dateFormat.format(date, stringBuffer, fieldPosition);
        return stringBuffer2.toString();
    }

    public static Date toDate(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        dateFormat.setTimeZone(tz);
        try {
            Date date = dateFormat.parse(string.trim(), parsePosition);
            if (null == date) {
                log.trace("toDate returning null");
            }
            return date;
        }
        catch (Exception exception) {
            ExceptionHelper.Log(log, exception);
            return null;
        }
    }
}

