/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.ContextClassLoaderGetter;
import org.eclipse.emf.ecore.impl.DebugStreamInstance;
import org.eclipse.emf.ecore.impl.EFactoryGetter;
import org.eclipse.emf.ecore.impl.EPackageGetter;
import org.eclipse.emf.ecore.impl.ParentClassLoaderGetter;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class EPackageRegistryImpl
extends HashMap
implements EPackage.Registry {
    private static final long serialVersionUID = 1L;
    public static final String className;
    protected static Map classLoaderToRegistryMap;
    protected Object baseHashObject = new Object();
    protected Integer baseHash = new Integer(this.baseHashObject.hashCode());
    protected EPackage.Registry delegateRegistry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.impl.EPackageRegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        EPackageRegistryImpl.debug("static", "Static Initialization", Calendar.getInstance());
        classLoaderToRegistryMap = new WeakHashMap();
    }

    public static boolean debugEnabled() {
        return DebugStreamInstance.debugEnabled;
    }

    public static void debug(String methodName, String text) {
        DebugStreamInstance.debug(className, methodName, text);
    }

    public static void debug(String methodName, String text, Object value) {
        DebugStreamInstance.debug(className, methodName, text, value);
    }

    public static void debugException(String methodName, String text, Exception e) {
        DebugStreamInstance.debugStack(className, methodName, text, e);
    }

    public static void debugStack(String methodName, String text) {
        DebugStreamInstance.debugStack(className, methodName, text);
    }

    public static void debugStack(String methodName, String text, Object value) {
        DebugStreamInstance.debugStack(className, methodName, text, value);
    }

    public static EPackage.Registry createGlobalRegistry() {
        EPackage.Registry registry;
        String methodName = "createGlobalRegistry";
        EPackageRegistryImpl.debug(methodName, "ENTER");
        try {
            String className = System.getProperty("org.eclipse.emf.ecore.EPackage.Registry.INSTANCE");
            if (className != null) {
                EPackageRegistryImpl.debug(methodName, "Using property specified registry class", className);
                registry = (EPackage.Registry)Class.forName(className).newInstance();
            } else if (EcorePlugin.getDefaultRegistryImplementation() != null) {
                EPackageRegistryImpl.debug(methodName, "Null property specified registry; Using specified default implementation");
                registry = EcorePlugin.getDefaultRegistryImplementation();
            } else if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EPackageRegistryImpl.debug(methodName, "Null property specified registry; no default implementation; running eclipse detected: Using basic registry");
                registry = new EPackageRegistryImpl();
            } else {
                EPackageRegistryImpl.debug(methodName, "Null property specified registry; no default implementation; no running eclipse: Using context based registry");
                registry = new Delegator();
            }
        }
        catch (Exception exception) {
            EPackageRegistryImpl.debugException(methodName, "Exception creating registry instance", exception);
            EcorePlugin.INSTANCE.log(exception);
            registry = new EPackageRegistryImpl();
        }
        EPackageRegistryImpl.debug(methodName, "RETURN", registry);
        return registry;
    }

    public static synchronized EPackage.Registry getRegistry(ClassLoader classLoader) {
        EPackage.Registry registry;
        String methodName = "getRegistry";
        boolean debugEnabled = EPackageRegistryImpl.debugEnabled();
        if (debugEnabled) {
            EPackageRegistryImpl.debug(methodName, "ENTRY - classloader", classLoader);
        }
        if ((registry = (EPackage.Registry)classLoaderToRegistryMap.get(classLoader)) == null && classLoader != null) {
            ClassLoader parentClassLoader = System.getSecurityManager() != null ? new ParentClassLoaderGetter().getParent(classLoader) : classLoader.getParent();
            EPackage.Registry parentRegistry = EPackageRegistryImpl.getRegistry(parentClassLoader);
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Lookup on parent", parentClassLoader);
                EPackageRegistryImpl.debug(methodName, "Lookup found registry", EPackageRegistryImpl.getBaseHash(parentRegistry));
                EPackageRegistryImpl.debug(methodName, "Registry size", EPackageRegistryImpl.getSize(parentRegistry));
            }
            registry = new EPackageRegistryImpl(parentRegistry);
            classLoaderToRegistryMap.put(classLoader, registry);
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Stored on classloader", classLoader);
                EPackageRegistryImpl.debug(methodName, "Stored new registry", EPackageRegistryImpl.getBaseHash(registry));
            }
        }
        if (debugEnabled) {
            EPackageRegistryImpl.debug(methodName, "RETURN Registry", EPackageRegistryImpl.getBaseHash(registry));
            EPackageRegistryImpl.debug(methodName, "RETURN Registry size", EPackageRegistryImpl.getSize(registry));
        }
        return registry;
    }

    public Integer getBaseHash() {
        return this.baseHash;
    }

    public static Integer getBaseHash(EPackage.Registry registry) {
        if (registry == null) {
            return new Integer(-1);
        }
        if (registry instanceof EPackageRegistryImpl) {
            return ((EPackageRegistryImpl)registry).getBaseHash();
        }
        return new Integer(registry.hashCode());
    }

    public static Integer getSize(EPackage.Registry registry) {
        if (registry == null) {
            return new Integer(-1);
        }
        return new Integer(registry.size());
    }

    public EPackageRegistryImpl() {
        String methodName = "EPackageRegistryImpl";
        if (EPackageRegistryImpl.debugEnabled()) {
            EPackageRegistryImpl.debug(methodName, "Concrete Type", this.getClass());
            EPackageRegistryImpl.debug(methodName, "Base Hash", EPackageRegistryImpl.getBaseHash(this));
            EPackageRegistryImpl.debugStack(methodName, "Dummy stack for debugging");
            EPackageRegistryImpl.debug(methodName, "RETURN", this);
        }
    }

    public EPackageRegistryImpl(EPackage.Registry delegateRegistry) {
        String methodName = "EPackageRegistryImpl";
        this.delegateRegistry = delegateRegistry;
        if (EPackageRegistryImpl.debugEnabled()) {
            EPackageRegistryImpl.debug(methodName, "Concrete Type", this.getClass());
            EPackageRegistryImpl.debug(methodName, "Base Hash", EPackageRegistryImpl.getBaseHash(this));
            EPackageRegistryImpl.debugStack(methodName, "Dummy stack for debugging");
            EPackageRegistryImpl.debug(methodName, "Delegate", EPackageRegistryImpl.getBaseHash(delegateRegistry));
            EPackageRegistryImpl.debug(methodName, "RETURN", this);
        }
    }

    protected EPackage delegatedGetEPackage(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEPackage(nsURI);
        }
        return null;
    }

    protected EFactory delegatedGetEFactory(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEFactory(nsURI);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPackage getEPackage(String nsURI) {
        String methodName = "getEPackage";
        EPackageRegistryImpl.debug(methodName, "ENTRY", nsURI);
        EPackage resultPackage = null;
        boolean didGet = false;
        EPackageRegistryImpl ePackageRegistryImpl = this;
        synchronized (ePackageRegistryImpl) {
            Object ePackage = this.get(nsURI);
            if (ePackage instanceof EPackage) {
                didGet = true;
                resultPackage = (EPackage)ePackage;
                if (resultPackage.getNsURI() == null) {
                    this.initialize(resultPackage);
                }
            } else if (ePackage instanceof EPackage.Descriptor) {
                didGet = true;
                EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
                resultPackage = ePackageDescriptor.getEPackage();
                if (resultPackage != null) {
                    EPackageRegistryImpl.debug(methodName, "Changing package result", ePackageDescriptor);
                    this.put(nsURI, resultPackage);
                    this.initialize(resultPackage);
                }
            }
        }
        if (!didGet) {
            resultPackage = this.delegatedGetEPackage(nsURI);
        }
        EPackageRegistryImpl.debug(methodName, "RETURN", resultPackage);
        return resultPackage;
    }

    public EFactory getEFactory(String nsURI) {
        EFactory resultFactory;
        Object ePackage;
        boolean debugEnabled = EPackageRegistryImpl.debugEnabled();
        String methodName = "getEFactory";
        if (debugEnabled) {
            EPackageRegistryImpl.debug(methodName, "ENTRY", nsURI);
        }
        if ((ePackage = this.get(nsURI)) instanceof EPackage) {
            EPackage resultPackage;
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Selection resulted in package", ePackage);
            }
            if ((resultPackage = (EPackage)ePackage).getNsURI() == null) {
                this.initialize(resultPackage);
            }
            resultFactory = resultPackage.getEFactoryInstance();
        } else if (ePackage instanceof EPackage.Descriptor) {
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Selection resulted in package descriptor", ePackage);
            }
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            resultFactory = ePackageDescriptor.getEFactory();
        } else {
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Failed on initial lookup (unrecognized type on package)", ePackage);
            }
            resultFactory = this.delegatedGetEFactory(nsURI);
        }
        if (debugEnabled) {
            EPackageRegistryImpl.debug(methodName, "RETURN", resultFactory);
        }
        return resultFactory;
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegateRegistry != null && this.delegateRegistry.containsKey(key);
    }

    protected void initialize(EPackage ePackage) {
    }

    public static void dumpState(StringBuffer buffer) {
        buffer.append("EPackageRegistryImpl:\n");
        buffer.append("==================================================\n");
        EPackageRegistryImpl.displayMap(buffer, "ClassLoaderToRegistryMap", classLoaderToRegistryMap);
        buffer.append("==================================================\n");
    }

    protected static void displayMap(StringBuffer buffer, String title, Map registryMap) {
        buffer.append(title);
        buffer.append("\n");
        Iterator keys = registryMap.keySet().iterator();
        while (keys.hasNext()) {
            ClassLoader nextKey = (ClassLoader)keys.next();
            EPackage.Registry nextRegistry = nextKey == null ? null : (EPackage.Registry)registryMap.get(nextKey);
            buffer.append("  ClassLoader [ ");
            buffer.append(nextKey);
            buffer.append(" ]\n");
            buffer.append("  Registry [ ");
            buffer.append(nextRegistry);
            buffer.append(" ]\n");
        }
    }

    public static class Delegator
    implements EPackage.Registry {
        protected ClassLoader getContextClassLoader() {
            if (System.getSecurityManager() != null) {
                return new ContextClassLoaderGetter().getContextClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }

        protected EPackage.Registry delegateRegistry(ClassLoader classLoader) {
            return EPackageRegistryImpl.getRegistry(classLoader);
        }

        protected EPackage.Registry delegateRegistry() {
            return this.delegateRegistry(this.getContextClassLoader());
        }

        public EPackage getEPackage(String key) {
            EPackage.Registry useDelegate = this.delegateRegistry();
            if (useDelegate == null) {
                return null;
            }
            if (System.getSecurityManager() != null) {
                return new EPackageGetter().getEPackage(useDelegate, key);
            }
            return useDelegate.getEPackage(key);
        }

        public EFactory getEFactory(String key) {
            EPackage.Registry useDelegate = this.delegateRegistry();
            if (useDelegate == null) {
                return null;
            }
            if (System.getSecurityManager() != null) {
                return new EFactoryGetter().getEFactory(useDelegate, key);
            }
            return useDelegate.getEFactory(key);
        }

        protected ClassLoader getParent(ClassLoader classLoader) {
            if (classLoader == null) {
                return null;
            }
            if (System.getSecurityManager() != null) {
                return new ParentClassLoaderGetter().getParent(classLoader);
            }
            return classLoader.getParent();
        }

        public Object put(Object key, Object value) {
            EPackage.Registry useDelegate;
            boolean debugEnabled = EPackageRegistryImpl.debugEnabled();
            String methodName = "put";
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "ENTER key", key);
                EPackageRegistryImpl.debug(methodName, "ENTER value", value);
            }
            Class<?> valueClass = value.getClass();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.ecore.impl.EPackageImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass == clazz) {
                if (debugEnabled) {
                    EPackageRegistryImpl.debug(methodName, "Base EPackageImpl case: Storing in the current context classloader");
                }
                useDelegate = this.delegateRegistry();
            } else {
                if (debugEnabled) {
                    EPackageRegistryImpl.debug(methodName, "Non EPackageImpl case: Storing in the loading classloader");
                }
                String valueClassName = valueClass.getName();
                ClassLoader loadingClassLoader = this.getContextClassLoader();
                if (debugEnabled) {
                    EPackageRegistryImpl.debug(methodName, "Current Context Classloader", loadingClassLoader);
                }
                ClassLoader classLoader = this.getParent(loadingClassLoader);
                while (classLoader != null) {
                    if (debugEnabled) {
                        EPackageRegistryImpl.debug(methodName, "Next parent classloader", classLoader);
                    }
                    try {
                        Class<?> loadedClass = classLoader.loadClass(valueClassName);
                        if (loadedClass != valueClass) break;
                        loadingClassLoader = classLoader;
                    }
                    catch (ClassNotFoundException exception) {
                        break;
                    }
                    classLoader = this.getParent(classLoader);
                }
                if (debugEnabled) {
                    EPackageRegistryImpl.debug(methodName, "Selected classloader", loadingClassLoader);
                }
                useDelegate = this.delegateRegistry(loadingClassLoader);
            }
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "Selected registry", EPackageRegistryImpl.getBaseHash(useDelegate));
                EPackageRegistryImpl.debug(methodName, "Selected registry size", EPackageRegistryImpl.getSize(useDelegate));
            }
            Object oldValue = useDelegate.put(key, value);
            if (debugEnabled) {
                EPackageRegistryImpl.debug(methodName, "RETURN - oldValue", oldValue);
            }
            return oldValue;
        }

        public int size() {
            return this.delegateRegistry().size();
        }

        public boolean isEmpty() {
            return this.delegateRegistry().isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.delegateRegistry().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.delegateRegistry().containsValue(value);
        }

        public Object get(Object key) {
            return this.delegateRegistry().get(key);
        }

        public Object remove(Object key) {
            return this.delegateRegistry().remove(key);
        }

        public void clear() {
            this.delegateRegistry().clear();
        }

        public Set keySet() {
            return this.delegateRegistry().keySet();
        }

        public Collection values() {
            return this.delegateRegistry().values();
        }

        public Set entrySet() {
            return this.delegateRegistry().entrySet();
        }

        public void putAll(Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

