/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.internal.preferences.legacy.PreferenceForwarder;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.BackingStoreException;

public abstract class Plugin
implements BundleActivator {
    public static final String PLUGIN_PREFERENCE_SCOPE = "instance";
    private Bundle bundle;
    private boolean debug = false;
    private IPluginDescriptor descriptor;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    private Preferences preferences = null;

    public Plugin() {
    }

    public Plugin(IPluginDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        Assert.isTrue(!CompatibilityHelper.hasPluginObject(descriptor), NLS.bind(Messages.plugin_deactivatedLoad, this.getClass().getName(), String.valueOf(descriptor.getUniqueIdentifier()) + " is not activated"));
        this.descriptor = descriptor;
        this.bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        try {
            InternalPlatform.start(this.bundle);
        }
        catch (BundleException e) {
            String message = NLS.bind(Messages.plugin_startupProblems, descriptor.getUniqueIdentifier());
            Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
            InternalPlatform.getDefault().log(status);
        }
    }

    public final URL find(IPath path) {
        return FileLocator.find(this.bundle, path, null);
    }

    public final URL find(IPath path, Map override) {
        return FileLocator.find(this.bundle, path, override);
    }

    public final IPluginDescriptor getDescriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        return this.initializeDescriptor(this.bundle.getSymbolicName());
    }

    public final ILog getLog() {
        return InternalPlatform.getDefault().getLog(this.bundle);
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return InternalPlatform.getDefault().getStateLocation(this.bundle, true);
    }

    public final Preferences getPluginPreferences() {
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Plugin preferences already loaded for: " + this.bundle.getSymbolicName());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Loading preferences for plugin: " + this.bundle.getSymbolicName());
        }
        final Bundle bundleCopy = this.bundle;
        final Preferences[] preferencesCopy = new Preferences[1];
        Runnable innerCall = new Runnable(){

            public void run() {
                preferencesCopy[0] = new PreferenceForwarder(this, bundleCopy.getSymbolicName());
            }
        };
        innerCall.run();
        this.preferences = preferencesCopy[0];
        return this.preferences;
    }

    public final void savePluginPreferences() {
        this.getPluginPreferences();
        final Preferences preferencesCopy = this.preferences;
        Runnable innerCall = new Runnable(){

            public void run() {
                try {
                    ((PreferenceForwarder)preferencesCopy).flush();
                }
                catch (BackingStoreException e) {
                    Status status = new Status(4, "org.eclipse.core.runtime", 4, Messages.preferences_saveProblems, e);
                    InternalPlatform.getDefault().log(status);
                }
            }
        };
        innerCall.run();
    }

    protected void initializeDefaultPluginPreferences() {
    }

    public final void internalInitializeDefaultPluginPreferences() {
        this.initializeDefaultPluginPreferences();
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public final InputStream openStream(IPath file) throws IOException {
        return FileLocator.openStream(this.bundle, file, false);
    }

    public final InputStream openStream(IPath file, boolean substituteArgs) throws IOException {
        return FileLocator.openStream(this.bundle, file, substituteArgs);
    }

    public void setDebugging(boolean value) {
        this.debug = value;
    }

    public void shutdown() throws CoreException {
        if (CompatibilityHelper.initializeCompatibility() == null) {
            return;
        }
        Exception exception = null;
        try {
            Method m = this.descriptor.getClass().getMethod("doPluginDeactivation", new Class[0]);
            m.invoke((Object)this.descriptor, null);
        }
        catch (SecurityException e) {
            exception = e;
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        if (exception == null) {
            return;
        }
        String message = NLS.bind(Messages.plugin_shutdownProblems, this.descriptor.getUniqueIdentifier());
        Status status = new Status(4, "org.eclipse.core.runtime", 4, message, exception);
        InternalPlatform.getDefault().log(status);
    }

    public void startup() throws CoreException {
    }

    public String toString() {
        String name = this.bundle.getSymbolicName();
        return name == null ? new Long(this.bundle.getBundleId()).toString() : name;
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        String symbolicName = this.bundle.getSymbolicName();
        if (symbolicName != null) {
            String key = String.valueOf(symbolicName) + "/debug";
            String value = InternalPlatform.getDefault().getOption(key);
            this.debug = value == null ? false : value.equalsIgnoreCase("true");
        }
        this.initializeDescriptor(symbolicName);
    }

    private IPluginDescriptor initializeDescriptor(String symbolicName) {
        if (CompatibilityHelper.initializeCompatibility() == null) {
            return null;
        }
        if (symbolicName == null) {
            return null;
        }
        IPluginDescriptor tmp = CompatibilityHelper.getPluginDescriptor(symbolicName);
        if (!symbolicName.equals("org.eclipse.core.runtime")) {
            this.descriptor = tmp;
        }
        CompatibilityHelper.setPlugin(tmp, this);
        CompatibilityHelper.setActive(tmp);
        return tmp;
    }

    public void stop(BundleContext context) throws Exception {
    }

    public final Bundle getBundle() {
        return this.bundle;
    }
}

