/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Hashtable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static BundleContext context;
    private ServiceRegistration entryLocatorRegistration;
    static /* synthetic */ Class class$0;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext runtimeContext) throws Exception {
        context = runtimeContext;
        InternalPlatform.getDefault().start(runtimeContext);
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(runtimeContext);
    }

    public void stop(BundleContext runtimeContext) {
        this.unregisterEntryLocator();
        InternalPlatform.getDefault().stop(runtimeContext);
        InternalPlatform.getDefault().setRuntimeInstance(null);
    }

    private void registerApplicationService() {
        ParameterizedRunnable work = new ParameterizedRunnable(){

            public Object run(Object arg) throws Exception {
                Object result;
                IPlatformRunnable application = null;
                String applicationId = InternalPlatform.getDefault().getApplicationId();
                if (applicationId == null) {
                    throw new RuntimeException(Messages.application_noIdFound);
                }
                IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
                IExtension applicationExtension = registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                if (applicationExtension == null) {
                    IExtension[] availableApps = registry.getExtensionPoint("org.eclipse.core.runtime.applications").getExtensions();
                    String availableAppsString = "<NONE>";
                    if (availableApps.length != 0) {
                        availableAppsString = availableApps[0].getUniqueIdentifier();
                        int i = 1;
                        while (i < availableApps.length) {
                            availableAppsString = String.valueOf(availableAppsString) + ", " + availableApps[i].getUniqueIdentifier();
                            ++i;
                        }
                    }
                    throw new RuntimeException(NLS.bind(Messages.application_notFound, applicationId, availableAppsString));
                }
                IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                if (configs.length == 0) {
                    throw new RuntimeException(NLS.bind(Messages.application_invalidExtension, applicationId));
                }
                IConfigurationElement config2 = configs[0];
                application = (IPlatformRunnable)config2.createExecutableExtension("run");
                if (arg == null) {
                    arg = InternalPlatform.getDefault().getApplicationArgs();
                }
                int exitCode = (result = application.run(arg)) instanceof Integer ? (Integer)result : 0;
                System.getProperties().setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
                if (InternalPlatform.DEBUG) {
                    System.out.println(NLS.bind(Messages.application_returned, new String[]{applicationId, result == null ? "null" : result.toString()}));
                }
                return result;
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put(PROP_ECLIPSE_APPLICATION, "default");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)work, properties);
    }

    private void unregisterEntryLocator() {
        if (this.entryLocatorRegistration != null) {
            this.entryLocatorRegistration.unregister();
            this.entryLocatorRegistration = null;
        }
    }
}

