/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;

public class LastMessageNumber {
    private long messageNumber;
    private String namespaceValue = null;

    public LastMessageNumber(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    public Object fromOMElement(OMElement msgNumberPart) throws OMException {
        if (msgNumberPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noMessageNumberPartInElement"));
        }
        String msgNoStr = msgNumberPart.getText();
        this.messageNumber = Long.parseLong(msgNoStr);
        return this;
    }

    public OMElement toOMElement(OMElement element, OMNamespace rmNamespace) throws OMException {
        if (this.messageNumber <= 0L) {
            throw new OMException(SandeshaMessageHelper.getMessage("setAValidMsgNumber", Long.toString(this.messageNumber)));
        }
        OMFactory factory = element.getOMFactory();
        OMElement messageNoElement = factory.createOMElement("LastMsgNumber", rmNamespace);
        messageNoElement.setText(Long.toString(this.messageNumber));
        element.addChild(messageNoElement);
        return element;
    }

    public String getNamespaceValue() throws OMException {
        return this.namespaceValue;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

