/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class Expires
implements IOMRMElement {
    private String duration = null;
    private String namespaceValue = null;

    public Expires(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public Object fromOMElement(OMElement element) throws OMException {
        OMElement expiresPart = element.getFirstChildWithName(new QName(this.namespaceValue, "Expires"));
        if (expiresPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noExpiresPartInElement", ((Object)element).toString()));
        }
        String expiresText = expiresPart.getText();
        if (expiresText == null || expiresText == "") {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotProcessExpires"));
        }
        this.duration = expiresText;
        return element;
    }

    public String getNamespaceValue() throws OMException {
        return this.namespaceValue;
    }

    public OMElement toOMElement(OMElement element) throws OMException {
        if (this.duration == null || this.duration == "") {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotProcessExpires"));
        }
        OMFactory factory = element.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement expiresElement = factory.createOMElement("Expires", rmNamespace);
        expiresElement.setText(this.duration);
        element.addChild(expiresElement);
        return element;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

