/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class Endpoint
implements IOMRMElement {
    private EndpointReference epr;
    private String rmNamespaceValue = null;
    private String addressingNamespaceValue = null;

    public Endpoint(String rmNamespaceValue) throws AxisFault {
        if (!this.isNamespaceSupported(rmNamespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", rmNamespaceValue));
        }
        this.rmNamespaceValue = rmNamespaceValue;
    }

    public Endpoint(EndpointReference epr, String rmNamespaceValue, String addressingNamespaceValue) throws AxisFault {
        this(rmNamespaceValue);
        this.addressingNamespaceValue = addressingNamespaceValue;
        this.epr = epr;
    }

    public String getNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public Object fromOMElement(OMElement endpointElement) throws OMException, AxisFault {
        this.epr = EndpointReferenceHelper.fromOM(endpointElement);
        if (this.epr == null) {
            String message = SandeshaMessageHelper.getMessage("invalidElementFoundWithinElement", "EPR", "Endpoint");
            throw new SandeshaException(message);
        }
        Iterator children = endpointElement.getChildElements();
        while (children.hasNext() && this.addressingNamespaceValue == null) {
            OMElement child = (OMElement)children.next();
            if (!"Address".equals(child.getLocalName())) continue;
            this.addressingNamespaceValue = child.getNamespace().getNamespaceURI();
        }
        return this;
    }

    public OMElement toOMElement(OMElement element) throws OMException, AxisFault {
        if (this.epr == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotSetEndpoint", null));
        }
        OMFactory factory = element.getOMFactory();
        QName endpoint = new QName(this.rmNamespaceValue, "Endpoint", "wsrm");
        OMElement endpointElement = EndpointReferenceHelper.toOM(factory, this.epr, endpoint, this.addressingNamespaceValue);
        element.addChild(endpointElement);
        return element;
    }

    public EndpointReference getEPR() {
        return this.epr;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

