/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.util.LoggingControl;

public class WorkerLock {
    static final Log log = LogFactory.getLog(WorkerLock.class);
    private ConcurrentHashMap locks = new ConcurrentHashMap();

    public boolean addWork(String work, Object owner) {
        Holder h;
        Holder prev;
        boolean result;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: WorkerLock::addWork " + work + ", " + owner);
        }
        boolean bl = result = (prev = this.locks.putIfAbsent(work, h = new Holder(owner))) == null;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: WorkerLock::addWork " + result);
        }
        return result;
    }

    public void awaitRemoval(String work) throws InterruptedException {
        Holder h;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: WorkerLock::awaitRemoval " + work);
        }
        if ((h = (Holder)this.locks.get(work)) != null) {
            h.awaitRelease();
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: WorkerLock::awaitRemoval");
        }
    }

    public void removeWork(String work) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: WorkerLock::removeWork " + work);
        }
        Holder h = (Holder)this.locks.remove(work);
        h.release();
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: WorkerLock::removeWork");
        }
    }

    public boolean isWorkPresent(String work) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: WorkerLock::isWorkPresent " + work);
        }
        boolean value = this.locks.containsKey(work);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: WorkerLock::isWorkPresent " + value);
        }
        return value;
    }

    public boolean ownsLock(String work, Object owner) {
        Holder h;
        Object realOwner;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: WorkerLock::ownsLock " + work + " ," + owner);
        }
        Object object = realOwner = (h = (Holder)this.locks.get(work)) != null ? h.getValue() : null;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: WorkerLock::ownsLock " + Boolean.valueOf(realOwner == owner));
        }
        return realOwner == owner;
    }

    private static class Holder {
        CountDownLatch latch = new CountDownLatch(1);
        Object value;

        public Holder(Object newValue) {
            this.value = newValue;
        }

        public void awaitRelease() throws InterruptedException {
            this.latch.await();
        }

        public void release() {
            this.latch.countDown();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

