/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.LoggingControl;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;

public class TerminateManager {
    private static Log log = LogFactory.getLog(TerminateManager.class);
    private static String CLEANED_ON_TERMINATE_MSG = "CleanedOnTerminateMsg";
    private static String CLEANED_AFTER_INVOCATION = "CleanedAfterInvocation";
    private static HashMap receivingSideCleanMap = new HashMap();

    public static void checkAndTerminate(ConfigurationContext configurationContext, StorageManager storageManager, RMSBean rmsBean) throws SandeshaStorageException, AxisFault {
        long lastOutMessage;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::checkAndTerminate " + rmsBean);
        }
        if ((lastOutMessage = rmsBean.getLastOutMessage()) > 0L && !rmsBean.isTerminateAdded()) {
            boolean complete = AcknowledgementManager.verifySequenceCompletion(rmsBean.getClientCompletedMessages(), lastOutMessage);
            String rmVersion = rmsBean.getRMVersion();
            EndpointReference replyTo = rmsBean.getReplyToEndpointReference();
            if (complete && "Spec_2007_02".equals(rmVersion) && replyTo != null && SandeshaUtil.isWSRMAnonymous(replyTo.getAddress())) {
                RMDBean findBean = new RMDBean();
                findBean.setPollingMode(true);
                findBean.setToEndpointReference(replyTo);
                RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
                List beans = rmdBeanMgr.find(findBean);
                if (beans.isEmpty()) {
                    rmsBean.setTerminationPauserForCS(true);
                    storageManager.getRMSBeanMgr().update(rmsBean);
                    complete = false;
                }
            }
            if (complete && "Spec_2005_02".equals(rmVersion) && (replyTo == null || replyTo.hasAnonymousAddress())) {
                SenderBean matcher = new SenderBean();
                matcher.setMessageType(3);
                matcher.setSequenceID(rmsBean.getSequenceID());
                List matches = storageManager.getSenderBeanMgr().find(matcher);
                if (!matches.isEmpty()) {
                    complete = false;
                }
            }
            if (complete) {
                String referenceMsgKey = rmsBean.getReferenceMessageStoreKey();
                if (referenceMsgKey == null) {
                    String message = SandeshaMessageHelper.getMessage("referenceMessageNotSetForSequence", rmsBean.getSequenceID());
                    throw new SandeshaException(message);
                }
                MessageContext referenceMessage = storageManager.retrieveMessageContext(referenceMsgKey, configurationContext);
                if (referenceMessage == null) {
                    String message = SandeshaMessageHelper.getMessage("referencedMessageNotFound", rmsBean.getSequenceID());
                    throw new SandeshaException(message);
                }
                RMMsgContext referenceRMMsg = MsgInitializer.initializeMessage(referenceMessage);
                TerminateManager.addTerminateSequenceMessage(referenceRMMsg, rmsBean.getInternalSequenceID(), rmsBean.getSequenceID(), storageManager);
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::checkAndTerminate");
        }
    }

    public static void cleanReceivingSideOnTerminateMessage(ConfigurationContext configContext, String sequenceId, StorageManager storageManager) throws SandeshaException {
        SenderBean findAckBean = new SenderBean();
        findAckBean.setSequenceID(sequenceId);
        findAckBean.setMessageType(4);
        SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
        for (SenderBean ackBean : senderBeanMgr.find(findAckBean)) {
            senderBeanMgr.delete(ackBean.getMessageID());
            storageManager.removeMessageContext(ackBean.getMessageContextRefKey());
        }
        boolean inOrderInvocation = SandeshaUtil.getDefaultPropertyBean(configContext.getAxisConfiguration()).isInOrder();
        if (!inOrderInvocation) {
            receivingSideCleanMap.put(sequenceId, CLEANED_ON_TERMINATE_MSG);
            TerminateManager.cleanReceivingSideAfterInvocation(sequenceId, storageManager);
        } else {
            String cleanStatus = (String)receivingSideCleanMap.get(sequenceId);
            if (cleanStatus != null && CLEANED_AFTER_INVOCATION.equals(cleanStatus)) {
                receivingSideCleanMap.remove(sequenceId);
            } else {
                receivingSideCleanMap.put(sequenceId, CLEANED_ON_TERMINATE_MSG);
            }
        }
    }

    public static void cleanReceivingSideAfterInvocation(String sequenceId, StorageManager storageManager) throws SandeshaException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::cleanReceivingSideAfterInvocation " + sequenceId);
        }
        InvokerBeanMgr invokerBeanMgr = storageManager.getInvokerBeanMgr();
        InvokerBean invokerFindBean = new InvokerBean();
        invokerFindBean.setSequenceID(sequenceId);
        List collection = invokerBeanMgr.find(invokerFindBean);
        for (InvokerBean invokerBean : collection) {
            String messageStoreKey = invokerBean.getMessageContextRefKey();
            invokerBeanMgr.delete(messageStoreKey);
            storageManager.removeMessageContext(messageStoreKey);
        }
        String cleanStatus = (String)receivingSideCleanMap.get(sequenceId);
        if (cleanStatus != null && CLEANED_ON_TERMINATE_MSG.equals(cleanStatus)) {
            receivingSideCleanMap.remove(sequenceId);
        } else {
            receivingSideCleanMap.put(sequenceId, CLEANED_AFTER_INVOCATION);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::cleanReceivingSideAfterInvocation");
        }
    }

    public static boolean terminateSendingSide(RMSBean rmsBean, StorageManager storageManager, boolean reallocate, Transaction transaction) throws SandeshaException {
        rmsBean.setTerminated(true);
        rmsBean.setTerminateAdded(true);
        storageManager.getRMSBeanMgr().update(rmsBean);
        return TerminateManager.cleanSendingSideData(rmsBean.getInternalSequenceID(), storageManager, rmsBean, reallocate, transaction);
    }

    public static void timeOutSendingSideSequence(String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
        rmsBean.setTimedOut(true);
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        storageManager.getRMSBeanMgr().update(rmsBean);
        TerminateManager.cleanSendingSideData(internalSequenceId, storageManager, rmsBean, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean cleanSendingSideData(String internalSequenceId, StorageManager storageManager, RMSBean rmsBean, boolean reallocateIfPossible, Transaction transaction) throws SandeshaException {
        boolean reallocatedOK;
        block27: {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug("Enter: TerminateManager::cleanSendingSideData " + internalSequenceId + ", " + reallocateIfPossible);
            }
            reallocatedOK = false;
            SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
            List collection = retransmitterBeanMgr.find(internalSequenceId);
            Iterator iterator = collection.iterator();
            LinkedList<MessageContext> msgsToReallocate = null;
            if (reallocateIfPossible) {
                msgsToReallocate = new LinkedList<MessageContext>();
            }
            Range[] ranges = rmsBean.getClientCompletedMessages().getRanges();
            long lastAckedMsg = -1L;
            if (ranges.length == 1) {
                lastAckedMsg = ranges[0].upperValue;
            } else if (reallocateIfPossible) {
                rmsBean.setReallocated(-1);
                storageManager.getRMSBeanMgr().update(rmsBean);
                reallocateIfPossible = false;
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug("cannot reallocate sequence as there are gaps");
                }
            }
            while (iterator.hasNext()) {
                SenderBean retransmitterBean = (SenderBean)iterator.next();
                if (retransmitterBean.getMessageType() == 7 && !rmsBean.isTerminated()) continue;
                String messageStoreKey = retransmitterBean.getMessageContextRefKey();
                if (reallocateIfPossible && retransmitterBean.getMessageType() == 3 && retransmitterBean.getMessageNumber() == lastAckedMsg + 1L) {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug("adding message for reallocate: " + retransmitterBean.getMessageNumber());
                    }
                    msgsToReallocate.add(storageManager.retrieveMessageContext(messageStoreKey, storageManager.getContext()));
                    retransmitterBeanMgr.delete(retransmitterBean.getMessageID());
                    storageManager.removeMessageContext(messageStoreKey);
                    ++lastAckedMsg;
                    continue;
                }
                if (reallocateIfPossible) {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug("cannot reallocate: " + retransmitterBean.getMessageNumber());
                    }
                    if (msgsToReallocate.size() != 0) continue;
                    try {
                        MessageContext dummy = SandeshaUtil.cloneMessageContext(storageManager.retrieveMessageContext(messageStoreKey, storageManager.getContext()));
                        dummy.getOptions().setProperty("Sandesha2DummyMessage", "true");
                        msgsToReallocate.add(dummy);
                        continue;
                    }
                    catch (Exception e) {
                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                            log.debug("Exit: TerminateManager::cleanSendingSideData " + e);
                        }
                        throw new SandeshaStorageException(e);
                    }
                }
                retransmitterBeanMgr.delete(retransmitterBean.getMessageID());
                storageManager.removeMessageContext(messageStoreKey);
            }
            if (reallocateIfPossible) {
                try {
                    try {
                        SandeshaUtil.reallocateMessagesToNewSequence(storageManager, rmsBean, msgsToReallocate, transaction);
                        reallocatedOK = true;
                        transaction = storageManager.getTransaction();
                        if (rmsBean.isReallocated() == 2) {
                            rmsBean.setReallocated(0);
                            storageManager.getRMSBeanMgr().update(rmsBean);
                        }
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                        }
                        transaction = null;
                    }
                    catch (Exception e) {
                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                            log.warn(SandeshaMessageHelper.getMessage("reallocationFailed", rmsBean.getSequenceID(), e.toString()));
                        }
                        transaction = storageManager.getTransaction();
                        rmsBean.setReallocated(-1);
                        storageManager.getRMSBeanMgr().update(rmsBean);
                        String intSeqIDOfOriginallyReallocatedSeq = rmsBean.getInternalSeqIDOfSeqUsedForReallocation();
                        if (intSeqIDOfOriginallyReallocatedSeq != null) {
                            RMSBean origRMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, intSeqIDOfOriginallyReallocatedSeq);
                            origRMSBean.setReallocated(-1);
                            storageManager.getRMSBeanMgr().update(origRMSBean);
                        }
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                        }
                        transaction = null;
                        Object var17_18 = null;
                        if (transaction != null && transaction.isActive()) {
                            transaction.rollback();
                        }
                        break block27;
                    }
                    Object var17_17 = null;
                    if (transaction == null || !transaction.isActive()) break block27;
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw throwable;
                }
                transaction.rollback();
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::cleanSendingSideData " + reallocatedOK);
        }
        return reallocatedOK;
    }

    public static void addTerminateSequenceMessage(RMMsgContext referenceMessage, String internalSequenceID, String outSequenceId, StorageManager storageManager) throws AxisFault {
        RMSBean rmsBean;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::addTerminateSequenceMessage " + outSequenceId + ", " + internalSequenceID);
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID)).isTerminateAdded()) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug("Exit: TerminateManager::addTerminateSequenceMessage - terminate was added previously.");
            }
            return;
        }
        RMMsgContext terminateRMMessage = RMMsgCreator.createTerminateSequenceMessage(referenceMessage, rmsBean, storageManager);
        terminateRMMessage.setFlow(2);
        terminateRMMessage.setProperty("Sandesha2AppProcessingDone", "true");
        EndpointReference toEPR = null;
        if (rmsBean.getOfferedEndPointEPR() != null) {
            toEPR = rmsBean.getOfferedEndPointEPR();
        } else if (rmsBean.getOfferedEndPoint() != null) {
            toEPR = new EndpointReference(rmsBean.getOfferedEndPoint());
        }
        if (toEPR == null && rmsBean.getToEndpointReference() != null && (toEPR = rmsBean.getToEndpointReference()) == null) {
            String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
            throw new SandeshaException(message);
        }
        if (toEPR != null) {
            terminateRMMessage.setTo(toEPR);
        }
        if (rmsBean.getReplyToEndpointReference() != null) {
            terminateRMMessage.setReplyTo(rmsBean.getReplyToEndpointReference());
        }
        String rmVersion = rmsBean.getRMVersion();
        terminateRMMessage.setWSAAction(SpecSpecificConstants.getTerminateSequenceAction(rmVersion));
        terminateRMMessage.setSOAPAction(SpecSpecificConstants.getTerminateSequenceSOAPAction(rmVersion));
        if (rmsBean.getTransportTo() != null) {
            terminateRMMessage.setProperty("TransportURL", rmsBean.getTransportTo());
        }
        terminateRMMessage.addSOAPEnvelope();
        String key = SandeshaUtil.getUUID();
        SenderBean terminateBean = new SenderBean();
        terminateBean.setInternalSequenceID(internalSequenceID);
        terminateBean.setSequenceID(outSequenceId);
        terminateBean.setMessageContextRefKey(key);
        terminateBean.setMessageType(7);
        terminateBean.setTimeToSend(System.currentTimeMillis() + 100L);
        terminateBean.setMessageID(terminateRMMessage.getMessageId());
        terminateBean.setSend(true);
        terminateRMMessage.getMessageContext().setProperty("Sandesha2QualifiedForSending", "false");
        terminateBean.setReSend(false);
        terminateBean.setSequenceID(outSequenceId);
        terminateBean.setMessageType(7);
        terminateBean.setInternalSequenceID(internalSequenceID);
        EndpointReference to = terminateRMMessage.getTo();
        if (to != null) {
            terminateBean.setToAddress(to.getAddress());
        }
        if (to == null || to.hasAnonymousAddress()) {
            terminateBean.setTransportAvailable(false);
        }
        rmsBean.setTerminateAdded(true);
        storageManager.getRMSBeanMgr().update(rmsBean);
        terminateRMMessage.setProperty("Sandesha2SetSendToTrue", "true");
        SandeshaUtil.executeAndStore(terminateRMMessage, key, storageManager);
        SenderBeanMgr retramsmitterMgr = storageManager.getSenderBeanMgr();
        retramsmitterMgr.insert(terminateBean);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::addTerminateSequenceMessage");
        }
    }
}

