/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.FaultData;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SOAPFaultEnvelopeCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceFault;

public class FaultManager {
    private static final Log log = LogFactory.getLog(FaultManager.class);

    public static void checkForLastMsgNumberExceeded(RMMsgContext applicationRMMessage, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::checkForLastMsgNumberExceeded");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::checkForLastMsgNumberExceeded");
        }
    }

    public static RMMsgContext checkForMessageNumberRoleover(MessageContext messageContext) {
        return null;
    }

    public static boolean checkForUnknownSequence(RMMsgContext rmMessageContext, String sequenceID, StorageManager storageManager, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::checkForUnknownSequence, " + sequenceID);
        }
        boolean validSequence = false;
        if (SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID) != null) {
            validSequence = true;
        } else if (SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID) != null) {
            validSequence = true;
        }
        if (!validSequence) {
            if (log.isDebugEnabled()) {
                log.debug("Sequence not valid " + sequenceID);
            }
            MessageContext messageContext = rmMessageContext.getMessageContext();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
            FaultData data = new FaultData();
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 1));
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            data.setReason(SandeshaMessageHelper.getMessage("unknownSequenceFault", sequenceID));
            data.setType(1);
            if (log.isDebugEnabled()) {
                log.debug("Exit: FaultManager::checkForUnknownSequence, Sequence unknown");
            }
            boolean faultThrowable = !piggybackedMessage;
            FaultManager.getOrSendFault(rmMessageContext, data, faultThrowable, null);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::checkForUnknownSequence");
        }
        return false;
    }

    public static boolean checkForInvalidAcknowledgement(RMMsgContext ackRMMessageContext, SequenceAcknowledgement sequenceAcknowledgement, StorageManager storageManager, RMSBean rmsBean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::checkForInvalidAcknowledgement");
        }
        boolean invalidAck = false;
        List sequenceAckList = sequenceAcknowledgement.getAcknowledgementRanges();
        for (Range acknowledgementRange : sequenceAckList) {
            if (acknowledgementRange.lowerValue > acknowledgementRange.upperValue) {
                invalidAck = true;
            } else if (acknowledgementRange.upperValue > rmsBean.getHighestOutMessageNumber()) {
                invalidAck = true;
            }
            if (!invalidAck) continue;
            FaultManager.makeInvalidAcknowledgementFault(ackRMMessageContext, sequenceAcknowledgement, acknowledgementRange, storageManager, piggybackedMessage, rmsBean.getToEndpointReference());
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::checkForInvalidAcknowledgement: ack is valid");
        }
        return false;
    }

    public static void makeInvalidAcknowledgementFault(RMMsgContext rmMsgCtx, SequenceAcknowledgement sequenceAcknowledgement, Range acknowledgementRange, StorageManager storageManager, boolean piggybackedMessage, EndpointReference acksToEPR) throws AxisFault {
        FaultData data = new FaultData();
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(rmMsgCtx.getMessageContext().getEnvelope());
        if (SOAPVersion2 == 1) {
            data.setCode("Client");
        } else {
            data.setCode("Sender");
        }
        if (log.isDebugEnabled()) {
            log.debug("makingInvalidAck piggy=" + piggybackedMessage + ": soap=" + SOAPVersion2);
        }
        data.setType(3);
        data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMsgCtx.getRMNamespaceValue(), 3));
        data.setReason(SandeshaMessageHelper.getMessage("invalidAckFault"));
        data.setDetail(sequenceAcknowledgement.getOriginalSequenceAckElement());
        boolean throwable = !piggybackedMessage;
        FaultManager.getOrSendFault(rmMsgCtx, data, throwable, acksToEPR);
    }

    public static void makeCreateSequenceRefusedFault(RMMsgContext rmMessageContext, String detail, Exception e, EndpointReference acksToEPR) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::makeCreateSequenceRefusedFault, " + detail);
        }
        MessageContext messageContext = rmMessageContext.getMessageContext();
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
        FaultData data = new FaultData();
        if (SOAPVersion2 == 1) {
            data.setCode("Client");
        } else {
            data.setCode("Sender");
        }
        data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 4));
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
        OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
        identifierElement.setText(detail);
        data.setDetail(identifierElement);
        data.setDetailString(detail);
        data.setReason(SandeshaMessageHelper.getMessage("createSequenceRefused"));
        data.setType(4);
        data.setExceptionString(SandeshaUtil.getStackTraceFromException(e));
        if (log.isWarnEnabled()) {
            log.warn(SandeshaMessageHelper.getMessage("createSequenceRefused"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::makeCreateSequenceRefusedFault");
        }
        FaultManager.getOrSendFault(rmMessageContext, data, true, acksToEPR);
    }

    public static void makeUnsupportedSelectionFault(RMMsgContext rmMessageContext, QName unsupportedElement) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::makeUnsupportedSelectionFault, " + unsupportedElement);
        }
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(rmMessageContext.getMessageContext().getEnvelope());
        FaultData data = new FaultData();
        if (SOAPVersion2 == 1) {
            data.setCode("Server");
        } else {
            data.setCode("Receiver");
        }
        data.setSubcode(SpecSpecificConstants.getFaultSubcode("http://docs.oasis-open.org/ws-rx/wsmc/200702", 8));
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
        OMElement element = factory.createOMElement("UnsupportedElement", "http://docs.oasis-open.org/ws-rx/wsmc/200702", "wsmc");
        element.setText(unsupportedElement);
        data.setDetail(element);
        data.setReason(SandeshaMessageHelper.getMessage("unsuportedSelectionFault"));
        data.setType(8);
        FaultManager.makeMakeConnectionFault(rmMessageContext, data);
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::makeUnsupportedSelectionFault");
        }
    }

    public static void makeMissingSelectionFault(RMMsgContext rmMessageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::makeMissingSelectionFault");
        }
        int SOAPVersion2 = SandeshaUtil.getSOAPVersion(rmMessageContext.getMessageContext().getEnvelope());
        FaultData data = new FaultData();
        if (SOAPVersion2 == 1) {
            data.setCode("Server");
        } else {
            data.setCode("Receiver");
        }
        data.setSubcode(SpecSpecificConstants.getFaultSubcode("http://docs.oasis-open.org/ws-rx/wsmc/200702", 9));
        data.setDetail(null);
        data.setReason(SandeshaMessageHelper.getMessage("missingSelectionFault"));
        data.setType(9);
        FaultManager.makeMakeConnectionFault(rmMessageContext, data);
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::makeMissingSelectionFault");
        }
    }

    private static void makeMakeConnectionFault(RMMsgContext referenceRMMsgContext, FaultData data) throws AxisFault {
        String SOAPNamespaceValue;
        SOAPFactory factory = (SOAPFactory)referenceRMMsgContext.getSOAPEnvelope().getOMFactory();
        SOAPFaultCode faultCode = factory.createSOAPFaultCode();
        SOAPFaultSubCode faultSubCode = factory.createSOAPFaultSubCode(faultCode);
        SOAPFaultValue faultColdValue = factory.createSOAPFaultValue(faultCode);
        SOAPFaultValue faultSubcodeValue = factory.createSOAPFaultValue(faultSubCode);
        faultSubcodeValue.setText(data.getSubcode());
        faultCode.setSubCode(faultSubCode);
        SOAPFaultReason reason = factory.createSOAPFaultReason();
        SOAPFaultText reasonText = factory.createSOAPFaultText();
        reasonText.setText(data.getReason());
        SOAPFaultDetail detail = factory.createSOAPFaultDetail();
        if (data.getDetail() != null) {
            detail.addDetailEntry(data.getDetail());
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(SOAPNamespaceValue = factory.getSoapVersionURI())) {
            reasonText.setLang("en");
            reason.addSOAPText(reasonText);
            referenceRMMsgContext.setProperty("Code", faultCode);
            referenceRMMsgContext.setProperty("Reason", reason);
            referenceRMMsgContext.setProperty("Detail", detail);
            faultColdValue.setText(data.getCode());
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(SOAPNamespaceValue)) {
            reason.setText(data.getReason());
            referenceRMMsgContext.setProperty("faultcode", faultCode);
            referenceRMMsgContext.setProperty("detail", detail);
            referenceRMMsgContext.setProperty("faultstring", reason);
            faultColdValue.setText(data.getSubcode());
        }
        AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
        fault.setFaultAction("http://docs.oasis-open.org/ws-rx/wsmc/200702/fault");
        throw fault;
    }

    public static boolean checkForSequenceTerminated(RMMsgContext referenceRMMessage, String sequenceID, RMSequenceBean bean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::checkForSequenceTerminated, " + sequenceID);
        }
        if (bean != null && bean.isTerminated()) {
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            FaultData data = new FaultData();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope());
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(referenceRMMessage.getRMNamespaceValue(), 7));
            data.setReason(SandeshaMessageHelper.getMessage("sequenceTerminatedFault", sequenceID));
            data.setType(7);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
            OMElement identifierElement = factory.createOMElement("Identifier", rmNamespaceValue, "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            if (log.isDebugEnabled()) {
                log.debug("Exit: FaultManager::checkForSequenceTerminated, sequence terminated");
            }
            boolean throwable = !piggybackedMessage;
            FaultManager.getOrSendFault(referenceRMMessage, data, throwable, bean.getAcksToEndpointReference());
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::checkForSequenceTerminated");
        }
        return false;
    }

    public static boolean checkForSequenceClosed(RMMsgContext referenceRMMessage, String sequenceID, RMDBean rmdBean, boolean piggybackedMessage) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::checkForSequenceClosed, " + sequenceID);
        }
        if (rmdBean != null && rmdBean.isClosed()) {
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            FaultData data = new FaultData();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope());
            if (SOAPVersion2 == 1) {
                data.setCode("Client");
            } else {
                data.setCode("Sender");
            }
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(referenceRMMessage.getRMNamespaceValue(), 6));
            data.setReason(SandeshaMessageHelper.getMessage("cannotAcceptMsgAsSequenceClosedFault"));
            data.setType(6);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
            OMElement identifierElement = factory.createOMElement("Identifier", rmNamespaceValue, "wsrm");
            identifierElement.setText(sequenceID);
            data.setDetail(identifierElement);
            if (log.isDebugEnabled()) {
                log.debug("Exit: FaultManager::checkForSequenceClosed, sequence closed");
            }
            boolean throwable = !piggybackedMessage;
            FaultManager.getOrSendFault(referenceRMMessage, data, throwable, rmdBean.getAcksToEndpointReference());
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::checkForSequenceClosed");
        }
        return false;
    }

    public static void getOrSendFault(RMMsgContext referenceRMMsgContext, FaultData data, boolean throwable, EndpointReference acksToEPR) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::getOrSendFault: " + referenceRMMsgContext + "," + data + "," + throwable + "," + acksToEPR);
        }
        SOAPFactory factory = (SOAPFactory)referenceRMMsgContext.getSOAPEnvelope().getOMFactory();
        SOAPFaultCode faultCode = factory.createSOAPFaultCode();
        SOAPFaultSubCode faultSubCode = factory.createSOAPFaultSubCode(faultCode);
        SOAPFaultValue faultColdValue = factory.createSOAPFaultValue(faultCode);
        SOAPFaultValue faultSubcodeValue = factory.createSOAPFaultValue(faultSubCode);
        faultColdValue.setText(data.getCode());
        faultSubcodeValue.setText(data.getSubcode());
        faultCode.setSubCode(faultSubCode);
        SOAPFaultReason reason = factory.createSOAPFaultReason();
        SOAPFaultText reasonText = factory.createSOAPFaultText();
        reasonText.setText(data.getReason());
        SOAPFaultDetail detail = factory.createSOAPFaultDetail();
        detail.addDetailEntry(data.getDetail());
        String SOAPNamespaceValue = factory.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(SOAPNamespaceValue)) {
            reasonText.setLang("en");
            reason.addSOAPText(reasonText);
            referenceRMMsgContext.setProperty("Code", faultCode);
            referenceRMMsgContext.setProperty("Reason", reason);
            referenceRMMsgContext.setProperty("Detail", detail);
            AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
            fault.setFaultAction(SpecSpecificConstants.getAddressingFaultAction(referenceRMMsgContext.getRMSpecVersion()));
            if (throwable) {
                if (referenceRMMsgContext.getMessageContext().isServerSide()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: FaultManager::getOrSendFault: " + fault);
                    }
                    throw fault;
                }
            } else {
                log.error("Sandesha2 got a fault when processing the message " + referenceRMMsgContext.getMessageId(), fault);
            }
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(SOAPNamespaceValue)) {
            reason.setText(data.getReason());
            referenceRMMsgContext.setProperty("faultcode", faultCode);
            referenceRMMsgContext.setProperty("detail", detail);
            referenceRMMsgContext.setProperty("faultstring", reason);
            MessageContext faultMessageContext = MessageContextBuilder.createFaultMessageContext(referenceRMMsgContext.getMessageContext(), null);
            if (acksToEPR != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Debug: FaultManager::getOrSendFault: rewrriting fault destination EPR to " + acksToEPR);
                }
                faultMessageContext.setTo(acksToEPR);
            }
            SOAPFaultEnvelopeCreator.addSOAPFaultEnvelope(faultMessageContext, 1, data, referenceRMMsgContext.getRMNamespaceValue());
            faultMessageContext.setWSAAction(SpecSpecificConstants.getAddressingFaultAction(referenceRMMsgContext.getRMSpecVersion()));
            if (throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending fault message " + faultMessageContext.getEnvelope().getHeader());
                }
                try {
                    AxisEngine.sendFault(faultMessageContext);
                    EndpointReference destination = faultMessageContext.getTo();
                    if (destination == null || destination.hasAnonymousAddress()) {
                        TransportUtils.setResponseWritten(referenceRMMsgContext.getMessageContext(), true);
                    }
                }
                catch (Exception e) {
                    AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
                    String message = SandeshaMessageHelper.getMessage("couldNotSendFaultDueToException", fault.getMessage(), e.getMessage());
                    log.error(message);
                }
            } else {
                AxisFault fault = new AxisFault(faultColdValue.getTextAsQName(), data.getReason(), "", "", data.getDetail());
                String message = SandeshaMessageHelper.getMessage("couldNotSendFaultDueToException", fault.getMessage());
                log.error(message);
            }
        } else {
            String message = SandeshaMessageHelper.getMessage("unknownSoapVersion");
            throw new SandeshaException(message);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::getOrSendFault");
        }
    }

    public static boolean isRMFault(String faultSubcodeValue) {
        if (faultSubcodeValue == null) {
            return false;
        }
        return "CreateSequenceRefused".equalsIgnoreCase(faultSubcodeValue) || "InvalidAcknowledgement".equalsIgnoreCase(faultSubcodeValue) || "LastMessageNumberExceeded".equalsIgnoreCase(faultSubcodeValue) || "MessageNumberRollover".equalsIgnoreCase(faultSubcodeValue) || "SequenceClosed".equalsIgnoreCase(faultSubcodeValue) || "SequenceTerminated".equalsIgnoreCase(faultSubcodeValue) || "UnknownSequence".equalsIgnoreCase(faultSubcodeValue);
    }

    private static Handler.InvocationResponse manageIncomingFault(AxisFault fault, RMMsgContext rmMsgCtx, SOAPFault faultPart, Transaction transaction) throws AxisFault {
        SOAPFaultDetail detail;
        SandeshaListener listner;
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::manageIncomingFault");
        }
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        if (log.isErrorEnabled()) {
            log.error(fault);
        }
        if ((listner = (SandeshaListener)rmMsgCtx.getProperty("Sandesha2Listener")) != null) {
            listner.onError(fault);
        }
        SOAPFactory factory = (SOAPFactory)rmMsgCtx.getSOAPEnvelope().getOMFactory();
        String SOAPNamespaceValue = factory.getSoapVersionURI();
        String soapFaultSubcode = null;
        String identifier = null;
        boolean isSOAP11SequenceUnknownFault = false;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(SOAPNamespaceValue)) {
            SequenceFault sequenceFault;
            if (log.isDebugEnabled()) {
                log.debug("soap11");
            }
            if ((sequenceFault = rmMsgCtx.getSequenceFault()) != null) {
                soapFaultSubcode = sequenceFault.getFaultCode().getFaultCode().getLocalPart();
                identifier = sequenceFault.getFaultCode().getDetail();
                isSOAP11SequenceUnknownFault = true;
                if (log.isDebugEnabled()) {
                    log.debug("isSOAP11SequenceUnknownFault " + identifier);
                }
            }
        }
        if (soapFaultSubcode == null && faultPart.getCode() != null && faultPart.getCode().getSubCode() != null && faultPart.getCode().getSubCode().getValue() != null) {
            soapFaultSubcode = faultPart.getCode().getSubCode().getValue().getTextAsQName().getLocalPart();
        }
        if ((detail = faultPart.getDetail()) != null && !isSOAP11SequenceUnknownFault) {
            OMElement identifierOM = detail.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Identifier"));
            if (identifierOM != null) {
                identifier = identifierOM.getText();
            } else {
                identifierOM = detail.getFirstChildWithName(new QName("http://docs.oasis-open.org/ws-rx/wsrm/200702", "Identifier"));
                if (identifierOM != null) {
                    identifier = identifierOM.getText();
                }
            }
        }
        if ("CreateSequenceRefused".equals(soapFaultSubcode)) {
            FaultManager.processCreateSequenceRefusedFault(rmMsgCtx, fault);
        } else if ("UnknownSequence".equals(soapFaultSubcode) || "SequenceTerminated".equals(soapFaultSubcode) || "MessageNumberRollover".equals(soapFaultSubcode)) {
            FaultManager.processSequenceUnknownFault(rmMsgCtx, fault, identifier, transaction);
        }
        if (FaultManager.isRMFault(soapFaultSubcode)) {
            response = Handler.InvocationResponse.ABORT;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::manageIncomingFault, " + response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler.InvocationResponse processMessagesForFaults(RMMsgContext rmMsgCtx, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::processMessagesForFaults");
        }
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        boolean isFault = FaultManager.isRMFaultAction(rmMsgCtx.getMessageContext().getWSAAction());
        if (isFault) {
            Transaction transaction = null;
            try {
                transaction = storageManager.getTransaction();
                SOAPEnvelope envelope = rmMsgCtx.getSOAPEnvelope();
                if (envelope == null) {
                    Handler.InvocationResponse invocationResponse = response;
                    return invocationResponse;
                }
                SOAPFault faultPart = envelope.getBody().getFault();
                AxisFault axisFault = FaultManager.getAxisFaultFromFromSOAPFault(faultPart, rmMsgCtx);
                response = FaultManager.manageIncomingFault(axisFault, rmMsgCtx, faultPart, transaction);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::processMessagesForFaults, " + response);
        }
        return response;
    }

    private static boolean isRMFaultAction(String action) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::processMessagesForFaults , " + action);
        }
        boolean isFaultAction = false;
        if ("http://www.w3.org/2005/08/addressing/fault".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/fault".equals(action)) {
            isFaultAction = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::processMessagesForFaults , " + isFaultAction);
        }
        return isFaultAction;
    }

    private static AxisFault getAxisFaultFromFromSOAPFault(SOAPFault faultPart, RMMsgContext rmMsgCtx) {
        String soapFaultSubcode = null;
        SequenceFault sequenceFault = rmMsgCtx.getSequenceFault();
        AxisFault axisFault = null;
        if (sequenceFault != null) {
            soapFaultSubcode = sequenceFault.getFaultCode().getFaultCode().getLocalPart();
            StringBuffer faultSB = new StringBuffer();
            faultSB.append(soapFaultSubcode + " ");
            faultSB.append(sequenceFault.getFaultCode().getDetail() + " ");
            faultSB.append(faultPart.getDetail().getText());
            axisFault = new AxisFault(faultSB.toString(), sequenceFault.getFaultCode().getFaultCode());
        } else {
            axisFault = new AxisFault(faultPart.getCode(), faultPart.getReason(), faultPart.getNode(), faultPart.getRole(), faultPart.getDetail());
        }
        return axisFault;
    }

    public static boolean checkForMessageRolledOver(RMMsgContext rmMessageContext, String sequenceId, long msgNo, RMDBean bean) throws AxisFault {
        if (msgNo == Long.MAX_VALUE) {
            if (log.isDebugEnabled()) {
                log.debug("Max message number reached " + msgNo);
            }
            MessageContext messageContext = rmMessageContext.getMessageContext();
            int SOAPVersion2 = SandeshaUtil.getSOAPVersion(messageContext.getEnvelope());
            FaultData data = new FaultData();
            data.setCode("Client");
            data.setSubcode(SpecSpecificConstants.getFaultSubcode(rmMessageContext.getRMNamespaceValue(), 2));
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SOAPVersion2);
            OMElement identifierElement = factory.createOMElement("Identifier", rmMessageContext.getRMNamespaceValue(), "wsrm");
            identifierElement.setText(sequenceId);
            OMElement maxMsgNumber = factory.createOMElement("MaxMessageNumber", rmMessageContext.getRMNamespaceValue(), "wsrm");
            maxMsgNumber.setText(Long.toString(msgNo));
            data.setDetail(identifierElement);
            data.setDetail2(maxMsgNumber);
            data.setReason(SandeshaMessageHelper.getMessage("messageNumberRollover"));
            data.setType(2);
            FaultManager.getOrSendFault(rmMessageContext, data, true, bean.getAcksToEndpointReference());
            return true;
        }
        return false;
    }

    private static void processCreateSequenceRefusedFault(RMMsgContext rmMsgCtx, AxisFault fault) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::processCreateSequenceRefusedFault");
        }
        ConfigurationContext configCtx = rmMsgCtx.getMessageContext().getConfigurationContext();
        if (log.isWarnEnabled()) {
            AxisService axisSvc;
            MessageContext mCtx;
            String name = "NOT_SET";
            if (rmMsgCtx != null && (mCtx = rmMsgCtx.getMessageContext()) != null && (axisSvc = mCtx.getAxisService()) != null) {
                name = axisSvc.getName();
            }
            log.warn(SandeshaMessageHelper.getMessage("reliableMessagingNotEnabled", name));
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, configCtx.getAxisConfiguration());
        RelatesTo relatesTo = rmMsgCtx.getMessageContext().getRelatesTo();
        String createSeqMsgId = null;
        if (relatesTo != null) {
            createSeqMsgId = relatesTo.getValue();
        } else {
            OperationContext context = rmMsgCtx.getMessageContext().getOperationContext();
            MessageContext createSeq = context.getMessageContext("Out");
            if (createSeq != null) {
                createSeqMsgId = createSeq.getMessageID();
            }
        }
        if (createSeqMsgId == null) {
            String message = SandeshaMessageHelper.getMessage("relatesToNotAvailable");
            log.error(message);
            throw new SandeshaException(message);
        }
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean rmsBean = rmsBeanMgr.retrieve(createSeqMsgId);
        if (rmsBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: FaultManager::processCreateSequenceRefusedFault Unable to find RMSBean");
            }
            return;
        }
        if (rmsBean.getSequenceID() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: FaultManager::processCreateSequenceRefusedFault Sequence already established - no requirement to cleanup");
            }
            return;
        }
        rmsBean.setLastSendError(fault);
        rmsBean.setTerminated(true);
        rmsBeanMgr.update(rmsBean);
        SenderBean createSequenceSenderBean = retransmitterMgr.retrieve(createSeqMsgId);
        if (createSequenceSenderBean == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("createSeqEntryNotFound"));
        }
        retransmitterMgr.delete(createSeqMsgId);
        FaultManager.notifyClientsOfFault(rmsBean.getInternalSequenceID(), storageManager, configCtx, fault);
        rmMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug("Terminating sending sequence " + rmsBean);
        }
        TerminateManager.terminateSendingSide(rmsBean, storageManager, false, null);
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::processCreateSequenceRefusedFault");
        }
    }

    private static void processSequenceUnknownFault(RMMsgContext rmMsgCtx, AxisFault fault, String sequenceID, Transaction transaction) throws AxisFault {
        ConfigurationContext configCtx;
        StorageManager storageManager;
        RMSBean rmsBean;
        if (log.isDebugEnabled()) {
            log.debug("Enter: FaultManager::processSequenceUnknownFault " + sequenceID);
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx = rmMsgCtx.getMessageContext().getConfigurationContext(), configCtx.getAxisConfiguration()), sequenceID)) != null) {
            rmMsgCtx.pause();
            if (log.isDebugEnabled()) {
                log.debug("Terminating sending sequence " + rmsBean);
            }
            if (!TerminateManager.terminateSendingSide(rmsBean, storageManager, true, transaction)) {
                FaultManager.notifyClientsOfFault(rmsBean.getInternalSequenceID(), storageManager, configCtx, fault);
                transaction = storageManager.getTransaction();
                rmsBean.setLastActivatedTime(System.currentTimeMillis());
                storageManager.getRMSBeanMgr().update(rmsBean);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
            }
        } else {
            RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
            if (rmdBean != null) {
                rmMsgCtx.pause();
                if (log.isDebugEnabled()) {
                    log.debug("Terminating sending sequence " + rmdBean);
                }
                TerminateManager.cleanReceivingSideOnTerminateMessage(configCtx, rmdBean.getSequenceID(), storageManager);
                rmdBean.setLastActivatedTime(System.currentTimeMillis());
                storageManager.getRMDBeanMgr().update(rmdBean);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: FaultManager::processSequenceUnknownFault Unable to find sequence");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: FaultManager::processSequenceUnknownFault");
        }
    }

    static void notifyClientsOfFault(String internalSequenceId, StorageManager storageManager, ConfigurationContext configCtx, AxisFault fault) throws SandeshaException {
        SenderBean target = new SenderBean();
        target.setInternalSequenceID(internalSequenceId);
        for (SenderBean tempBean : storageManager.getSenderBeanMgr().find(target)) {
            MessageReceiver msgReceiver;
            String messageStoreKey;
            MessageContext context;
            AxisOperation axisOperation;
            if (tempBean.getMessageType() == 11 || tempBean.getMessageType() == 4 || (axisOperation = (context = storageManager.retrieveMessageContext(messageStoreKey = tempBean.getMessageContextRefKey(), configCtx)).getAxisOperation()) == null || (msgReceiver = axisOperation.getMessageReceiver()) == null || !(msgReceiver instanceof CallbackReceiver)) continue;
            Object callback = ((CallbackReceiver)msgReceiver).lookupCallback(context.getMessageID());
            if (callback instanceof Callback) {
                try {
                    ((CallbackReceiver)msgReceiver).addCallback(context.getMessageID(), (Callback)callback);
                }
                catch (AxisFault axisFault) {
                    throw new SandeshaException(axisFault);
                }
                ((Callback)callback).onError(fault);
                continue;
            }
            if (!(callback instanceof AxisCallback)) continue;
            try {
                ((CallbackReceiver)msgReceiver).addCallback(context.getMessageID(), (AxisCallback)callback);
            }
            catch (AxisFault axisFault) {
                throw new SandeshaException(axisFault);
            }
            ((AxisCallback)callback).onError(fault);
        }
    }
}

