/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;

public class TerminateSeqResponseMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(TerminateSeqResponseMsgProcessor.class);

    public boolean processInMessage(RMMsgContext terminateResRMMsg, Transaction transaction) throws AxisFault {
        PollingManager manager;
        RMDBeanMgr rMDBeanMgr;
        RMDBean rMDBean;
        if (log.isDebugEnabled()) {
            log.debug("Enter: TerminateSeqResponseMsgProcessor::processInMessage");
        }
        MessageContext msgContext = terminateResRMMsg.getMessageContext();
        ConfigurationContext context = terminateResRMMsg.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        TerminateSequenceResponse tsResponse = terminateResRMMsg.getTerminateSequenceResponse();
        String sequenceId = tsResponse.getIdentifier().getIdentifier();
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceId);
        SandeshaUtil.assertProofOfPossession(rmsBean, msgContext, msgContext.getEnvelope().getBody());
        msgContext.setProperty("Sandesha2InternalSequenceId", rmsBean.getInternalSequenceID());
        String offeredSeq = rmsBean.getOfferedSequence();
        if (offeredSeq != null && (rMDBean = (rMDBeanMgr = storageManager.getRMDBeanMgr()).retrieve(offeredSeq)) != null && rMDBean.isPollingMode() && (manager = storageManager.getPollingManager()) != null) {
            manager.schedulePollingRequest(rMDBean.getSequenceID(), false);
        }
        TerminateManager.terminateSendingSide(rmsBean, storageManager, false, null);
        terminateResRMMsg.pause();
        if (log.isDebugEnabled()) {
            log.debug("Exit: TerminateSeqResponseMsgProcessor::processInMessage " + Boolean.TRUE);
        }
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: TerminateSeqResponseMsgProcessor::processOutMessage");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: TerminateSeqResponseMsgProcessor::processOutMessage " + Boolean.FALSE);
        }
        return false;
    }
}

